/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.schemainfo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.util.Hashtable;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.db.ISQLAliasExt;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.schemainfo.SchemaInfoCache;
import net.sourceforge.squirrel_sql.client.util.ApplicationFiles;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.util.IMessageHandler;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class SchemaInfoCacheSerializer {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SchemaInfoCacheSerializer.class);
    private static final ILogger s_log = LoggerController.createLogger(SchemaInfoCacheSerializer.class);
    private static Hashtable<IIdentifier, IIdentifier> _storingSessionIDs = new Hashtable();

    public static SchemaInfoCache load(ISession session) {
        SchemaInfoCache ret = SchemaInfoCacheSerializer.privateLoad(session);
        ret.setSession(session);
        return ret;
    }

    private static SchemaInfoCache privateLoad(ISession session) {
        File schemaCacheFile = SchemaInfoCacheSerializer.getSchemaCacheFile(session.getAlias());
        if (!session.getAlias().getSchemaProperties().fetchExpectsSomeCachedData()) {
            try {
                if (schemaCacheFile.exists() && !schemaCacheFile.delete()) {
                    s_log.error("Failed to delete Schema cache file " + schemaCacheFile.getPath());
                }
            }
            catch (Exception e) {
                s_log.error("Could not delete Schema cache file " + schemaCacheFile.getPath(), e);
            }
            return new SchemaInfoCache();
        }
        if (!schemaCacheFile.exists()) {
            return new SchemaInfoCache();
        }
        try {
            FileInputStream fis = new FileInputStream(schemaCacheFile);
            ObjectInputStream ois = new ObjectInputStream(fis){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    ClassLoader loader = SchemaInfoCache.class.getClassLoader();
                    return Class.forName(desc.getName(), false, loader);
                }
            };
            SchemaInfoCache ret = (SchemaInfoCache)ois.readObject();
            ois.close();
            fis.close();
            ret.replaceDatabaseObjectTypeConstantObjectsByConstantObjectsOfThisVM();
            return ret;
        }
        catch (Exception e) {
            s_log.error("Failed to load Schema cache. Note: this can happen when the SQuirreL version changed", e);
            return new SchemaInfoCache();
        }
    }

    public static void store(final ISession session, final SchemaInfoCache schemaInfoCache) {
        _storingSessionIDs.put(session.getIdentifier(), session.getIdentifier());
        session.getApplication().getThreadPool().addTask(new Runnable(){

            @Override
            public void run() {
                SchemaInfoCacheSerializer.privateStore(schemaInfoCache, session);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void privateStore(SchemaInfoCache schemaInfoCache, ISession session) {
        try {
            if (!session.getAlias().getSchemaProperties().fetchExpectsSomeCachedData()) {
                return;
            }
            IMessageHandler msgHandler = session.getApplication().getMessageHandler();
            File schemaCacheFile = SchemaInfoCacheSerializer.getSchemaCacheFile(session.getAlias());
            String[] params = new String[]{session.getAlias().getName(), schemaCacheFile.getPath()};
            msgHandler.showMessage(s_stringMgr.getString("SchemaInfoCacheSerializer.beginStore", params));
            schemaInfoCache.prepareSerialization();
            FileOutputStream fos = new FileOutputStream(schemaCacheFile);
            ObjectOutputStream oOut = new ObjectOutputStream(fos);
            oOut.writeObject(schemaInfoCache);
            oOut.close();
            fos.close();
            msgHandler.showMessage(s_stringMgr.getString("SchemaInfoCacheSerializer.endStore", params));
        }
        catch (Exception e) {
            s_log.error("Failed to write Schema cache file ", e);
        }
        finally {
            Class<SchemaInfoCacheSerializer> clazz = SchemaInfoCacheSerializer.class;
            synchronized (SchemaInfoCacheSerializer.class) {
                _storingSessionIDs.remove(session.getIdentifier());
                if (0 == _storingSessionIDs.size()) {
                    SchemaInfoCacheSerializer.class.notifyAll();
                }
                // ** MonitorExit[var2_5] (shouldn't be in output)
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitTillStoringIsDone() {
        try {
            Class<SchemaInfoCacheSerializer> clazz = SchemaInfoCacheSerializer.class;
            synchronized (SchemaInfoCacheSerializer.class) {
                for (int i = 0; 0 < _storingSessionIDs.size() || i >= 30; ++i) {
                    SchemaInfoCacheSerializer.class.wait(1000L);
                }
                // ** MonitorExit[var0] (shouldn't be in output)
            }
        }
        catch (InterruptedException e) {
            s_log.error("Error waiting for SchemaInfoCacheSerializer to finish storing", e);
        }
        {
            return;
        }
    }

    public static File getSchemaCacheFile(ISQLAliasExt alias) {
        String uniquePrefix = ((Object)alias.getIdentifier()).toString();
        uniquePrefix = uniquePrefix.replace(':', '_').replace(File.separatorChar, '-');
        String path = new ApplicationFiles().getUserSettingsDirectory().getPath() + File.separator + "schemacaches" + File.separator + uniquePrefix + "_schemacache.ser";
        File ret = new File(path);
        ret.getParentFile().mkdirs();
        return ret;
    }

    public static void aliasRemoved(SQLAlias alias) {
        File schemaCacheFile = SchemaInfoCacheSerializer.getSchemaCacheFile(alias);
        if (schemaCacheFile.exists()) {
            schemaCacheFile.delete();
        }
    }

    public static void deleteCacheFile(IApplication app, ISQLAliasExt alias, boolean verbose) {
        String aliasName;
        File schemaCacheFile = SchemaInfoCacheSerializer.getSchemaCacheFile(alias);
        String string = aliasName = null == alias.getName() || 0 == alias.getName().trim().length() ? "<unnamed>" : alias.getName();
        if (schemaCacheFile.exists()) {
            if (schemaCacheFile.delete()) {
                app.getMessageHandler().showMessage(s_stringMgr.getString("SchemaInfoCacheSerializer.cacheDeleted", schemaCacheFile.getPath()));
            } else {
                app.getMessageHandler().showWarningMessage(s_stringMgr.getString("SchemaInfoCacheSerializer.cacheDeleteFailed", schemaCacheFile.getPath()));
            }
        } else if (verbose) {
            app.getMessageHandler().showWarningMessage(s_stringMgr.getString("SchemaInfoCacheSerializer.cacheToDelNotExists", aliasName));
        }
    }
}

