/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.skin;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import org.jvnet.substance.api.ColorSchemeAssociationKind;
import org.jvnet.substance.api.ColorSchemeTransform;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.api.SubstanceColorSchemeBundle;
import org.jvnet.substance.api.SubstanceSkin;
import org.jvnet.substance.painter.border.CompositeBorderPainter;
import org.jvnet.substance.painter.border.DelegateBorderPainter;
import org.jvnet.substance.painter.border.StandardBorderPainter;
import org.jvnet.substance.painter.decoration.DecorationAreaType;
import org.jvnet.substance.painter.decoration.SubstanceDecorationPainter;
import org.jvnet.substance.painter.gradient.StandardGradientPainter;
import org.jvnet.substance.painter.highlight.ClassicHighlightPainter;
import org.jvnet.substance.painter.utils.SeparatorPainterUtils;
import org.jvnet.substance.shaper.ClassicButtonShaper;
import org.jvnet.substance.utils.SubstanceColorSchemeUtilities;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class OfficeBlue2007Skin
extends SubstanceSkin {
    public static final String NAME = "Office Blue 2007";

    public OfficeBlue2007Skin() {
        SubstanceColorScheme activeScheme = SubstanceColorSchemeUtilities.getColorScheme(OfficeBlue2007Skin.class.getClassLoader().getResource("org/jvnet/substance/skin/office-blue-active.colorscheme"));
        SubstanceColorScheme defaultScheme = SubstanceColorSchemeUtilities.getColorScheme(OfficeBlue2007Skin.class.getClassLoader().getResource("org/jvnet/substance/skin/office-blue-default.colorscheme"));
        SubstanceColorSchemeBundle defaultSchemeBundle = new SubstanceColorSchemeBundle(activeScheme, defaultScheme, defaultScheme);
        defaultSchemeBundle.registerColorScheme(defaultScheme, 0.5f, ComponentState.DISABLED_UNSELECTED);
        defaultSchemeBundle.registerColorScheme(activeScheme, 0.5f, ComponentState.DISABLED_SELECTED);
        SubstanceColorScheme rolloverScheme = SubstanceColorSchemeUtilities.getColorScheme(OfficeBlue2007Skin.class.getClassLoader().getResource("org/jvnet/substance/skin/office-blue-rollover.colorscheme"));
        SubstanceColorScheme rolloverSelectedScheme = SubstanceColorSchemeUtilities.getColorScheme(OfficeBlue2007Skin.class.getClassLoader().getResource("org/jvnet/substance/skin/office-blue-rollover-selected.colorscheme"));
        SubstanceColorScheme selectedScheme = SubstanceColorSchemeUtilities.getColorScheme(OfficeBlue2007Skin.class.getClassLoader().getResource("org/jvnet/substance/skin/office-blue-selected.colorscheme"));
        SubstanceColorScheme pressedScheme = SubstanceColorSchemeUtilities.getColorScheme(OfficeBlue2007Skin.class.getClassLoader().getResource("org/jvnet/substance/skin/office-blue-pressed.colorscheme"));
        SubstanceColorScheme pressedSelectedScheme = SubstanceColorSchemeUtilities.getColorScheme(OfficeBlue2007Skin.class.getClassLoader().getResource("org/jvnet/substance/skin/office-blue-pressed-selected.colorscheme"));
        defaultSchemeBundle.registerColorScheme(rolloverScheme, ComponentState.ROLLOVER_UNSELECTED);
        defaultSchemeBundle.registerColorScheme(rolloverSelectedScheme, ComponentState.ROLLOVER_SELECTED);
        defaultSchemeBundle.registerColorScheme(selectedScheme, ComponentState.SELECTED);
        defaultSchemeBundle.registerColorScheme(pressedScheme, ComponentState.PRESSED_UNSELECTED);
        defaultSchemeBundle.registerColorScheme(pressedSelectedScheme, ComponentState.PRESSED_SELECTED);
        defaultSchemeBundle.registerHighlightColorScheme(rolloverScheme, 0.8f, ComponentState.ROLLOVER_UNSELECTED);
        defaultSchemeBundle.registerHighlightColorScheme(selectedScheme, 0.8f, ComponentState.SELECTED);
        defaultSchemeBundle.registerHighlightColorScheme(rolloverSelectedScheme, 0.8f, ComponentState.ROLLOVER_SELECTED);
        defaultSchemeBundle.registerHighlightColorScheme(selectedScheme, 0.8f, ComponentState.ARMED, ComponentState.ROLLOVER_ARMED);
        SubstanceColorScheme borderDefaultScheme = SubstanceColorSchemeUtilities.getColorScheme(OfficeBlue2007Skin.class.getClassLoader().getResource("org/jvnet/substance/skin/office-blue-border-default.colorscheme"));
        SubstanceColorScheme borderActiveScheme = SubstanceColorSchemeUtilities.getColorScheme(OfficeBlue2007Skin.class.getClassLoader().getResource("org/jvnet/substance/skin/office-blue-border-active.colorscheme"));
        SubstanceColorScheme borderRolloverScheme = SubstanceColorSchemeUtilities.getColorScheme(OfficeBlue2007Skin.class.getClassLoader().getResource("org/jvnet/substance/skin/office-border-rollover.colorscheme"));
        SubstanceColorScheme borderRolloverSelectedScheme = SubstanceColorSchemeUtilities.getColorScheme(OfficeBlue2007Skin.class.getClassLoader().getResource("org/jvnet/substance/skin/office-border-rollover-selected.colorscheme"));
        SubstanceColorScheme borderSelectedScheme = SubstanceColorSchemeUtilities.getColorScheme(OfficeBlue2007Skin.class.getClassLoader().getResource("org/jvnet/substance/skin/office-border-selected.colorscheme"));
        SubstanceColorScheme borderPressedScheme = SubstanceColorSchemeUtilities.getColorScheme(OfficeBlue2007Skin.class.getClassLoader().getResource("org/jvnet/substance/skin/office-border-pressed.colorscheme"));
        defaultSchemeBundle.registerColorScheme(borderDefaultScheme, ColorSchemeAssociationKind.BORDER, ComponentState.DEFAULT);
        defaultSchemeBundle.registerColorScheme(borderDefaultScheme, ColorSchemeAssociationKind.BORDER, ComponentState.DISABLED_SELECTED, ComponentState.DISABLED_UNSELECTED);
        defaultSchemeBundle.registerColorScheme(borderActiveScheme, ColorSchemeAssociationKind.BORDER, ComponentState.ACTIVE);
        defaultSchemeBundle.registerColorScheme(borderRolloverScheme, ColorSchemeAssociationKind.BORDER, ComponentState.ROLLOVER_UNSELECTED);
        defaultSchemeBundle.registerColorScheme(borderRolloverSelectedScheme, ColorSchemeAssociationKind.BORDER, ComponentState.ROLLOVER_SELECTED, ComponentState.ARMED, ComponentState.ROLLOVER_ARMED);
        defaultSchemeBundle.registerColorScheme(borderSelectedScheme, ColorSchemeAssociationKind.BORDER, ComponentState.SELECTED);
        defaultSchemeBundle.registerColorScheme(borderPressedScheme, ColorSchemeAssociationKind.BORDER, ComponentState.PRESSED_SELECTED, ComponentState.PRESSED_UNSELECTED);
        SubstanceColorScheme tabSelectedScheme = SubstanceColorSchemeUtilities.getColorScheme(OfficeBlue2007Skin.class.getClassLoader().getResource("org/jvnet/substance/skin/office-blue-tab-selected.colorscheme"));
        SubstanceColorScheme tabRolloverScheme = SubstanceColorSchemeUtilities.getColorScheme(OfficeBlue2007Skin.class.getClassLoader().getResource("org/jvnet/substance/skin/office-blue-tab-rollover.colorscheme"));
        defaultSchemeBundle.registerColorScheme(tabSelectedScheme, ColorSchemeAssociationKind.TAB, ComponentState.SELECTED, ComponentState.ROLLOVER_SELECTED, ComponentState.PRESSED_SELECTED, ComponentState.PRESSED_UNSELECTED);
        defaultSchemeBundle.registerColorScheme(tabRolloverScheme, ColorSchemeAssociationKind.TAB, ComponentState.ROLLOVER_UNSELECTED);
        defaultSchemeBundle.registerColorScheme(borderDefaultScheme, ColorSchemeAssociationKind.TAB_BORDER, ComponentState.SELECTED, ComponentState.ROLLOVER_UNSELECTED);
        defaultSchemeBundle.registerColorScheme(rolloverSelectedScheme, ColorSchemeAssociationKind.TAB_BORDER, ComponentState.ROLLOVER_SELECTED);
        SubstanceColorScheme separatorScheme = SubstanceColorSchemeUtilities.getColorScheme(OfficeBlue2007Skin.class.getClassLoader().getResource("org/jvnet/substance/skin/office-blue-separator.colorscheme"));
        defaultSchemeBundle.registerColorScheme(separatorScheme, ColorSchemeAssociationKind.SEPARATOR, new ComponentState[0]);
        this.registerDecorationAreaSchemeBundle(defaultSchemeBundle, DecorationAreaType.NONE);
        this.watermarkScheme = SubstanceColorSchemeUtilities.getColorScheme(OfficeBlue2007Skin.class.getClassLoader().getResource("org/jvnet/substance/skin/office-blue-watermark.colorscheme"));
        SubstanceColorScheme generalWatermarkScheme = SubstanceColorSchemeUtilities.getColorScheme(OfficeBlue2007Skin.class.getClassLoader().getResource("org/jvnet/substance/skin/office-blue-header-watermark.colorscheme"));
        this.registerAsDecorationArea(generalWatermarkScheme, DecorationAreaType.FOOTER, DecorationAreaType.HEADER, DecorationAreaType.TOOLBAR);
        SubstanceColorScheme titleWatermarkScheme = SubstanceColorSchemeUtilities.getColorScheme(OfficeBlue2007Skin.class.getClassLoader().getResource("org/jvnet/substance/skin/office-blue-title-watermark.colorscheme"));
        this.registerAsDecorationArea(titleWatermarkScheme, DecorationAreaType.GENERAL, DecorationAreaType.PRIMARY_TITLE_PANE, DecorationAreaType.SECONDARY_TITLE_PANE);
        this.setSelectedTabFadeStart(0.7);
        this.setSelectedTabFadeEnd(0.9);
        this.buttonShaper = new ClassicButtonShaper();
        this.watermark = null;
        this.gradientPainter = new OfficeBlue2007GradientPainter();
        this.decorationPainter = new OfficeBlue2007DecorationPainter();
        this.borderPainter = new OfficeBlue2007BorderPainter();
        this.highlightPainter = new ClassicHighlightPainter();
    }

    @Override
    public String getDisplayName() {
        return NAME;
    }

    private class OfficeBlue2007GradientPainter
    extends StandardGradientPainter {
        private OfficeBlue2007GradientPainter() {
        }

        @Override
        public Color getTopShineColor(SubstanceColorScheme interpolationScheme1, SubstanceColorScheme interpolationScheme2, double cycleCoef, boolean useCyclePosAsInterpolation) {
            return null;
        }

        @Override
        public Color getBottomShineColor(SubstanceColorScheme interpolationScheme1, SubstanceColorScheme interpolationScheme2, double cycleCoef, boolean useCyclePosAsInterpolation) {
            return null;
        }

        @Override
        public Color getTopFillColor(SubstanceColorScheme interpolationScheme1, SubstanceColorScheme interpolationScheme2, double cycleCoef, boolean useCyclePosAsInterpolation) {
            if (!useCyclePosAsInterpolation) {
                return interpolationScheme1.getUltraLightColor();
            }
            return new Color(SubstanceColorUtilities.getInterpolatedRGB(interpolationScheme1.getUltraLightColor(), interpolationScheme2.getUltraLightColor(), cycleCoef));
        }

        @Override
        public Color getMidFillColorTop(SubstanceColorScheme interpolationScheme1, SubstanceColorScheme interpolationScheme2, double cycleCoef, boolean useCyclePosAsInterpolation) {
            if (!useCyclePosAsInterpolation) {
                return interpolationScheme1.getLightColor();
            }
            return new Color(SubstanceColorUtilities.getInterpolatedRGB(interpolationScheme1.getLightColor(), interpolationScheme2.getLightColor(), cycleCoef));
        }

        @Override
        public Color getMidFillColorBottom(SubstanceColorScheme interpolationScheme1, SubstanceColorScheme interpolationScheme2, double cycleCoef, boolean useCyclePosAsInterpolation) {
            if (!useCyclePosAsInterpolation) {
                return interpolationScheme1.getUltraDarkColor();
            }
            return new Color(SubstanceColorUtilities.getInterpolatedRGB(interpolationScheme1.getUltraDarkColor(), interpolationScheme2.getUltraDarkColor(), cycleCoef));
        }

        @Override
        public Color getBottomFillColor(SubstanceColorScheme interpolationScheme1, SubstanceColorScheme interpolationScheme2, double cycleCoef, boolean useCyclePosAsInterpolation) {
            if (!useCyclePosAsInterpolation) {
                return interpolationScheme1.getExtraLightColor();
            }
            return new Color(SubstanceColorUtilities.getInterpolatedRGB(interpolationScheme1.getExtraLightColor(), interpolationScheme2.getExtraLightColor(), cycleCoef));
        }
    }

    private static class OfficeBlue2007BorderPainter
    extends CompositeBorderPainter {
        public OfficeBlue2007BorderPainter() {
            super("Office Blue 2007 Border", new OfficeBlue2007BorderSinglePainter(), new DelegateBorderPainter("Office Blue 2007 Inner", new OfficeBlue2007BorderSinglePainter(), new ColorSchemeTransform(){

                @Override
                public SubstanceColorScheme transform(SubstanceColorScheme scheme) {
                    return scheme.tint(0.8f);
                }
            }));
        }
    }

    private static class OfficeBlue2007BorderSinglePainter
    extends StandardBorderPainter {
        private OfficeBlue2007BorderSinglePainter() {
        }

        @Override
        public String getDisplayName() {
            return "Office Blue 2007 Single Border";
        }

        @Override
        public Color getTopBorderColor(SubstanceColorScheme interpolationScheme1, SubstanceColorScheme interpolationScheme2, double cycleCoef, boolean useCyclePosAsInterpolation) {
            if (!useCyclePosAsInterpolation) {
                return interpolationScheme1.getExtraLightColor();
            }
            return new Color(SubstanceColorUtilities.getInterpolatedRGB(interpolationScheme1.getExtraLightColor(), interpolationScheme2.getExtraLightColor(), cycleCoef));
        }

        @Override
        public Color getMidBorderColor(SubstanceColorScheme interpolationScheme1, SubstanceColorScheme interpolationScheme2, double cycleCoef, boolean useCyclePosAsInterpolation) {
            if (!useCyclePosAsInterpolation) {
                return interpolationScheme1.getDarkColor();
            }
            return new Color(SubstanceColorUtilities.getInterpolatedRGB(interpolationScheme1.getDarkColor(), interpolationScheme2.getDarkColor(), cycleCoef));
        }

        @Override
        public Color getBottomBorderColor(SubstanceColorScheme interpolationScheme1, SubstanceColorScheme interpolationScheme2, double cycleCoef, boolean useCyclePosAsInterpolation) {
            if (!useCyclePosAsInterpolation) {
                return interpolationScheme1.getMidColor();
            }
            return new Color(SubstanceColorUtilities.getInterpolatedRGB(interpolationScheme1.getMidColor(), interpolationScheme2.getMidColor(), cycleCoef));
        }
    }

    private static class OfficeBlue2007DecorationPainter
    implements SubstanceDecorationPainter {
        private OfficeBlue2007DecorationPainter() {
        }

        @Override
        public String getDisplayName() {
            return "Office Blue 2007 Decoration";
        }

        @Override
        public void paintDecorationArea(Graphics2D graphics, Component comp, DecorationAreaType decorationAreaType, int width, int height, SubstanceSkin skin) {
            switch (decorationAreaType) {
                case PRIMARY_TITLE_PANE: 
                case SECONDARY_TITLE_PANE: {
                    this.paintTitleBackground(graphics, comp, width, height, skin.getBackgroundColorScheme(decorationAreaType));
                    break;
                }
                default: {
                    this.paintExtraBackground(graphics, SubstanceCoreUtilities.getHeaderParent(comp), comp, width, height, skin.getBackgroundColorScheme(decorationAreaType));
                }
            }
        }

        private void paintTitleBackground(Graphics2D graphics, Component comp, int width, int height, SubstanceColorScheme scheme) {
            Graphics2D g2d = (Graphics2D)graphics.create();
            LinearGradientPaint gradient = new LinearGradientPaint(0.0f, 0.0f, 0.0f, height, new float[]{0.0f, 0.1199999f, 0.12f, 0.5f, 0.9f, 1.0f}, new Color[]{scheme.getLightColor(), scheme.getLightColor(), scheme.getUltraDarkColor(), scheme.getMidColor(), scheme.getUltraLightColor(), scheme.getLightColor()}, MultipleGradientPaint.CycleMethod.REPEAT);
            g2d.setPaint(gradient);
            g2d.fillRect(0, 0, width, height);
            g2d.translate(0, height - 1);
            SeparatorPainterUtils.paintSeparator(comp, g2d, width, 0, 0, false, 0);
            g2d.dispose();
        }

        private void paintExtraBackground(Graphics2D graphics, Container parent, Component comp, int width, int height, SubstanceColorScheme scheme) {
            graphics.setColor(scheme.getMidColor());
            graphics.fillRect(0, 0, width, height);
        }
    }
}

