/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JPanel;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.plugins.graph.ColumnInfo;
import net.sourceforge.squirrel_sql.plugins.graph.ColumnInfoModel;
import net.sourceforge.squirrel_sql.plugins.graph.ColumnInfoModelListener;
import net.sourceforge.squirrel_sql.plugins.graph.GraphPlugin;
import net.sourceforge.squirrel_sql.plugins.graph.GraphTextAreaFactory;
import net.sourceforge.squirrel_sql.plugins.graph.IColumnTextArea;
import net.sourceforge.squirrel_sql.plugins.graph.QueryColumnPanel;
import net.sourceforge.squirrel_sql.plugins.graph.TableFramesModelChangeType;
import net.sourceforge.squirrel_sql.plugins.graph.nondbconst.DndCallback;

public class QueryTextArea
extends JPanel
implements IColumnTextArea {
    private String _tableName;
    private GraphPlugin _plugin;
    private ColumnInfoModel _columnInfoModel;
    private QueryTextAreaMouseListenerProxy _mouseListenerPx = new QueryTextAreaMouseListenerProxy();
    private ArrayList<MouseListener> _mouseListeners = new ArrayList();
    private DndCallback _dndCallback;
    private ISession _session;
    private int _lastColumnHeightBeforeSetColums;

    public QueryTextArea(String tableName, GraphPlugin plugin, DndCallback dndCallback, ISession session) {
        this._tableName = tableName;
        this._plugin = plugin;
        this._dndCallback = dndCallback;
        this._session = session;
        this.setLayout(new GridBagLayout());
        this.addMouseListener(this._mouseListenerPx);
    }

    public void setColumnInfoModel(ColumnInfoModel columnInfoModel) {
        this._columnInfoModel = columnInfoModel;
        this._columnInfoModel.addColumnInfoModelListener(new ColumnInfoModelListener(){

            @Override
            public void columnInfosChanged(TableFramesModelChangeType changeType) {
                if (TableFramesModelChangeType.COLUMN_SORTING == changeType || TableFramesModelChangeType.COLUMN_SELECT_ALL == changeType || TableFramesModelChangeType.COLUMN_WHERE_ALL == changeType) {
                    QueryTextArea.this.initColumnInfos();
                }
            }
        });
        this.initColumnInfos();
    }

    private void initColumnInfos() {
        GridBagConstraints gbc;
        if (0 < this.getComponentCount()) {
            this._lastColumnHeightBeforeSetColums = this.getColumnHeight();
        }
        this.setVisible(false);
        this.removeAll();
        this.setBackground(GraphTextAreaFactory.TEXTAREA_BG);
        for (int i = 0; i < this._columnInfoModel.getColCount(); ++i) {
            ColumnInfo columnInfo = this._columnInfoModel.getOrderedColAt(i);
            gbc = new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
            this.add((Component)new QueryColumnPanel(this._plugin, this._tableName, columnInfo, this._dndCallback, this._session), gbc);
        }
        gbc = new GridBagConstraints(0, this._columnInfoModel.getColCount(), 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
        JPanel dist = new JPanel();
        dist.setBackground(GraphTextAreaFactory.TEXTAREA_BG);
        this.add((Component)dist, gbc);
        this.setVisible(true);
        this.addToAllKidComponents(this._mouseListenerPx);
    }

    @Override
    public int getColumnHeight() {
        int height = this.getComponent(0).getHeight();
        if (0 == height) {
            return this._lastColumnHeightBeforeSetColums;
        }
        return height;
    }

    @Override
    public int getMaxWidth() {
        return ((QueryColumnPanel)this.getComponent(0)).getMaxWidth(this._columnInfoModel.getAll());
    }

    public void addQueryAreaMouseListener(MouseListener mouseListener) {
        this._mouseListeners.add(mouseListener);
    }

    private void addToAllKidComponents(MouseListener mouseListener) {
        for (Component component : this.getComponents()) {
            if (component instanceof QueryColumnPanel) {
                ((QueryColumnPanel)component).addColumnMouseListener(mouseListener);
                continue;
            }
            component.addMouseListener(mouseListener);
        }
    }

    private MouseEvent transformMouseEvent(MouseEvent e) {
        if (this == e.getComponent()) {
            return e;
        }
        Point lp = QueryTextArea.getLocationInQueryTextArea(e.getComponent());
        e.setSource(this);
        e.translatePoint(lp.x, lp.y);
        return e;
    }

    static Point getLocationInQueryTextArea(Component childComp) {
        Point ret = new Point(0, 0);
        Component comp = childComp;
        while (!(comp instanceof QueryTextArea)) {
            ret.translate(comp.getX(), comp.getY());
            comp = comp.getParent();
        }
        return ret;
    }

    private class QueryTextAreaMouseListenerProxy
    implements MouseListener {
        private QueryTextAreaMouseListenerProxy() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            MouseListener[] mouseListenersBuf;
            MouseEvent te = QueryTextArea.this.transformMouseEvent(e);
            for (MouseListener mouseListener : mouseListenersBuf = QueryTextArea.this._mouseListeners.toArray(new MouseListener[QueryTextArea.this._mouseListeners.size()])) {
                mouseListener.mouseClicked(te);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            MouseListener[] mouseListenersBuf;
            MouseEvent te = QueryTextArea.this.transformMouseEvent(e);
            for (MouseListener mouseListener : mouseListenersBuf = QueryTextArea.this._mouseListeners.toArray(new MouseListener[QueryTextArea.this._mouseListeners.size()])) {
                mouseListener.mousePressed(te);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            MouseListener[] mouseListenersBuf;
            MouseEvent te = QueryTextArea.this.transformMouseEvent(e);
            for (MouseListener mouseListener : mouseListenersBuf = QueryTextArea.this._mouseListeners.toArray(new MouseListener[QueryTextArea.this._mouseListeners.size()])) {
                mouseListener.mouseReleased(te);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            MouseListener[] mouseListenersBuf;
            MouseEvent te = QueryTextArea.this.transformMouseEvent(e);
            for (MouseListener mouseListener : mouseListenersBuf = QueryTextArea.this._mouseListeners.toArray(new MouseListener[QueryTextArea.this._mouseListeners.size()])) {
                mouseListener.mouseEntered(te);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            MouseListener[] mouseListenersBuf;
            MouseEvent te = QueryTextArea.this.transformMouseEvent(e);
            for (MouseListener mouseListener : mouseListenersBuf = QueryTextArea.this._mouseListeners.toArray(new MouseListener[QueryTextArea.this._mouseListeners.size()])) {
                mouseListener.mouseExited(te);
            }
        }
    }
}

