/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextfilechooser;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.fife.ui.rtextfilechooser.RTextFileChooser;
import org.fife.ui.rtextfilechooser.filters.ExtensionFileFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Utilities {
    private static final String EXTENSION = "Extension";
    private static final String EXTENSION_FILTER = "ExtensionFileFilter";
    private static final String IGNORE_CASE = "ignoreCase";
    private static final String NAME = "name";
    private static final String SHOW_EXTENSIONS = "showExtensions";
    private static final DateFormat lastModifiedDateFormat = new SimpleDateFormat("MM/dd/yyyy hh:mm a");
    private static NumberFormat fileSizeFormat = NumberFormat.getNumberInstance();

    public static boolean addFileFilters(File file, RTextFileChooser chooser) throws IOException {
        if (file.exists()) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = null;
            Document doc = null;
            try {
                db = dbf.newDocumentBuilder();
                InputSource is = new InputSource(new FileReader(file));
                doc = db.parse(is);
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (Exception e) {
                throw new IOException("XML error:  Error parsing file");
            }
            Utilities.initializeFromXMLFile(doc.getDocumentElement(), chooser);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    public static final String getExtension(String fileName) {
        int lastDot = fileName.lastIndexOf(46);
        return lastDot > -1 ? fileName.substring(lastDot + 1) : null;
    }

    public static final String getFileSizeStringFor(File file) {
        return Utilities.getFileSizeStringFor(file.length(), false);
    }

    public static final String getFileSizeStringFor(long size, boolean reportInKB) {
        String str = null;
        if (reportInKB) {
            String suffix = " bytes";
            if (size >= 1024L) {
                size /= 1024L;
                suffix = " KB";
            }
            str = fileSizeFormat.format(size) + suffix;
        } else {
            int count;
            double tempSize;
            double prevSize = tempSize = (double)size;
            for (count = 0; count < 4; ++count) {
                double d;
                tempSize = prevSize / 1024.0;
                if (!(d >= 1.0)) break;
                prevSize = tempSize;
            }
            String suffix = null;
            switch (count) {
                case 0: {
                    suffix = "bytes";
                    break;
                }
                case 1: {
                    suffix = "KB";
                    break;
                }
                case 2: {
                    suffix = "MB";
                    break;
                }
                case 3: {
                    suffix = "GB";
                    break;
                }
                case 4: {
                    suffix = "TB";
                }
            }
            str = fileSizeFormat.format(prevSize) + " " + suffix;
        }
        return str;
    }

    public static final String getLastModifiedString(long date) {
        Date date2 = new Date(date);
        return lastModifiedDateFormat.format(date2);
    }

    private static void initializeFromXMLFile(Element root, RTextFileChooser chooser) throws IOException {
        if (root == null) {
            throw new IOException("XML error:  null root node received!");
        }
        NodeList filterList = root.getElementsByTagName(EXTENSION_FILTER);
        int childCount = filterList == null ? 0 : filterList.getLength();
        for (int i = 0; i < childCount; ++i) {
            Element filterElem = (Element)filterList.item(i);
            Utilities.parseExtensionFilterXml(chooser, filterElem);
        }
    }

    public static final boolean isCaseSensitiveFileSystem() {
        String os = System.getProperty("os.name");
        boolean caseSensitive = false;
        if (os != null) {
            caseSensitive = (os = os.toLowerCase()).indexOf("windows") == -1 && os.indexOf("mac os x") == -1;
        }
        return caseSensitive;
    }

    private static void parseExtensionFilterXml(RTextFileChooser chooser, Element elem) throws IOException {
        NodeList extElems = elem.getElementsByTagName(EXTENSION);
        int extElemCount = extElems == null ? 0 : extElems.getLength();
        ArrayList<String> extList = new ArrayList<String>(extElemCount / 3);
        for (int i = 0; i < extElemCount; ++i) {
            Node extElem = extElems.item(i);
            StringBuffer sb = new StringBuffer();
            NodeList childTextNodes = extElem.getChildNodes();
            if (childTextNodes == null || childTextNodes.getLength() == 0) {
                throw new IOException("Extension tag requires child text");
            }
            int childCount = childTextNodes.getLength();
            for (int j = 0; j < childCount; ++j) {
                Node child = childTextNodes.item(j);
                short type = child.getNodeType();
                if (type != 3 && type != 4) continue;
                sb.append(child.getNodeValue());
            }
            extList.add(sb.toString());
        }
        String[] extensions = new String[extList.size()];
        extensions = extList.toArray(extensions);
        String name = null;
        boolean ignoreCase = true;
        boolean showExtensions = true;
        NamedNodeMap attributes = elem.getAttributes();
        int attributeCount = attributes == null ? 0 : attributes.getLength();
        for (int i = 0; i < attributeCount; ++i) {
            Node node2 = attributes.item(i);
            String nodeName = node2.getNodeName();
            String nodeValue = node2.getNodeValue();
            if (NAME.equals(nodeName)) {
                name = nodeValue;
                continue;
            }
            if (IGNORE_CASE.equals(nodeName)) {
                ignoreCase = Boolean.valueOf(nodeValue);
                continue;
            }
            if (SHOW_EXTENSIONS.equals(nodeName)) {
                showExtensions = Boolean.valueOf(nodeValue);
                continue;
            }
            throw new IOException("XML error: unknown attribute: '" + nodeName + "'");
        }
        chooser.addChoosableFileFilter(new ExtensionFileFilter(name, extensions, ignoreCase ? 2 : 1, showExtensions));
    }

    static {
        fileSizeFormat.setGroupingUsed(true);
        fileSizeFormat.setMinimumFractionDigits(0);
        fileSizeFormat.setMaximumFractionDigits(1);
    }
}

