/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.script.generator.ui;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.Dbms;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.dataSource.srcStorage.PersistentMarkup;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.introspection.DBIntrospectorFactory;
import com.intellij.database.model.BlackHoleTextStorage;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacadeImpl;
import com.intellij.database.script.CompositeText;
import com.intellij.database.script.CompositeTextFun;
import com.intellij.database.script.DbSrcMigration;
import com.intellij.database.script.generator.CustomScriptingOptions;
import com.intellij.database.script.generator.DefaultScriptingOptions;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptConsumer;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingNativeDefinitionTaskBuilder;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.script.generator.ScriptingSingleModelTaskBuilder;
import com.intellij.database.script.generator.ScriptingSingleModelTaskBuilderBase;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.script.generator.UtilKt;
import com.intellij.database.script.generator.ui.ScriptFileLayoutPanel;
import com.intellij.database.script.generator.ui.ScriptGeneratorSettings;
import com.intellij.database.script.generator.ui.ScriptGeneratorTool;
import com.intellij.database.script.generator.ui.ScriptGeneratorUI;
import com.intellij.database.script.generator.ui.ScriptGeneratorUI$WhenMappings;
import com.intellij.database.script.generator.ui.ScriptGeneratorUI$sam$java_lang_Runnable$0;
import com.intellij.database.script.generator.ui.ScriptOptionsPanel;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.GuardedRef;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.ui.EditorSettingsProvider;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.content.Content;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.SingleAlarm;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import icons.DatabaseIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ea\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010$\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 i2\u00020\u0001:\u0003ijkB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u00104\u001a\u000205H\u0002J\b\u00106\u001a\u000205H\u0002J\u0010\u00107\u001a\u0002052\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u00108\u001a\u000205H\u0002J\u001e\u00109\u001a\u0002052\u0006\u0010:\u001a\u00020;2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020>0=H\u0002J\b\u0010?\u001a\u000205H\u0002J\b\u0010@\u001a\u000205H\u0002JB\u0010A\u001a\u00020B2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010:\u001a\u00020;2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00120D2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020F0D2\f\u0010G\u001a\b\u0012\u0002\b\u0003\u0018\u00010HH\u0002J\u0018\u0010A\u001a\u0004\u0018\u00010B2\f\u0010G\u001a\b\u0012\u0002\b\u0003\u0018\u00010HH\u0002J\b\u0010I\u001a\u000205H\u0016J,\u0010J\u001a\u0002HK\"\u0004\b\u0000\u0010K2\u0006\u0010L\u001a\u00020M2\u000e\b\u0004\u0010N\u001a\b\u0012\u0004\u0012\u0002HK0OH\u0082\b\u00a2\u0006\u0002\u0010PJ\u0014\u0010Q\u001a\u0004\u0018\u00010R2\b\u0010:\u001a\u0004\u0018\u00010;H\u0002J\u001c\u0010S\u001a\u0002052\u0006\u0010:\u001a\u00020;2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020>0=J\u0016\u0010T\u001a\u0002052\f\u0010U\u001a\b\u0012\u0004\u0012\u0002050OH\u0002J\b\u0010V\u001a\u000205H\u0002J\b\u0010W\u001a\u000205H\u0002J\b\u0010X\u001a\u000205H\u0002J\u0018\u0010Y\u001a\u00020\u00162\u0006\u0010Z\u001a\u00020\u00162\u0006\u0010[\u001a\u00020RH\u0002J\b\u0010\\\u001a\u000205H\u0002J(\u0010]\u001a\u0014\u0012\u0004\u0012\u00020F\u0012\n\u0012\b\u0012\u0004\u0012\u00020M0_0^2\f\u0010`\u001a\b\u0012\u0004\u0012\u00020F0DH\u0002J(\u0010a\u001a\u0014\u0012\u0004\u0012\u00020F\u0012\n\u0012\b\u0012\u0004\u0012\u00020M0_0^2\f\u0010`\u001a\b\u0012\u0004\u0012\u00020F0DH\u0002J\b\u0010b\u001a\u000205H\u0002J\b\u0010c\u001a\u000205H\u0002J\b\u0010d\u001a\u000205H\u0002J\b\u0010e\u001a\u000205H\u0002J(\u0010f\u001a\u0012\u0012\u0004\u0012\u0002HK0gj\b\u0012\u0004\u0012\u0002HK`h\"\u0004\b\u0000\u0010K*\b\u0012\u0004\u0012\u0002HK0\nH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u001eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010+\u001a\n -*\u0004\u0018\u00010,0,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00100\u001a\u000201X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103\u00a8\u0006l"}, d2={"Lcom/intellij/database/script/generator/ui/ScriptGeneratorUI;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "alarm", "Lcom/intellij/util/SingleAlarm;", "category", "Lcom/intellij/database/script/generator/ScriptCategory;", "categorySelector", "Lcom/intellij/openapi/ui/ComboBox;", "content", "Lcom/intellij/ui/content/Content;", "getContent$intellij_database_impl", "()Lcom/intellij/ui/content/Content;", "setContent$intellij_database_impl", "(Lcom/intellij/ui/content/Content;)V", "currentSchema", "Lcom/intellij/database/model/basic/BasicSchema;", "document", "Lcom/intellij/openapi/editor/Document;", "generatedText", "Lcom/intellij/database/script/CompositeText;", "generationInProgress", "Ljava/lang/Object;", "layoutPanel", "Lcom/intellij/database/script/generator/ui/ScriptFileLayoutPanel;", "loadingPanel", "Lcom/intellij/ui/components/JBLoadingPanel;", "mainPanel", "Ljavax/swing/JPanel;", "getMainPanel$intellij_database_impl", "()Ljavax/swing/JPanel;", "optionsPanel", "Lcom/intellij/database/script/generator/ui/ScriptOptionsPanel;", "getProject", "()Lcom/intellij/openapi/project/Project;", "psiFile", "Lcom/intellij/psi/PsiFile;", "scriptingOptions", "Lcom/intellij/database/script/generator/ScriptingOptions;", "selection", "Lcom/intellij/database/script/generator/ui/ScriptGeneratorUI$Selection;", "settings", "Lcom/intellij/database/script/generator/ui/ScriptGeneratorSettings;", "kotlin.jvm.PlatformType", "toRequestFocus", "Ljava/util/concurrent/atomic/AtomicBoolean;", "viewer", "Lcom/intellij/ui/EditorTextField;", "getViewer$intellij_database_impl", "()Lcom/intellij/ui/EditorTextField;", "adjustCategories", "", "adjustOptionsUI", "assignCategory", "assignOptionsFromSettings", "assignSelection", "model", "Lcom/intellij/database/model/basic/BasicModel;", "nodes", "", "Lcom/intellij/database/model/basic/BasicNode;", "clear", "copyToClipboard", "createTask", "Lcom/intellij/database/script/generator/ScriptingTask;", "schemasToGenerate", "", "objectsToGenerate", "Lcom/intellij/database/model/basic/BasicElement;", "consumer", "Lcom/intellij/database/script/generator/ScriptConsumer;", "dispose", "doing", "T", "message", "", "operation", "Lkotlin/Function0;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "findDsForModel", "Lcom/intellij/database/dataSource/LocalDataSource;", "generate", "inUI", "block", "openInConsole", "prepareDocument", "processOptionChange", "reformatCompositeText", "compositeText", "dataSource", "regenerate", "retrieveNativeDefinitionsForElements", "", "", "elements", "retrieveNativeDefinitionsForElementsInternal", "saveOutputSettings", "saveToFile", "showTheScript", "showTheScriptInsideUI", "getItems", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "Companion", "FinalAction", "Selection", "intellij.database.impl"})
public final class ScriptGeneratorUI
implements Disposable {
    @NotNull
    public Content content;
    @NotNull
    private final JPanel mainPanel;
    @NotNull
    private final EditorTextField viewer;
    private final JBLoadingPanel loadingPanel;
    private final ComboBox<ScriptCategory> categorySelector;
    private ScriptOptionsPanel optionsPanel;
    private ScriptFileLayoutPanel layoutPanel;
    private final SingleAlarm alarm;
    private final ScriptGeneratorSettings settings;
    private Selection selection;
    private ScriptCategory category;
    private final Object generationInProgress;
    private final AtomicBoolean toRequestFocus;
    private CompositeText generatedText;
    private BasicSchema currentSchema;
    private ScriptingOptions scriptingOptions;
    private Document document;
    private PsiFile psiFile;
    @NotNull
    private final Project project;
    @NotNull
    private static final Application application;
    @NotNull
    private static final Key<ScriptGeneratorUI> contextKey;
    @NotNull
    private static final Key<BasicModel> modelKey;
    @NotNull
    private static final List<ScriptCategory> implementedCategories;
    @NotNull
    private static final Logger log;
    @Nullable
    private static String lastPath;
    @NotNull
    private static final Map<CompositeText.Kind, CompositeText.Kind> formattableKindRemapping;
    @NotNull
    public static final String normalLoadingPanelText = "Generating SQL script\u2026";
    public static final Companion Companion;

    @NotNull
    public final Content getContent$intellij_database_impl() {
        Content content = this.content;
        if (content == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"content");
        }
        return content;
    }

    public final void setContent$intellij_database_impl(@NotNull Content content) {
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"<set-?>");
        this.content = content;
    }

    @NotNull
    public final JPanel getMainPanel$intellij_database_impl() {
        return this.mainPanel;
    }

    @NotNull
    public final EditorTextField getViewer$intellij_database_impl() {
        return this.viewer;
    }

    public final void generate(@NotNull BasicModel model, @NotNull Iterable<? extends BasicNode> nodes2) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Intrinsics.checkParameterIsNotNull(nodes2, (String)"nodes");
        this.alarm.cancel();
        this.assignSelection(model, nodes2);
        this.adjustCategories();
        this.assignOptionsFromSettings();
        this.adjustOptionsUI();
        Object object2 = this.selection;
        if (object2 == null || (object2 = ((Selection)object2).getElements()) == null || !(!(object = object2).isEmpty())) {
            this.clear();
            return;
        }
        this.toRequestFocus.set(true);
        this.alarm.cancelAndRequest();
    }

    private final void saveOutputSettings() {
        this.settings.setOutputPath(this.layoutPanel.getPath());
        this.settings.setOutputLayout(this.layoutPanel.getLayout());
    }

    /*
     * WARNING - void declaration
     */
    private final void assignSelection(BasicModel model, Iterable<? extends BasicNode> nodes2) {
        void $receiver$iv$iv;
        void $receiver$iv;
        Iterable<? extends BasicNode> iterable = nodes2;
        void var5_4 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            BasicElement basicElement;
            Object element$iv$iv = element$iv$iv$iv;
            BasicNode it = (BasicNode)element$iv$iv;
            BasicNode basicNode = it;
            if (!(basicNode instanceof BasicElement)) {
                basicNode = null;
            }
            if ((BasicElement)basicNode == null) continue;
            BasicElement it$iv$iv = basicElement;
            destination$iv$iv.add(it$iv$iv);
        }
        List elements = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        this.selection = new Selection(model, elements);
    }

    /*
     * WARNING - void declaration
     */
    private final void adjustCategories() {
        ScriptCategory it;
        void $receiver$iv$iv;
        void $receiver$iv;
        ArrayList arrayList;
        Object object = this.selection;
        if (object == null || (object = ((Selection)object).getModel()) == null || (object = object.getDbms()) == null) {
            object = Dbms.UNKNOWN;
        }
        Object dbms = object;
        Iterable iterable = implementedCategories;
        ArrayList arrayList2 = arrayList;
        ArrayList arrayList3 = arrayList;
        void var4_5 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (ScriptCategory)((Object)element$iv$iv);
            if (!it.getApplicableDbs().value(dbms)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        arrayList2(list);
        ArrayList needCategories = arrayList3;
        ArrayList<ScriptCategory> existentCategories = this.getItems(this.categorySelector);
        if (Intrinsics.areEqual(needCategories, existentCategories)) {
            return;
        }
        ScriptCategory savedCategory = this.category;
        this.categorySelector.removeAllItems();
        if (needCategories.isEmpty()) {
            return;
        }
        Iterable $receiver$iv2 = needCategories;
        for (Object element$iv : $receiver$iv2) {
            it = (ScriptCategory)((Object)element$iv);
            this.categorySelector.addItem((Object)it);
        }
        if (needCategories.contains((Object)savedCategory)) {
            this.categorySelector.setSelectedItem((Object)savedCategory);
            this.assignCategory(savedCategory);
        } else {
            this.categorySelector.setSelectedIndex(0);
            this.assignCategory((ScriptCategory)((Object)CollectionsKt.first((List)needCategories)));
        }
    }

    private final void assignCategory(ScriptCategory category) {
        this.category = category;
        this.assignOptionsFromSettings();
    }

    private final void assignOptionsFromSettings() {
        Object object = this.selection;
        Dbms rdbms = object != null && (object = ((Selection)object).getModel()) != null ? object.getDbms() : null;
        CustomScriptingOptions customScriptingOptions = rdbms != null ? this.settings.get(rdbms, this.category) : null;
        this.scriptingOptions = customScriptingOptions != null ? (ScriptingOptions)customScriptingOptions : (ScriptingOptions)DefaultScriptingOptions.INSTANCE;
    }

    private final void adjustOptionsUI() {
        ScriptingTask scriptingTask;
        ScriptOptionsPanel scriptOptionsPanel = this.optionsPanel;
        Object object = this.selection;
        if (object != null && (object = ((Selection)object).getModel()) != null) {
            Object it;
            Object object2 = object;
            ScriptOptionsPanel scriptOptionsPanel2 = scriptOptionsPanel;
            Object object3 = it = object2;
            ScriptCategory scriptCategory = this.category;
            ScriptGeneratorUI scriptGeneratorUI = this;
            List list = CollectionsKt.emptyList();
            List list2 = CollectionsKt.emptyList();
            ScriptingTask scriptingTask2 = scriptGeneratorUI.createTask(scriptCategory, (BasicModel)object3, list, list2, null);
            scriptOptionsPanel = scriptOptionsPanel2;
            scriptingTask = scriptingTask2;
        } else {
            scriptingTask = null;
        }
        scriptOptionsPanel.adjustOptionsUI(scriptingTask, this.scriptingOptions);
    }

    private final void processOptionChange() {
        Dbms rdbms;
        ScriptingOptions newOptions;
        this.scriptingOptions = newOptions = this.optionsPanel.gatherOptions();
        Object object = this.selection;
        Dbms dbms = object != null && (object = ((Selection)object).getModel()) != null ? object.getDbms() : (rdbms = null);
        if (rdbms != null) {
            ScriptingOptions scriptingOptions = newOptions;
            if (!(scriptingOptions instanceof CustomScriptingOptions)) {
                scriptingOptions = null;
            }
            this.settings.set(rdbms, this.category, (CustomScriptingOptions)scriptingOptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void regenerate() {
        ScriptingTask scriptingTask = this.createTask(null);
        if (scriptingTask == null) {
            return;
        }
        ScriptingTask task = scriptingTask;
        Object object = this.selection;
        if (object == null || (object = ((Selection)object).getModel()) == null) {
            return;
        }
        Object model = object;
        Companion.invokeLater((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ ScriptGeneratorUI this$0;

            public final void invoke() {
                ScriptGeneratorUI.access$getLoadingPanel$p(this.this$0).startLoading();
            }
            {
                this.this$0 = scriptGeneratorUI;
                super(0);
            }
        }));
        Object object2 = this.generationInProgress;
        synchronized (object2) {
            LocalDataSource dataSource;
            ScriptingResult result2 = ScriptGenerators.INSTANCE.makeScript(this.project, task);
            CompositeText gt = result2.getScript();
            if (this.scriptingOptions.get(ScriptingOptionStatic.REFORMAT).booleanValue() && (dataSource = this.findDsForModel((BasicModel)model)) != null) {
                gt = this.reformatCompositeText(gt, dataSource);
            }
            this.generatedText = gt;
            BasicSchema basicSchema = task.getCurrentSchema();
            if (basicSchema == null) {
                BasicRoot basicRoot = model.getRoot();
                Intrinsics.checkExpressionValueIsNotNull((Object)basicRoot, (String)"model.root");
                BasicDatabase basicDatabase = basicRoot.getCurrentDatabase();
                basicSchema = basicDatabase != null ? ModelFun.getCurrentSchema(basicDatabase) : null;
            }
            this.currentSchema = basicSchema;
            Unit unit = Unit.INSTANCE;
        }
        this.showTheScript();
    }

    private final ScriptingTask createTask(ScriptConsumer<?> consumer2) {
        Selection selection = this.selection;
        if (selection == null) {
            return null;
        }
        Selection selection2 = selection;
        ScriptCategory category = this.category;
        JBIterable jBIterable = JBIterable.from((Iterable)selection2.getElements());
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"JBIterable.from(selection.elements)");
        JBIterable sel = jBIterable;
        JBIterable jBIterable2 = sel.filter(BasicDatabase.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable2, (String)"sel.filter(BasicDatabase::class.java)");
        JBIterable explicitDatabases = jBIterable2;
        JBIterable jBIterable3 = sel.filter(BasicSchema.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable3, (String)"sel.filter(BasicSchema::class.java)");
        JBIterable explicitSchemas = jBIterable3;
        JBIterable jBIterable4 = sel.filter(BasicElement.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable4, (String)"sel.filter(BasicElement::class.java)");
        JBIterable explicitScriptableObjects = jBIterable4;
        List list = explicitDatabases.flatten((Function)createTask.schemasToGenerate.1.INSTANCE).append((Iterable)explicitSchemas).toList();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"explicitDatabases.flatte\u2026explicitSchemas).toList()");
        List schemasToGenerate2 = list;
        List list2 = explicitScriptableObjects.filter((Condition)new Condition<BasicElement>(schemasToGenerate2){
            final /* synthetic */ List $schemasToGenerate;

            public final boolean value(BasicElement it) {
                BasicElement basicElement = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)basicElement, (String)"it");
                return !this.$schemasToGenerate.contains(basicElement.getSchema());
            }
            {
                this.$schemasToGenerate = list;
            }
        }).toList();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"explicitScriptableObject\u2026emasToGenerate }.toList()");
        List objectsToGenerate2 = list2;
        return this.createTask(category, selection2.getModel(), schemasToGenerate2, objectsToGenerate2, consumer2);
    }

    /*
     * WARNING - void declaration
     */
    private final ScriptingTask createTask(ScriptCategory category, BasicModel model, List<? extends BasicSchema> schemasToGenerate2, List<? extends BasicElement> objectsToGenerate2, ScriptConsumer<?> consumer2) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        ScriptingSingleModelTaskBuilderBase scriptingSingleModelTaskBuilderBase;
        ScriptingNativeDefinitionTaskBuilder $receiver;
        ScriptingSingleModelTaskBuilderBase scriptingSingleModelTaskBuilderBase2;
        switch (ScriptGeneratorUI$WhenMappings.$EnumSwitchMapping$0[category.ordinal()]) {
            case 1: {
                scriptingSingleModelTaskBuilderBase2 = new ScriptingNativeDefinitionTaskBuilder(model);
                $receiver = scriptingSingleModelTaskBuilderBase2;
                $receiver.setNativeDefinitionsRetriever((Function1<? super List<? extends BasicElement>, ? extends Map<BasicElement, String[]>>)((Function1)new Function1<List<? extends BasicElement>, Map<BasicElement, ? extends String[]>>(this){

                    @NotNull
                    public final Map<BasicElement, String[]> invoke(@NotNull List<? extends BasicElement> p1) {
                        Intrinsics.checkParameterIsNotNull(p1, (String)"p1");
                        return ScriptGeneratorUI.access$retrieveNativeDefinitionsForElements((ScriptGeneratorUI)this.receiver, p1);
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(ScriptGeneratorUI.class);
                    }

                    public final String getName() {
                        return "retrieveNativeDefinitionsForElements";
                    }

                    public final String getSignature() {
                        return "retrieveNativeDefinitionsForElements(Ljava/util/List;)Ljava/util/Map;";
                    }
                }));
                scriptingSingleModelTaskBuilderBase = scriptingSingleModelTaskBuilderBase2;
                break;
            }
            default: {
                scriptingSingleModelTaskBuilderBase = new ScriptingSingleModelTaskBuilder(model, category);
            }
        }
        scriptingSingleModelTaskBuilderBase2 = scriptingSingleModelTaskBuilderBase;
        $receiver = scriptingSingleModelTaskBuilderBase2;
        BasicSchema schema = schemasToGenerate2.size() == 1 ? schemasToGenerate2.get(0) : null;
        Iterable iterable = $receiver$iv = (Iterable)schemasToGenerate2;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            BasicSchema it = (BasicSchema)element$iv$iv;
            Iterable<BasicMajorObject> list$iv$iv = UtilKt.getScriptableMajorObjects(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, list$iv$iv);
        }
        CollectionsKt.toCollection((Iterable)((List)destination$iv$iv), $receiver.getElements());
        CollectionsKt.toCollection((Iterable)objectsToGenerate2, $receiver.getElements());
        $receiver.setCurrentSchema(schema);
        $receiver.setOptions(this.scriptingOptions);
        $receiver.setConsumer(consumer2);
        return scriptingSingleModelTaskBuilderBase2.build();
    }

    private final CompositeText reformatCompositeText(CompositeText compositeText, LocalDataSource dataSource) {
        if (compositeText.getLength() > FileUtilRt.getUserFileSizeLimit()) {
            return compositeText;
        }
        SqlLanguageDialect sqlLanguageDialect = DbSqlUtil.getSqlDialect(dataSource);
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlLanguageDialect, (String)"DbSqlUtil.getSqlDialect(dataSource)");
        SqlLanguageDialect dialect = sqlLanguageDialect;
        CompositeText newCompositeText = CompositeTextFun.remapFragmentKinds(compositeText, formattableKindRemapping);
        PersistentMarkup persistentMarkup = DbSrcMigration.formatCompositeText(this.project, dialect, newCompositeText);
        Intrinsics.checkExpressionValueIsNotNull((Object)persistentMarkup, (String)"DbSrcMigration.formatCom\u2026ialect, newCompositeText)");
        return persistentMarkup;
    }

    private final void showTheScript() {
        this.inUI((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ ScriptGeneratorUI this$0;

            public final void invoke() {
                ScriptGeneratorUI.access$prepareDocument(this.this$0);
                ScriptGeneratorUI.access$showTheScriptInsideUI(this.this$0);
                ScriptGeneratorUI.access$getLoadingPanel$p(this.this$0).stopLoading();
            }
            {
                this.this$0 = scriptGeneratorUI;
                super(0);
            }
        }));
    }

    private final void prepareDocument() {
        Document document;
        Selection selection = this.selection;
        if (selection == null) {
            return;
        }
        Selection selection2 = selection;
        BasicModel model = selection2.getModel();
        Document document2 = this.document;
        if ((document2 != null ? (BasicModel)document2.getUserData(modelKey) : null) == model) {
            return;
        }
        LocalDataSource localDataSource = this.findDsForModel(model);
        if (localDataSource == null) {
            return;
        }
        LocalDataSource dataSource = localDataSource;
        DbDataSource dbDataSource = DbPsiFacadeImpl.getInstance((Project)this.project).findDataSource(dataSource.getUniqueId());
        if (dbDataSource == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)dbDataSource, (String)"DbPsiFacadeImpl.getInsta\u2026ource.uniqueId) ?: return");
        DbDataSource dbDataSource2 = dbDataSource;
        SqlLanguageDialect sqlLanguageDialect = DbSqlUtil.getSqlDialect(dataSource);
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlLanguageDialect, (String)"DbSqlUtil.getSqlDialect(dataSource)");
        SqlLanguageDialect language = sqlLanguageDialect;
        PsiFile psiFile = PsiFileFactory.getInstance((Project)this.project).createFileFromText("generated.sql", (Language)language, (CharSequence)"");
        DatabaseDataKeys.DATA_SOURCE_KEY.set((UserDataHolder)psiFile, (Object)dbDataSource2);
        DatabaseDataKeys.SEARCH_PATH_KEY.set((UserDataHolder)psiFile, (Object)ObjectPaths.searchPathOf(this.currentSchema));
        this.psiFile = psiFile;
        Document document3 = document = PsiDocumentManager.getInstance((Project)this.project).getDocument(psiFile);
        if (document3 == null) {
            Intrinsics.throwNpe();
        }
        document3.putUserData(modelKey, (Object)model);
        this.document = document;
    }

    private final void showTheScriptInsideUI() {
        block4: {
            Document document = this.document;
            if (document == null) {
                String string = "The document is not prepared";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Document document2 = document;
            document2.setReadOnly(false);
            Object object = this.generatedText;
            if (object == null || (object = object.getText()) == null) {
                object = "";
            }
            document2.setText((CharSequence)object);
            document2.setReadOnly(true);
            if (this.viewer.getDocument() != document2) {
                this.viewer.setDocument(document2);
            }
            this.viewer.setVisible(true);
            Editor editor = this.viewer.getEditor();
            if (!(editor instanceof EditorImpl)) {
                editor = null;
            }
            EditorImpl editorImpl = (EditorImpl)editor;
            if (editorImpl == null) break block4;
            editorImpl.setCaretEnabled(true);
        }
    }

    private final void copyToClipboard() {
        CompositeText compositeText = this.generatedText;
        if (compositeText == null) {
            return;
        }
        CompositeText generatedText = compositeText;
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(((Object)generatedText.getText()).toString()));
    }

    private final void saveToFile() {
        String string;
        CompositeText compositeText = this.generatedText;
        if (compositeText == null) {
            return;
        }
        CompositeText generatedText = compositeText;
        if (lastPath != null) {
            string = lastPath;
            if (string == null) {
                Intrinsics.throwNpe();
            }
        } else if (StringsKt.equals((String)this.project.getName(), (String)"default", (boolean)true)) {
            string = System.getProperty("user.home");
            if (string == null) {
                string = "";
            }
        } else {
            string = this.project.getBasePath();
            if (string == null) {
                string = "";
            }
        }
        String path = string;
        FileSaverDescriptor descriptor = new FileSaverDescriptor("Select File to Save the Script", "", new String[]{"sql"});
        FileSaverDialog fileSaverDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor, this.project);
        Intrinsics.checkExpressionValueIsNotNull((Object)fileSaverDialog, (String)"FileChooserFactory.getIn\u2026alog(descriptor, project)");
        FileSaverDialog chooser = fileSaverDialog;
        VirtualFile virtualBaseDir = LocalFileSystem.getInstance().findFileByIoFile(new File(path));
        VirtualFileWrapper virtualFileWrapper = chooser.save(virtualBaseDir, "script.sql");
        if (virtualFileWrapper == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileWrapper, (String)"chooser.save(virtualBase\u2026, \"script.sql\") ?: return");
        VirtualFileWrapper fileWrapper = virtualFileWrapper;
        File file = fileWrapper.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"fileWrapper.file");
        File file2 = file;
        lastPath = file2.getParent();
        try {
            Files.write(Paths.get(file2.getPath(), new String[0]), (Iterable<? extends CharSequence>)CollectionsKt.listOf((Object)generatedText.getText()), new OpenOption[0]);
        }
        catch (Exception e) {
            String message2 = "Failed to save SQL script into a file \"" + file2.getAbsolutePath() + ": exception " + e.getClass().getSimpleName() + ": " + e.getMessage();
            log.warn(message2, (Throwable)e);
        }
    }

    private final void openInConsole() {
        CompositeText compositeText = this.generatedText;
        if (compositeText == null) {
            return;
        }
        CompositeText generatedText = compositeText;
        Selection selection = this.selection;
        LocalDataSource localDataSource = this.findDsForModel(selection != null ? selection.getModel() : null);
        if (localDataSource == null) {
            return;
        }
        LocalDataSource ds = localDataSource;
        VirtualFile virtualFile = DatabaseEditorHelper.createNewConsoleVirtualFile(ds);
        if (virtualFile == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"DatabaseEditorHelper.cre\u2026VirtualFile(ds) ?: return");
        VirtualFile virtualFile2 = virtualFile;
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile2);
        if (document == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"FileDocumentManager.getI\u2026nt(virtualFile) ?: return");
        Document document2 = document;
        WriteCommandAction.runWriteCommandAction((Project)this.project, (Runnable)new Runnable(document2, generatedText){
            final /* synthetic */ Document $document;
            final /* synthetic */ CompositeText $generatedText;

            public final void run() {
                this.$document.setText(this.$generatedText.getText());
            }
            {
                this.$document = document;
                this.$generatedText = compositeText;
            }
        });
        DatabaseEditorHelper.openConsoleForFile(this.project, null, virtualFile2);
    }

    private final LocalDataSource findDsForModel(BasicModel model) {
        Object v3;
        block2: {
            if (model == null) {
                return null;
            }
            DataSourceStorage dataSourceStorage = DataSourceStorage.getProjectStorage(this.project);
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)dataSourceStorage), (String)"DataSourceStorage.getProjectStorage(project)");
            List<LocalDataSource> list = dataSourceStorage.getDataSources();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"DataSourceStorage.getPro\u2026oject)\n      .dataSources");
            Iterable $receiver$iv = list;
            for (Object element$iv : $receiver$iv) {
                LocalDataSource ds;
                LocalDataSource localDataSource = ds = (LocalDataSource)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)localDataSource, (String)"ds");
                if (!Intrinsics.areEqual((Object)localDataSource.getModel(), (Object)model)) continue;
                v3 = element$iv;
                break block2;
            }
            v3 = null;
        }
        return v3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Map<BasicElement, String[]> retrieveNativeDefinitionsForElements(List<? extends BasicElement> elements) {
        Map map;
        void this_$iv;
        int n = elements.size();
        if (n == 0) {
            return MapsKt.emptyMap();
        }
        ScriptGeneratorUI scriptGeneratorUI = this;
        String message$iv = "Retrieving native definitions for " + n + ' ' + StringUtil.pluralize((String)"element", (int)n);
        ((ScriptGeneratorUI)this_$iv).loadingPanel.setLoadingText(message$iv);
        try {
            map = this.retrieveNativeDefinitionsForElementsInternal(elements);
        }
        finally {
            ((ScriptGeneratorUI)this_$iv).loadingPanel.setLoadingText(normalLoadingPanelText);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<BasicElement, String[]> retrieveNativeDefinitionsForElementsInternal(List<? extends BasicElement> elements) {
        BasicModel model;
        LocalDataSource dataSource;
        Selection selection = this.selection;
        if (selection == null) {
            Intrinsics.throwNpe();
        }
        if ((dataSource = this.findDsForModel(model = selection.getModel())) == null) {
            Map map = JBIterable.from((Iterable)elements).toMap((Convertor)retrieveNativeDefinitionsForElementsInternal.1.INSTANCE, (Convertor)retrieveNativeDefinitionsForElementsInternal.2.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"JBIterable.from(elements\u2026taSource not found :(\")})");
            return map;
        }
        Map result2 = null;
        AutoCloseable autoCloseable = DatabaseSessionManager.facade$default(this.project, dataSource, null, null, DGDepartment.CODE_GENERATION, 12, null).connect();
        Throwable throwable = null;
        try {
            GuardedRef c2 = (GuardedRef)autoCloseable;
            ModelFactory modelFactory = new ModelFactory(BlackHoleTextStorage.INSTANCE);
            Object t = c2.get();
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"c.get()");
            DBIntrospector introspector = DBIntrospectorFactory.createIntrospector(this.project, modelFactory, (DatabaseConnection)t, dataSource);
            Object t2 = c2.get();
            Intrinsics.checkExpressionValueIsNotNull(t2, (String)"c.get()");
            introspector.attachToDB((DatabaseConnection)t2);
            result2 = introspector.introspectNativeDefinitions((Iterable<? extends BasicElement>)elements, false);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        Map map = result2;
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    private final void clear() {
        this.generatedText = null;
        this.inUI((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ ScriptGeneratorUI this$0;

            public final void invoke() {
                ScriptGeneratorUI.access$setDocument$p(this.this$0, null);
                this.this$0.getViewer$intellij_database_impl().getDocument().setText((CharSequence)"");
            }
            {
                this.this$0 = scriptGeneratorUI;
                super(0);
            }
        }));
    }

    public void dispose() {
        Content content = this.content;
        if (content == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"content");
        }
        content.putUserData(contextKey, null);
        this.loadingPanel.removeAll();
        ScriptGeneratorTool.INSTANCE.forgetProjectToolWindow$intellij_database_impl(this.project);
    }

    /*
     * WARNING - void declaration
     */
    private final <T> ArrayList<T> getItems(@NotNull ComboBox<T> $receiver) {
        int n = $receiver.getItemCount();
        ArrayList<Object> list = new ArrayList<Object>(n);
        int n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            void i2;
            list.add($receiver.getItemAt((int)i2));
            ++i2;
        }
        return list;
    }

    private final void inUI(Function0<Unit> block) {
        Companion.invokeLater((Function0<Unit>)((Function0)new Function0<Unit>(block){
            final /* synthetic */ Function0 $block;

            public final void invoke() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(this){
                    final /* synthetic */ inUI.1 this$0;

                    public final void run() {
                        this.this$0.$block.invoke();
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$block = function0;
                super(0);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T doing(String message2, Function0<? extends T> operation2) {
        this.loadingPanel.setLoadingText(message2);
        try {
            Object object = operation2.invoke();
            return (T)object;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.loadingPanel.setLoadingText(normalLoadingPanelText);
            InlineMarker.finallyEnd((int)1);
        }
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public ScriptGeneratorUI(@NotNull Project project) {
        Document $receiver$iv;
        ComboBox comboBox;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.alarm = new SingleAlarm(new Runnable(this){
            final /* synthetic */ ScriptGeneratorUI this$0;

            public final void run() {
                ScriptGeneratorUI.access$regenerate(this.this$0);
            }
            {
                this.this$0 = scriptGeneratorUI;
            }
        }, 250, Alarm.ThreadToUse.POOLED_THREAD, (Disposable)ApplicationManager.getApplication());
        this.settings = (ScriptGeneratorSettings)ServiceManager.getService((Project)this.project, ScriptGeneratorSettings.class);
        this.category = ScriptCategory.CREATE_COMPLETE;
        this.generationInProgress = new Object();
        this.toRequestFocus = new AtomicBoolean(false);
        this.scriptingOptions = DefaultScriptingOptions.INSTANCE;
        EditorFactory editorFactory = EditorFactory.getInstance();
        Object object2 = editorFactory.createDocument((CharSequence)"");
        ScriptGeneratorUI scriptGeneratorUI = this;
        Object $receiver = object2;
        $receiver.setReadOnly(true);
        scriptGeneratorUI.document = object = object2;
        this.viewer = new EditorTextField(this.document, this.project, null, true, false);
        this.viewer.setFontInheritedFromLAF(false);
        this.viewer.addSettingsProvider(new EditorSettingsProvider(){

            public final void customizeSettings(EditorEx editor) {
                PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.getProject());
                EditorEx editorEx = editor;
                Intrinsics.checkExpressionValueIsNotNull((Object)editorEx, (String)"editor");
                PsiFile psiFile = psiDocumentManager.getPsiFile((Document)editorEx.getDocument());
                if (psiFile != null) {
                    DatabaseDialogsHelper.setSpecificSyntaxHighlighter(psiFile, this.getProject(), psiFile.getLanguage(), editor);
                }
                editor.setHorizontalScrollbarVisible(true);
                editor.setVerticalScrollbarVisible(true);
                editor.setBorder((Border)JBUI.Borders.empty());
                EditorSettings editorSettings = editor.getSettings();
                Intrinsics.checkExpressionValueIsNotNull((Object)editorSettings, (String)"editor.settings");
                EditorSettings settings = editorSettings;
                settings.setWheelFontChangeEnabled(true);
                settings.setFoldingOutlineShown(true);
                settings.setAdditionalLinesCount(2);
                settings.setUseSoftWraps(false);
                settings.setLineNumbersShown(true);
                settings.setAnimatedScrolling(true);
            }
        });
        object2 = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this);
        scriptGeneratorUI = this;
        $receiver = object2;
        $receiver.add((Component)this.viewer, (Object)"Center");
        $receiver.setLoadingText(normalLoadingPanelText);
        object = object2;
        scriptGeneratorUI.loadingPanel = object;
        object2 = implementedCategories;
        ComboBox comboBox2 = comboBox;
        object = comboBox;
        scriptGeneratorUI = this;
        void v1 = $receiver$iv;
        if (v1 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        void thisCollection$iv = v1;
        ScriptCategory[] scriptCategoryArray = thisCollection$iv.toArray(new ScriptCategory[0]);
        if (scriptCategoryArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        ScriptCategory[] scriptCategoryArray2 = scriptCategoryArray;
        comboBox2((Object[])scriptCategoryArray2);
        $receiver$iv = object;
        $receiver = $receiver$iv;
        $receiver.setEditable(false);
        $receiver.setSelectedItem((Object)this.category);
        $receiver.addActionListener(new ActionListener((ComboBox)$receiver, this){
            final /* synthetic */ ComboBox receiver$0;
            final /* synthetic */ ScriptGeneratorUI this$0;
            {
                this.receiver$0 = comboBox;
                this.this$0 = scriptGeneratorUI;
            }

            public final void actionPerformed(ActionEvent it) {
                ScriptCategory selectedCategory;
                Object object = this.receiver$0.getSelectedItem();
                if (!(object instanceof ScriptCategory)) {
                    object = null;
                }
                if ((selectedCategory = (ScriptCategory)((Object)object)) != null) {
                    ScriptGeneratorUI.access$assignCategory(this.this$0, selectedCategory);
                    ScriptGeneratorUI.access$adjustOptionsUI(this.this$0);
                    ScriptGeneratorUI.access$getAlarm$p(this.this$0).cancelAndRequest();
                }
            }
        });
        scriptGeneratorUI.categorySelector = object = $receiver$iv;
        this.optionsPanel = new ScriptOptionsPanel((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.processOptionChange();
                alarm.cancelAndRequest();
            }
        }));
        this.layoutPanel = new ScriptFileLayoutPanel(this.project, (Function1)new Function1<ScriptConsumer<?>, Unit>(){

            public final void invoke(@NotNull ScriptConsumer<?> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                ScriptingTask scriptingTask = this.createTask(it);
                if (scriptingTask == null) {
                    return;
                }
                ScriptingTask task = scriptingTask;
                ScriptGenerators.INSTANCE.makeScript(this.getProject(), task);
                this.saveOutputSettings();
            }
        });
        this.layoutPanel.setPath(this.settings.getOutputPath());
        this.layoutPanel.setLayout(this.settings.getOutputLayout());
        Object $receiver2 = $receiver = new JPanel((LayoutManager)new VerticalLayout(4), false);
        ((Container)$receiver2).add(new ScriptOptionsPanel.LabeledComponent("Generate:", (JComponent)this.categorySelector));
        ((Container)$receiver2).add(this.optionsPanel.getComponent());
        Object optionsInnerPanel = $receiver;
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)((Component)optionsInnerPanel), (boolean)true);
        Intrinsics.checkExpressionValueIsNotNull((Object)jScrollPane, (String)"ScrollPaneFactory.create\u2026(optionsInnerPanel, true)");
        JScrollPane optionsScrollPane = jScrollPane;
        optionsScrollPane.setVerticalScrollBarPolicy(20);
        optionsScrollPane.setHorizontalScrollBarPolicy(31);
        FinalAction copyToClipboardAction2 = new FinalAction(this, "Copy to Clipboard", null, AllIcons.Actions.Copy, (Function0)new Function0<Unit>(this){
            final /* synthetic */ ScriptGeneratorUI this$0;

            public final void invoke() {
                ScriptGeneratorUI.access$copyToClipboard(this.this$0);
            }
            {
                this.this$0 = scriptGeneratorUI;
                super(0);
            }
        }, 2, null);
        FinalAction saveToFileAction2 = new FinalAction(this, "Save into a File", null, AllIcons.Actions.Menu_saveall, (Function0)new Function0<Unit>(this){
            final /* synthetic */ ScriptGeneratorUI this$0;

            public final void invoke() {
                ScriptGeneratorUI.access$saveToFile(this.this$0);
            }
            {
                this.this$0 = scriptGeneratorUI;
                super(0);
            }
        }, 2, null);
        FinalAction openInConsoleAction2 = new FinalAction(this, "Open in Console", null, DatabaseIcons.ConsoleRun, (Function0)new Function0<Unit>(this){
            final /* synthetic */ ScriptGeneratorUI this$0;

            public final void invoke() {
                ScriptGeneratorUI.access$openInConsole(this.this$0);
            }
            {
                this.this$0 = scriptGeneratorUI;
                super(0);
            }
        }, 2, null);
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup actions = new DefaultActionGroup(new AnAction[]{copyToClipboardAction2, saveToFileAction2, openInConsoleAction2});
        ActionToolbar actionToolbar = actionManager.createActionToolbar("EditorToolbar", (ActionGroup)actions, false);
        Intrinsics.checkExpressionValueIsNotNull((Object)actionToolbar, (String)"actionManager.createActi\u2026_TOOLBAR, actions, false)");
        ActionToolbar actionToolbar2 = actionToolbar;
        JBTabbedPane tabs = new JBTabbedPane(2);
        tabs.addTab(null, AllIcons.General.GearPlain, (Component)optionsScrollPane, "SQL Generator Options");
        tabs.addTab(null, AllIcons.Actions.Menu_saveall, (Component)this.layoutPanel.getComponent(), "File Output Options");
        JPanel jPanel = new JPanel(new BorderLayout());
        scriptGeneratorUI = this;
        JPanel $receiver3 = jPanel;
        $receiver3.add((Component)this.loadingPanel, "Center");
        $receiver3.add((Component)tabs, "West");
        $receiver3.add((Component)actionToolbar2.getComponent(), "East");
        object = jPanel;
        scriptGeneratorUI.mainPanel = object;
    }

    static {
        Companion = new Companion(null);
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        ScriptGeneratorUI.application = application;
        contextKey = new Key("DatabaseScriptingContext");
        modelKey = new Key("DatabaseModel");
        implementedCategories = CollectionsKt.listOf((Object[])new ScriptCategory[]{ScriptCategory.CREATE_COMPLETE, ScriptCategory.CREATE_DEFINITION, ScriptCategory.NATIVE_DEFINITION, ScriptCategory.ENABLE_CONSTRAINTS, ScriptCategory.DISABLE_CONSTRAINTS, ScriptCategory.REFRESH, ScriptCategory.EXECUTE, ScriptCategory.TRUNCATE, ScriptCategory.DROP_COMPLETE});
        Logger logger = Logger.getInstance(ScriptGeneratorUI.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(ScriptGeneratorUI::class.java)");
        log = logger;
        formattableKindRemapping = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)((Object)CompositeText.Kind.PLAIN_TEXT), (Object)((Object)CompositeText.Kind.PLAIN_TEXT)), TuplesKt.to((Object)((Object)CompositeText.Kind.FIXED_TEXT), (Object)((Object)CompositeText.Kind.PLAIN_TEXT)), TuplesKt.to((Object)((Object)CompositeText.Kind.ORIGINAL_TEXT), (Object)((Object)CompositeText.Kind.DECOMPILED_TEXT)), TuplesKt.to((Object)((Object)CompositeText.Kind.DECOMPILED_TEXT), (Object)((Object)CompositeText.Kind.DECOMPILED_TEXT)), TuplesKt.to((Object)((Object)CompositeText.Kind.SPECIFICATION_TEXT), (Object)((Object)CompositeText.Kind.PLAIN_TEXT)), TuplesKt.to((Object)((Object)CompositeText.Kind.SQL_DELIMITER), (Object)((Object)CompositeText.Kind.SQL_DELIMITER))});
    }

    @NotNull
    public static final /* synthetic */ Map access$retrieveNativeDefinitionsForElements(ScriptGeneratorUI $this, @NotNull List elements) {
        return $this.retrieveNativeDefinitionsForElements(elements);
    }

    public static final /* synthetic */ void access$prepareDocument(ScriptGeneratorUI $this) {
        $this.prepareDocument();
    }

    public static final /* synthetic */ void access$showTheScriptInsideUI(ScriptGeneratorUI $this) {
        $this.showTheScriptInsideUI();
    }

    @Nullable
    public static final /* synthetic */ Document access$getDocument$p(ScriptGeneratorUI $this) {
        return $this.document;
    }

    public static final /* synthetic */ void access$setDocument$p(ScriptGeneratorUI $this, @Nullable Document document) {
        $this.document = document;
    }

    public static final /* synthetic */ void access$regenerate(ScriptGeneratorUI $this) {
        $this.regenerate();
    }

    public static final /* synthetic */ void access$assignCategory(ScriptGeneratorUI $this, @NotNull ScriptCategory category) {
        $this.assignCategory(category);
    }

    public static final /* synthetic */ void access$adjustOptionsUI(ScriptGeneratorUI $this) {
        $this.adjustOptionsUI();
    }

    public static final /* synthetic */ void access$copyToClipboard(ScriptGeneratorUI $this) {
        $this.copyToClipboard();
    }

    public static final /* synthetic */ void access$saveToFile(ScriptGeneratorUI $this) {
        $this.saveToFile();
    }

    public static final /* synthetic */ void access$openInConsole(ScriptGeneratorUI $this) {
        $this.openInConsole();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/script/generator/ui/ScriptGeneratorUI$Selection;", "", "model", "Lcom/intellij/database/model/basic/BasicModel;", "elements", "", "Lcom/intellij/database/model/basic/BasicElement;", "(Lcom/intellij/database/model/basic/BasicModel;Ljava/util/Collection;)V", "getElements", "()Ljava/util/Collection;", "getModel", "()Lcom/intellij/database/model/basic/BasicModel;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.database.impl"})
    private static final class Selection {
        @NotNull
        private final BasicModel model;
        @NotNull
        private final Collection<BasicElement> elements;

        @NotNull
        public final BasicModel getModel() {
            return this.model;
        }

        @NotNull
        public final Collection<BasicElement> getElements() {
            return this.elements;
        }

        public Selection(@NotNull BasicModel model, @NotNull Collection<? extends BasicElement> elements) {
            Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            this.model = model;
            this.elements = elements;
        }

        @NotNull
        public final BasicModel component1() {
            return this.model;
        }

        @NotNull
        public final Collection<BasicElement> component2() {
            return this.elements;
        }

        @NotNull
        public final Selection copy(@NotNull BasicModel model, @NotNull Collection<? extends BasicElement> elements) {
            Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            return new Selection(model, elements);
        }

        @NotNull
        public static /* synthetic */ Selection copy$default(Selection selection, BasicModel basicModel, Collection collection, int n, Object object) {
            if ((n & 1) != 0) {
                basicModel = selection.model;
            }
            if ((n & 2) != 0) {
                collection = selection.elements;
            }
            return selection.copy(basicModel, collection);
        }

        @NotNull
        public String toString() {
            return "Selection(model=" + this.model + ", elements=" + this.elements + ")";
        }

        public int hashCode() {
            BasicModel basicModel = this.model;
            Collection<BasicElement> collection = this.elements;
            return (basicModel != null ? basicModel.hashCode() : 0) * 31 + (collection != null ? ((Object)collection).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Selection)) break block3;
                    Selection selection = (Selection)object;
                    if (!Intrinsics.areEqual((Object)this.model, (Object)selection.model) || !Intrinsics.areEqual(this.elements, selection.elements)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B5\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/script/generator/ui/ScriptGeneratorUI$FinalAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "text", "", "description", "icon", "Ljavax/swing/Icon;", "action", "Lkotlin/Function0;", "", "(Lcom/intellij/database/script/generator/ui/ScriptGeneratorUI;Ljava/lang/String;Ljava/lang/String;Ljavax/swing/Icon;Lkotlin/jvm/functions/Function0;)V", "getAction", "()Lkotlin/jvm/functions/Function0;", "actionPerformed", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.database.impl"})
    private final class FinalAction
    extends AnAction {
        @NotNull
        private final Function0<Unit> action;
        final /* synthetic */ ScriptGeneratorUI this$0;

        @NotNull
        public final Function0<Unit> getAction() {
            return this.action;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            this.action.invoke();
        }

        public FinalAction(@NotNull ScriptGeneratorUI $outer, @Nullable String text2, @Nullable String description, @NotNull Icon icon, Function0<Unit> action) {
            Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
            Intrinsics.checkParameterIsNotNull(action, (String)"action");
            super(text2, description, icon);
            this.this$0 = $outer;
            this.action = action;
        }

        public /* synthetic */ FinalAction(ScriptGeneratorUI scriptGeneratorUI, String string, String string2, Icon icon, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                icon = null;
            }
            this(scriptGeneratorUI, string, string2, icon, (Function0<Unit>)function0);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020%0'R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u000bR\u000e\u0010#\u001a\u00020\u0017X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/database/script/generator/ui/ScriptGeneratorUI$Companion;", "", "()V", "application", "Lcom/intellij/openapi/application/Application;", "getApplication", "()Lcom/intellij/openapi/application/Application;", "contextKey", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/database/script/generator/ui/ScriptGeneratorUI;", "getContextKey", "()Lcom/intellij/openapi/util/Key;", "formattableKindRemapping", "", "Lcom/intellij/database/script/CompositeText$Kind;", "getFormattableKindRemapping", "()Ljava/util/Map;", "implementedCategories", "", "Lcom/intellij/database/script/generator/ScriptCategory;", "getImplementedCategories", "()Ljava/util/List;", "lastPath", "", "getLastPath", "()Ljava/lang/String;", "setLastPath", "(Ljava/lang/String;)V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "modelKey", "Lcom/intellij/database/model/basic/BasicModel;", "getModelKey", "normalLoadingPanelText", "invokeLater", "", "whatToDo", "Lkotlin/Function0;", "intellij.database.impl"})
    public static final class Companion {
        @NotNull
        public final Application getApplication() {
            return application;
        }

        @NotNull
        public final Key<ScriptGeneratorUI> getContextKey() {
            return contextKey;
        }

        @NotNull
        public final Key<BasicModel> getModelKey() {
            return modelKey;
        }

        @NotNull
        public final List<ScriptCategory> getImplementedCategories() {
            return implementedCategories;
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        @Nullable
        public final String getLastPath() {
            return lastPath;
        }

        public final void setLastPath(@Nullable String string) {
            lastPath = string;
        }

        @NotNull
        public final Map<CompositeText.Kind, CompositeText.Kind> getFormattableKindRemapping() {
            return formattableKindRemapping;
        }

        public final void invokeLater(@NotNull Function0<Unit> whatToDo) {
            Intrinsics.checkParameterIsNotNull(whatToDo, (String)"whatToDo");
            Function0<Unit> function0 = whatToDo;
            this.getApplication().invokeLater((Runnable)new ScriptGeneratorUI$sam$java_lang_Runnable$0(function0), this.getApplication().getAnyModalityState());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

