/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.base;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.library.NodeModulesDirectoryManager;
import com.intellij.javascript.nodejs.packageJson.PackageJsonUpdateNotifier;
import com.intellij.lang.javascript.buildTools.base.JsbtFileManager;
import com.intellij.lang.javascript.buildTools.base.JsbtService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JsbtStartupActivity
implements StartupActivity,
DumbAware {
    private static final Logger LOG = Logger.getInstance(JsbtStartupActivity.class);

    public void runActivity(@NotNull Project project) {
        if (project == null) {
            JsbtStartupActivity.$$$reportNull$$$0(0);
        }
        NodeModulesDirectoryManager.getInstance(project).onProjectOpened();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        PackageJsonUpdateNotifier.getInstance(project).onProjectOpened();
        List servicesForDetection = ContainerUtil.newSmartList();
        for (JsbtService service : (JsbtService[])JsbtService.EP_NAME.getExtensions()) {
            JsbtFileManager fileManager = service.getFileManager(project);
            if (fileManager.hasBuildfiles()) {
                JsbtStartupActivity.setAvailable(project, service, Collections.emptyList());
                continue;
            }
            if (fileManager.isDetectionDone()) continue;
            fileManager.setDetectionDone();
            servicesForDetection.add(service);
            LOG.info("Detecting buildfiles for " + fileManager.getClass().getName());
        }
        if (!servicesForDetection.isEmpty()) {
            JsbtStartupActivity.scheduleDetection(project, servicesForDetection);
        }
    }

    private static void scheduleDetection(@NotNull Project project, @NotNull List<JsbtService> servicesForDetection) {
        if (project == null) {
            JsbtStartupActivity.$$$reportNull$$$0(1);
        }
        if (servicesForDetection == null) {
            JsbtStartupActivity.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (project == null) {
                JsbtStartupActivity.$$$reportNull$$$0(13);
            }
            if (servicesForDetection == null) {
                JsbtStartupActivity.$$$reportNull$$$0(14);
            }
            RefreshQueue.getInstance().refresh(true, true, () -> {
                if (project == null) {
                    JsbtStartupActivity.$$$reportNull$$$0(15);
                }
                if (servicesForDetection == null) {
                    JsbtStartupActivity.$$$reportNull$$$0(16);
                }
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    if (project == null) {
                        JsbtStartupActivity.$$$reportNull$$$0(17);
                    }
                    if (servicesForDetection == null) {
                        JsbtStartupActivity.$$$reportNull$$$0(18);
                    }
                    JsbtStartupActivity.doDetect(project, servicesForDetection);
                });
            }, ManagingFS.getInstance().getRoots((NewVirtualFileSystem)LocalFileSystem.getInstance()));
        }, ModalityState.NON_MODAL, project.getDisposed());
    }

    private static void doDetect(@NotNull Project project, @NotNull List<JsbtService> servicesForDetection) {
        if (project == null) {
            JsbtStartupActivity.$$$reportNull$$$0(3);
        }
        if (servicesForDetection == null) {
            JsbtStartupActivity.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            if (project == null) {
                JsbtStartupActivity.$$$reportNull$$$0(11);
            }
            if (servicesForDetection == null) {
                JsbtStartupActivity.$$$reportNull$$$0(12);
            }
            if (project.isDisposed()) {
                return;
            }
            for (JsbtService service : servicesForDetection) {
                List<VirtualFile> buildfiles = service.detectAllBuildfilesInContentRoots(project, true, true);
                LOG.info("Found " + buildfiles + " for " + service.getClass().getName());
                if (buildfiles.isEmpty() || !NodeJsInterpreterManager.getInstance(project).isInterpreterAvailable()) continue;
                JsbtStartupActivity.setAvailable(project, service, buildfiles);
            }
        });
    }

    private static void setAvailable(@NotNull Project project, @NotNull JsbtService service, @NotNull List<VirtualFile> buildfilesToAdd) {
        if (project == null) {
            JsbtStartupActivity.$$$reportNull$$$0(5);
        }
        if (service == null) {
            JsbtStartupActivity.$$$reportNull$$$0(6);
        }
        if (buildfilesToAdd == null) {
            JsbtStartupActivity.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (buildfilesToAdd == null) {
                JsbtStartupActivity.$$$reportNull$$$0(8);
            }
            if (service == null) {
                JsbtStartupActivity.$$$reportNull$$$0(9);
            }
            if (project == null) {
                JsbtStartupActivity.$$$reportNull$$$0(10);
            }
            for (VirtualFile buildfile : buildfilesToAdd) {
                service.getFileManager(project).addBuildfile(buildfile);
            }
            service.getToolWindowManager(project).setAvailable();
        }, project.getDisposed());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 12: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "servicesForDetection";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildfilesToAdd";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/buildTools/base/JsbtStartupActivity";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runActivity";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "scheduleDetection";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doDetect";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "setAvailable";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$setAvailable$4";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$doDetect$3";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$scheduleDetection$2";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$1";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

