/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm.rc;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonProperty;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsService;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmConfigurationType;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfiguration;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunSettings;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NpmRunConfigurationProducer
extends RunConfigurationProducer<NpmRunConfiguration> {
    protected NpmRunConfigurationProducer() {
        super(NpmConfigurationType.class);
    }

    protected boolean setupConfigurationFromContext(NpmRunConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        NpmRunSettings runSettings = NpmRunConfigurationProducer.createRunSettingsFromContext(configuration.getRunSettings(), context, sourceElement);
        if (runSettings == null) {
            return false;
        }
        NpmRunConfigurationProducer.setupConfigurationFromSettings(configuration, runSettings);
        return true;
    }

    public boolean isConfigurationFromContext(NpmRunConfiguration configuration, ConfigurationContext context) {
        NpmRunSettings thisRunSettings = NpmRunConfigurationProducer.createRunSettingsFromContext(configuration.getRunSettings(), context, null);
        if (thisRunSettings == null) {
            return false;
        }
        return NpmScriptsService.getInstance().isConfigurationMatched((RunConfiguration)configuration, thisRunSettings);
    }

    public static void setupConfigurationFromSettings(@NotNull NpmRunConfiguration configuration, @NotNull NpmRunSettings runSettings) {
        if (configuration == null) {
            NpmRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        if (runSettings == null) {
            NpmRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        configuration.setRunSettings(runSettings);
        configuration.setGeneratedName();
    }

    @Nullable
    private static NpmRunSettings createRunSettingsFromContext(@NotNull NpmRunSettings templateRunSettings, @NotNull ConfigurationContext context, @Nullable Ref<PsiElement> sourceElement) {
        PsiElement element;
        if (templateRunSettings == null) {
            NpmRunConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (context == null) {
            NpmRunConfigurationProducer.$$$reportNull$$$0(3);
        }
        if ((element = NpmRunConfigurationProducer.getElement(context)) == null || !element.isValid()) {
            return null;
        }
        JsonFile psiPackageJson = PackageJsonUtil.getContainingPackageJsonFile(element);
        if (psiPackageJson == null) {
            return null;
        }
        VirtualFile virtualPackageJson = psiPackageJson.getVirtualFile();
        if (virtualPackageJson == null) {
            return null;
        }
        JsonProperty scriptProperty = NpmRunConfigurationProducer.findContainingScriptProperty(element);
        if (scriptProperty == null) {
            return null;
        }
        NpmRunSettings.Builder builder = templateRunSettings.toBuilder();
        builder.setPackageJsonPath(virtualPackageJson.getPath());
        builder.setCommand(NpmCommand.RUN_SCRIPT);
        builder.setScriptNames(Collections.singletonList(scriptProperty.getName()));
        if (sourceElement != null) {
            sourceElement.set((Object)scriptProperty);
        }
        return builder.build();
    }

    @Nullable
    private static PsiElement getElement(@NotNull ConfigurationContext context) {
        Location location;
        if (context == null) {
            NpmRunConfigurationProducer.$$$reportNull$$$0(4);
        }
        return (location = context.getLocation()) != null ? location.getPsiElement() : null;
    }

    @Nullable
    private static JsonProperty findContainingScriptProperty(@NotNull PsiElement element) {
        JsonProperty scriptProperty;
        JsonProperty scriptsProperty;
        if (element == null) {
            NpmRunConfigurationProducer.$$$reportNull$$$0(5);
        }
        if ((scriptsProperty = PackageJsonUtil.findContainingTopLevelProperty((PsiElement)(scriptProperty = PackageJsonUtil.findContainingProperty(element)))) != null && "scripts".equals(scriptsProperty.getName()) && scriptProperty != scriptsProperty) {
            return scriptProperty;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateRunSettings";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunConfigurationProducer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setupConfigurationFromSettings";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createRunSettingsFromContext";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findContainingScriptProperty";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

