/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSXHarmonyLanguageDialect;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.frameworks.react.ReactAttributeDescriptor;
import com.intellij.lang.javascript.frameworks.react.ReactXmlElementDescriptor;
import com.intellij.lang.javascript.frameworks.react.references.JSXNamespaceReference;
import com.intellij.lang.javascript.frameworks.react.references.JSXResolveUtil;
import com.intellij.lang.javascript.frameworks.react.tsx.TypeScriptReactComponentUtil;
import com.intellij.lang.javascript.frameworks.react.tsx.TypeScriptReactTagUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.impl.JSLocalImplicitElementImpl;
import com.intellij.lang.javascript.psi.ecma6.impl.JSXXmlLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.impl.source.xml.TagNameReference;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.HtmlXmlExtension;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.XmlTagNameProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactXmlExtension
extends HtmlXmlExtension
implements XmlTagNameProvider {
    public static final String REACT_DEFAULT_MODULE = "react";
    public static final String FRAGMENT_NAME = "Fragment";
    private static final ResolveCache.AbstractResolver<ReactTagNameReference, PsiElement> RESOLVER = (reference, incompleteCode) -> {
        XmlTag tag = reference.getTagElement();
        assert (tag != null);
        if (ReactXmlExtension.hasQualifiedName(tag)) {
            return ReactXmlExtension.resolveQualifiedComponent(tag);
        }
        return ReactXmlExtension.resolveTopLevelTagOrComponent(tag);
    };
    private static final String PROPERTY_RENDER = "render";
    private static final String PROPERTY_PROPS = "propTypes";
    public static final String GET_DEFAULT_PROPS = "getDefaultProps";
    public static final String DEFAULT_PROPS = "defaultProps";
    public static final String CHILDREN = "children";
    private static final XmlExtension.AttributeValuePresentation BRACES_PRESENTATION = new XmlExtension.AttributeValuePresentation(){

        @NotNull
        public String getPrefix() {
            if ("{" == null) {
                1.$$$reportNull$$$0(0);
            }
            return "{";
        }

        @NotNull
        public String getPostfix() {
            if ("}" == null) {
                1.$$$reportNull$$$0(1);
            }
            return "}";
        }

        public boolean showAutoPopup() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/lang/javascript/frameworks/react/ReactXmlExtension$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPrefix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPostfix";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    };
    private static final XmlExtension.AttributeValuePresentation EMPTY_VALUE_PRESENTATION = new XmlExtension.AttributeValuePresentation(){

        @NotNull
        public String getPrefix() {
            if ("" == null) {
                2.$$$reportNull$$$0(0);
            }
            return "";
        }

        @NotNull
        public String getPostfix() {
            if ("" == null) {
                2.$$$reportNull$$$0(1);
            }
            return "";
        }

        public boolean showAutoPopup() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/lang/javascript/frameworks/react/ReactXmlExtension$2";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPrefix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPostfix";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    };

    @Nullable
    private static PsiElement resolveQualifiedComponent(@NotNull XmlTag tag) {
        JSXNamespaceReference parentRef;
        if (tag == null) {
            ReactXmlExtension.$$$reportNull$$$0(0);
        }
        if ((parentRef = ReactXmlExtension.getQualifierReference(tag)) == null) {
            return null;
        }
        String localName = tag.getLocalName();
        Collection<PsiElement> elements = JSXResolveUtil.expandReferenceElements((PsiElement)tag, parentRef);
        if (elements.isEmpty()) {
            return null;
        }
        Collection<PsiElement> candidates = JSXResolveUtil.resolveNestedName((PsiElement)tag, localName, elements, parentRef);
        Collection<PsiElement> components = ReactXmlExtension.resolveComponentNameForCandidates(tag, candidates);
        if (!components.isEmpty()) {
            return (PsiElement)ContainerUtil.getFirstItem(components);
        }
        return candidates.isEmpty() ? ReactXmlExtension.resolveGlobalComponentElements(tag, tag.getName()) : (PsiElement)ContainerUtil.getFirstItem(candidates);
    }

    @Nullable
    public static JSXNamespaceReference getFirstQualifierReference(@NotNull XmlTag tag) {
        PsiReference[] references;
        if (tag == null) {
            ReactXmlExtension.$$$reportNull$$$0(1);
        }
        if ((references = tag.getReferences()).length == 0) {
            return null;
        }
        for (PsiReference reference : references) {
            if (!(reference instanceof JSXNamespaceReference)) continue;
            return (JSXNamespaceReference)reference;
        }
        return null;
    }

    @Nullable
    public static JSXNamespaceReference getQualifierReference(@NotNull XmlTag tag) {
        PsiReference[] references;
        if (tag == null) {
            ReactXmlExtension.$$$reportNull$$$0(2);
        }
        if ((references = tag.getReferences()).length == 0) {
            return null;
        }
        PsiReference lastRef = references[references.length - 1];
        if (!(lastRef instanceof JSXNamespaceReference)) {
            return null;
        }
        return (JSXNamespaceReference)lastRef;
    }

    @Nullable
    private static PsiElement resolveTopLevelTagOrComponent(XmlTag tag) {
        String tagName = tag.getName();
        boolean isTypeScript = DialectDetector.isTypeScript((PsiElement)tag);
        boolean isComponentName = ReactXmlExtension.isComponentName(tagName);
        if (isTypeScript && !isComponentName) {
            return TypeScriptReactTagUtil.resolveTag(tag);
        }
        if (!isComponentName) {
            return null;
        }
        Collection<? extends PsiElement> candidates = JSXResolveUtil.resolveTopLevelName((PsiElement)tag, tagName);
        Collection<PsiElement> components = ReactXmlExtension.resolveComponentNameForCandidates(tag, candidates);
        if (!components.isEmpty()) {
            return (PsiElement)ContainerUtil.getFirstItem(components);
        }
        return candidates.isEmpty() ? ReactXmlExtension.resolveGlobalComponentElements(tag, tagName) : (PsiElement)ContainerUtil.getFirstItem(candidates);
    }

    @Nullable
    private static PsiElement resolveGlobalComponentElements(@NotNull XmlTag tag, @NotNull String fullTagName) {
        if (tag == null) {
            ReactXmlExtension.$$$reportNull$$$0(3);
        }
        if (fullTagName == null) {
            ReactXmlExtension.$$$reportNull$$$0(4);
        }
        if (DialectDetector.isTypeScript((PsiElement)tag)) {
            return null;
        }
        return ReactXmlExtension.resolveComponentForIndexes(tag, fullTagName);
    }

    @NotNull
    private static PsiElement getElementForResolve(@NotNull PsiElement element, @NotNull PsiElement candidate, @NotNull XmlTag tag) {
        PsiElement signatureElement;
        JSRecordTypeImpl recordType;
        JSResolveResult signature;
        if (element == null) {
            ReactXmlExtension.$$$reportNull$$$0(5);
        }
        if (candidate == null) {
            ReactXmlExtension.$$$reportNull$$$0(6);
        }
        if (tag == null) {
            ReactXmlExtension.$$$reportNull$$$0(7);
        }
        if (element instanceof ES6ImportedBinding || element instanceof ES6ImportSpecifierAlias || element instanceof TypeScriptImportStatement || element instanceof JSVariable) {
            PsiElement psiElement = element;
            if (psiElement == null) {
                ReactXmlExtension.$$$reportNull$$$0(8);
            }
            return psiElement;
        }
        if (element instanceof ES6ImportSpecifier) {
            Collection<PsiElement> elements = JSResolveResult.resolveReference((PsiPolyVariantReference)((ES6ImportSpecifier)element));
            PsiElement resolveResult = (PsiElement)ContainerUtil.getFirstItem(elements);
            PsiElement psiElement = (PsiElement)ObjectUtils.coalesce((Object)resolveResult, (Object)candidate);
            if (psiElement == null) {
                ReactXmlExtension.$$$reportNull$$$0(9);
            }
            return psiElement;
        }
        if (candidate instanceof TypeScriptFunction && ((TypeScriptFunction)candidate).isOverloadImplementation() && (signature = TypeScriptSignatureChooser.getOverloadSignatureForImplementation(candidate, ContainerUtil.createMaybeSingletonList((Object)(recordType = TypeScriptReactComponentUtil.createRecordTypeFromTag(tag, candidate))), (NullableLazyValue<JSType>)NullableLazyValue.createValue(() -> null), null, false)).isValidResult() && (signatureElement = signature.getElement()) != null) {
            PsiElement psiElement = signatureElement;
            if (psiElement == null) {
                ReactXmlExtension.$$$reportNull$$$0(10);
            }
            return psiElement;
        }
        PsiElement psiElement = candidate;
        if (psiElement == null) {
            ReactXmlExtension.$$$reportNull$$$0(11);
        }
        return psiElement;
    }

    @Nullable
    private static PsiElement resolveComponentForIndexes(@NotNull XmlTag tag, @NotNull String qualifiedName) {
        GlobalSearchScope scope;
        if (tag == null) {
            ReactXmlExtension.$$$reportNull$$$0(12);
        }
        if (qualifiedName == null) {
            ReactXmlExtension.$$$reportNull$$$0(13);
        }
        if ((scope = ReactXmlExtension.getResolveScopeForIndexProcessing(tag, ReactXmlExtension.hasQualifiedName(tag))) == null) {
            return null;
        }
        Collection<JSPsiElementBase> results = JSClassResolver.getInstance().findElementsByQNameIncludingImplicit(qualifiedName, scope);
        PsiElement possibleCandidate = null;
        for (PsiElement psiElement : results) {
            if (ReactXmlExtension.isReactComponent(psiElement)) {
                return psiElement;
            }
            if (!ReactXmlExtension.isPossibleReactComponent(psiElement)) continue;
            possibleCandidate = psiElement;
        }
        return possibleCandidate;
    }

    @Nullable
    public static GlobalSearchScope getResolveScopeForIndexProcessing(@NotNull XmlTag tag, boolean hasQName) {
        boolean acceptOnlyModules;
        if (tag == null) {
            ReactXmlExtension.$$$reportNull$$$0(14);
        }
        boolean bl = acceptOnlyModules = ES6PsiUtil.findExternalModule((PsiElement)tag) != null;
        if (!hasQName && acceptOnlyModules) {
            return null;
        }
        final PsiManager manager = tag.getManager();
        return new DelegatingGlobalSearchScope(JSResolveUtil.getResolveScope((PsiElement)tag)){

            public boolean contains(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!super.contains(file2)) {
                    return false;
                }
                PsiFile psiFile = manager.findFile(file2);
                if (!(psiFile instanceof JSFile)) {
                    return false;
                }
                return ((JSFile)psiFile).isCommonJSModule() == acceptOnlyModules;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/frameworks/react/ReactXmlExtension$3", "contains"));
            }
        };
    }

    @Contract(value="null -> false")
    public static boolean isComponentName(@Nullable String tagName) {
        if (tagName == null) {
            return false;
        }
        if (tagName.indexOf(".") > 0) {
            return true;
        }
        return StringUtil.isCapitalized((String)tagName);
    }

    @Nullable
    protected static JSExpression getInitializer(@NotNull PsiElement clazz) {
        if (clazz == null) {
            ReactXmlExtension.$$$reportNull$$$0(15);
        }
        if (clazz instanceof JSVariable) {
            return ((JSVariable)clazz).getInitializerOrStub();
        }
        if (clazz instanceof JSDefinitionExpression) {
            return ((JSDefinitionExpression)clazz).getInitializerOrStub();
        }
        if (clazz instanceof JSProperty) {
            JSFunction function = ((JSProperty)clazz).tryGetFunctionInitializer();
            return function instanceof JSExpression ? (JSExpression)function : null;
        }
        return null;
    }

    public boolean isAvailable(PsiFile file2) {
        if (file2 instanceof JSFile) {
            return true;
        }
        FileType type = file2.getFileType();
        if (type instanceof LanguageFileType && HTMLLanguage.INSTANCE.equals(((LanguageFileType)type).getLanguage())) {
            JSLanguageDialect configuredJSVersion = DialectDetector.getConfiguredJSVersion(file2);
            return configuredJSVersion.getOptionHolder().isJSX;
        }
        return false;
    }

    @Nullable
    public TagNameReference createTagNameReference(ASTNode nameElement, boolean startTagFlag) {
        return nameElement.getTreeParent() instanceof JSXXmlLiteralExpressionImpl ? new ReactTagNameReference(nameElement, startTagFlag) : super.createTagNameReference(nameElement, startTagFlag);
    }

    public static boolean isPossibleReactComponent(@NotNull PsiElement candidate) {
        if (candidate == null) {
            ReactXmlExtension.$$$reportNull$$$0(16);
        }
        if (ReactXmlExtension.isReactComponent(candidate)) {
            return true;
        }
        if (candidate instanceof JSVariable || candidate instanceof JSDefinitionExpression || candidate instanceof JSProperty) {
            if (candidate instanceof JSVariable && DialectDetector.isTypeScript(candidate)) {
                return ReactXmlExtension.isCompatibleComponentType(((JSVariable)candidate).getType());
            }
            JSExpression initializer = ReactXmlExtension.getInitializer(candidate);
            JSType type = JSResolveUtil.getExpressionJSType(initializer);
            return ReactXmlExtension.isCompatibleComponentType(type);
        }
        if (candidate instanceof JSClass && !(candidate instanceof TypeScriptTypeAlias)) {
            return !((JSClass)candidate).isInterface() && ((JSClass)candidate).getExtendsList() != null;
        }
        if (candidate instanceof JSCallExpression) {
            JSType type = JSResolveUtil.getExpressionJSType((JSExpression)candidate);
            return ReactXmlExtension.isCompatibleComponentType(type);
        }
        return true;
    }

    protected static boolean isCompatibleComponentType(JSType type) {
        if (type instanceof JSPrimitiveType && !(type instanceof JSStringType)) {
            return false;
        }
        return !(type instanceof JSRecordType) || ((JSRecordType)type).hasProperty(PROPERTY_RENDER);
    }

    public static boolean isReactComponent(@Nullable PsiElement candidate) {
        if (candidate == null) {
            return false;
        }
        if (candidate instanceof JSVariable || candidate instanceof JSDefinitionExpression) {
            JSExpression initializer = ReactXmlExtension.getInitializer(candidate);
            if (initializer instanceof JSXmlLiteralExpression) {
                return true;
            }
            if (JSXHarmonyLanguageDialect.isReactComponent(initializer)) {
                return true;
            }
            if (DialectDetector.isTypeScript(candidate) && candidate instanceof JSVariable) {
                JSRecordType recordType;
                JSType type = ((JSVariable)candidate).getType();
                JSRecordType jSRecordType = recordType = type != null ? type.asRecordType() : null;
                if (recordType != null && (recordType.hasProperty(PROPERTY_RENDER) || recordType.hasProperty(PROPERTY_PROPS))) {
                    return true;
                }
                if (initializer instanceof JSFunction && ReactXmlExtension.isComponentName(((JSVariable)candidate).getName())) {
                    return ReactXmlExtension.isFunctionComponentBySignature((JSFunction)initializer);
                }
            }
        }
        if (candidate instanceof JSCallExpression && JSXHarmonyLanguageDialect.isReactComponent((JSExpression)((JSCallExpression)candidate))) {
            return true;
        }
        if (candidate instanceof ES6ImportExportDeclarationPart || candidate instanceof TypeScriptImportStatement) {
            return true;
        }
        if (candidate instanceof JSFunction) {
            JSFunction function = (JSFunction)candidate;
            return function.getName() != null && ReactXmlExtension.isComponentName(function.getName());
        }
        if (candidate instanceof JSClass) {
            return ReactXmlExtension.isAcceptableClassComponent((JSClass)candidate) == ThreeState.YES;
        }
        return false;
    }

    public void addTagNameVariants(List<LookupElement> elements, @NotNull XmlTag tag, String prefix) {
        if (tag == null) {
            ReactXmlExtension.$$$reportNull$$$0(17);
        }
    }

    @Nullable
    static String getLocalName(@NotNull PsiElement element) {
        if (element == null) {
            ReactXmlExtension.$$$reportNull$$$0(18);
        }
        if (element instanceof ES6ImportSpecifier) {
            return ((ES6ImportSpecifier)element).getDeclaredName();
        }
        return element instanceof PsiNamedElement ? ((PsiNamedElement)element).getName() : null;
    }

    @Nullable
    static String getEffectiveName(PsiElement element, PsiElement candidate) {
        if (element instanceof ES6ImportedBinding || element instanceof ES6ImportSpecifierAlias || element instanceof TypeScriptImportStatement) {
            return ((PsiNamedElement)element).getName();
        }
        if (element instanceof ES6ImportSpecifier) {
            return ((ES6ImportSpecifier)element).getDeclaredName();
        }
        JSPsiNamedElementBase jsElement = (JSPsiNamedElementBase)ObjectUtils.tryCast((Object)candidate, JSPsiNamedElementBase.class);
        return jsElement != null ? jsElement.getName() : null;
    }

    @NotNull
    public static Collection<PsiElement> getElementsByImport(@Nullable PsiElement element) {
        Collection<PsiElement> collection = ReactXmlExtension.getElementsByImport(element, true);
        if (collection == null) {
            ReactXmlExtension.$$$reportNull$$$0(19);
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiElement> getElementsByImport(@Nullable PsiElement element, boolean resolveCallExpression) {
        if (element == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                ReactXmlExtension.$$$reportNull$$$0(20);
            }
            return list;
        }
        Collection collection = JSStubBasedPsiTreeUtil.calculateMeaningfulElements(element).stream().flatMap(el -> {
            JSExpression initializer;
            if (resolveCallExpression && el instanceof JSCallExpression) {
                return ReactXmlExtension.resolveCallExpression((JSCallExpression)el).stream();
            }
            if (el instanceof JSVariable && (initializer = JSPsiImplUtils.getRightmostInitializer((JSInitializerOwner)((JSVariable)el))) instanceof JSFunction) {
                el = initializer;
            }
            return Stream.of(el);
        }).collect(Collectors.toList());
        if (collection == null) {
            ReactXmlExtension.$$$reportNull$$$0(21);
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiElement> resolveCallExpression(@NotNull JSCallExpression result2) {
        if (result2 == null) {
            ReactXmlExtension.$$$reportNull$$$0(22);
        }
        String componentName = ReactXmlExtension.resolveCallComponentName(result2);
        Collection<PsiElement> collection = ReactXmlExtension.resolveCallExpressionForName(result2, componentName);
        if (collection == null) {
            ReactXmlExtension.$$$reportNull$$$0(23);
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiElement> resolveCallExpressionForName(@NotNull JSCallExpression result2, String componentName) {
        PsiElement componentCandidate;
        PsiElement module;
        if (result2 == null) {
            ReactXmlExtension.$$$reportNull$$$0(24);
        }
        if (!StringUtil.isEmpty((String)componentName) && (module = ES6PsiUtil.findExternalModule((PsiElement)result2)) != null && (componentCandidate = JSStubBasedPsiTreeUtil.resolveLocally(componentName, module)) != null && ReactXmlExtension.isPossibleReactComponent(componentCandidate)) {
            List list = ContainerUtil.createMaybeSingletonList((Object)componentCandidate);
            if (list == null) {
                ReactXmlExtension.$$$reportNull$$$0(25);
            }
            return list;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            ReactXmlExtension.$$$reportNull$$$0(26);
        }
        return list;
    }

    @Nullable
    public static String resolveCallComponentName(@NotNull JSCallExpression result2) {
        Map strings;
        JSElementIndexingData data;
        if (result2 == null) {
            ReactXmlExtension.$$$reportNull$$$0(27);
        }
        if ((data = result2.getIndexingData()) != null && (strings = data.getUserStrings()) != null) {
            return (String)strings.get("wrapped.component.name");
        }
        return null;
    }

    public static boolean nonJsxTag(@Nullable XmlTag tag) {
        return !(tag instanceof JSXXmlLiteralExpressionImpl);
    }

    public static boolean hasQualifiedName(@NotNull XmlTag tag) {
        if (tag == null) {
            ReactXmlExtension.$$$reportNull$$$0(28);
        }
        String name = tag.getName();
        String localName = tag.getLocalName();
        return !localName.equals(name);
    }

    public static ThreeState isAcceptableClassComponent(@NotNull JSClass jsClass) {
        String[] texts;
        if (jsClass == null) {
            ReactXmlExtension.$$$reportNull$$$0(29);
        }
        if (jsClass.isInterface() || jsClass.getExtendsList() == null) {
            return ThreeState.NO;
        }
        for (String text : texts = jsClass.getExtendsList().getReferenceTexts()) {
            if (TypeScriptReactComponentUtil.REACT_COMPONENT_NAMES.contains(text)) {
                return ThreeState.YES;
            }
            for (String name : TypeScriptReactComponentUtil.REACT_COMPONENT_NAMES) {
                if (!text.endsWith("." + name)) continue;
                return ThreeState.YES;
            }
        }
        return ThreeState.NO;
    }

    @Nullable
    public XmlNSDescriptor getNSDescriptor(XmlTag element, String namespace, boolean strict) {
        XmlElementDescriptor elementDescriptor = element.getDescriptor();
        if (elementDescriptor instanceof ReactXmlElementDescriptor) {
            return elementDescriptor.getNSDescriptor();
        }
        return super.getNSDescriptor(element, namespace, strict);
    }

    public boolean isCollapsibleTag(XmlTag tag) {
        ASTNode end = XmlChildRole.START_TAG_END_FINDER.findChild(tag.getNode());
        return end != null && TreeUtil.findSibling((ASTNode)end, (IElementType)JSTokenTypes.XML_JS_SCRIPT) == null;
    }

    public boolean isRequiredAttributeImplicitlyPresent(XmlTag tag, String attrName) {
        String tagName = tag.getName();
        if (!ReactXmlExtension.isComponentName(tagName)) {
            return false;
        }
        boolean children = CHILDREN.equals(attrName);
        boolean passedAttributes = false;
        for (PsiElement child : tag.getChildren()) {
            if ((!children || passedAttributes) && child instanceof JSEmbeddedContent) {
                return true;
            }
            if (children && (child instanceof XmlText || child instanceof XmlTag)) {
                return true;
            }
            IElementType type = child.getNode().getElementType();
            if (!children && (type == XmlTokenType.XML_EMPTY_ELEMENT_END || type == XmlTokenType.XML_TAG_END)) break;
            passedAttributes |= type == XmlTokenType.XML_TAG_END;
        }
        Processor processor = base -> {
            if (StringUtil.equals((CharSequence)base.getQualifiedName(), (CharSequence)(tagName + "." + DEFAULT_PROPS)) || StringUtil.equals((CharSequence)base.getQualifiedName(), (CharSequence)(tagName + "." + GET_DEFAULT_PROPS))) {
                JSPsiElementBase root;
                Object object = root = base instanceof JSDefinitionExpression ? ((JSDefinitionExpression)base).getInitializerOrStub() : base;
                if (root == null) {
                    return true;
                }
                Collection<JSProperty> properties = JSStubBasedPsiTreeUtil.findDescendants((PsiElement)root, JSStubElementTypes.PROPERTY);
                for (JSProperty property : properties) {
                    if (!StringUtil.equals((CharSequence)attrName, (CharSequence)property.getName())) continue;
                    return false;
                }
            }
            return true;
        };
        return !JSClassResolver.processElementsByNameIncludingImplicit(DEFAULT_PROPS, JSResolveUtil.getResolveScope((PsiElement)tag), false, (Processor<? super JSPsiElementBase>)processor) || !JSClassResolver.processElementsByNameIncludingImplicit(GET_DEFAULT_PROPS, JSResolveUtil.getResolveScope((PsiElement)tag), false, (Processor<? super JSPsiElementBase>)processor);
    }

    public boolean shouldBeInserted(XmlAttributeDescriptor descriptor2) {
        if (CHILDREN.equals(descriptor2.getName())) {
            return false;
        }
        return super.shouldBeInserted(descriptor2);
    }

    @NotNull
    public XmlExtension.AttributeValuePresentation getAttributeValuePresentation(@Nullable XmlAttributeDescriptor descriptor2, @NotNull String defaultAttributeQuote) {
        if (defaultAttributeQuote == null) {
            ReactXmlExtension.$$$reportNull$$$0(30);
        }
        if (descriptor2 != null) {
            JSCodeStyleSettings.JSXAttributeValuePresentation presentation = ReactXmlExtension.getAttributeValue(descriptor2);
            if (presentation == JSCodeStyleSettings.JSXAttributeValuePresentation.BRACES) {
                XmlExtension.AttributeValuePresentation attributeValuePresentation = ReactXmlExtension.createValueWithBraces();
                if (attributeValuePresentation == null) {
                    ReactXmlExtension.$$$reportNull$$$0(31);
                }
                return attributeValuePresentation;
            }
            if (presentation == JSCodeStyleSettings.JSXAttributeValuePresentation.NONE) {
                XmlExtension.AttributeValuePresentation attributeValuePresentation = ReactXmlExtension.createEmptyValue();
                if (attributeValuePresentation == null) {
                    ReactXmlExtension.$$$reportNull$$$0(32);
                }
                return attributeValuePresentation;
            }
        }
        XmlExtension.AttributeValuePresentation attributeValuePresentation = super.getAttributeValuePresentation(descriptor2, defaultAttributeQuote);
        if (attributeValuePresentation == null) {
            ReactXmlExtension.$$$reportNull$$$0(33);
        }
        return attributeValuePresentation;
    }

    @NotNull
    private static JSCodeStyleSettings.JSXAttributeValuePresentation getTypeBasedJSXAttributeValuePresentation(@NotNull XmlAttributeDescriptor descriptor2) {
        JSType attributeType;
        if (descriptor2 == null) {
            ReactXmlExtension.$$$reportNull$$$0(34);
        }
        if ((attributeType = ReactXmlExtension.getType(descriptor2)) != null && attributeType.getSource().isTypeScript()) {
            attributeType = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(attributeType);
        }
        JSCodeStyleSettings.JSXAttributeValuePresentation jSXAttributeValuePresentation = !JSTypeUtils.isStringOrStringUnion(attributeType, false) ? JSCodeStyleSettings.JSXAttributeValuePresentation.BRACES : JSCodeStyleSettings.JSXAttributeValuePresentation.QUOTES;
        if (jSXAttributeValuePresentation == null) {
            ReactXmlExtension.$$$reportNull$$$0(35);
        }
        return jSXAttributeValuePresentation;
    }

    @NotNull
    public static JSCodeStyleSettings.JSXAttributeValuePresentation getAttributeValue(@Nullable XmlAttributeDescriptor descriptor2) {
        if (descriptor2 instanceof ReactAttributeDescriptor) {
            PsiElement declaration = descriptor2.getDeclaration();
            if (declaration == null) {
                JSCodeStyleSettings.JSXAttributeValuePresentation jSXAttributeValuePresentation = JSCodeStyleSettings.DEFAULT_JSX_VALUE;
                if (jSXAttributeValuePresentation == null) {
                    ReactXmlExtension.$$$reportNull$$$0(36);
                }
                return jSXAttributeValuePresentation;
            }
            JSCodeStyleSettings.JSXAttributeValuePresentation value = JSCodeStyleSettings.getJSXAttributeValue(declaration);
            if (value == JSCodeStyleSettings.JSXAttributeValuePresentation.TYPE_BASED) {
                JSCodeStyleSettings.JSXAttributeValuePresentation jSXAttributeValuePresentation = ReactXmlExtension.getTypeBasedJSXAttributeValuePresentation(descriptor2);
                if (jSXAttributeValuePresentation == null) {
                    ReactXmlExtension.$$$reportNull$$$0(37);
                }
                return jSXAttributeValuePresentation;
            }
            JSCodeStyleSettings.JSXAttributeValuePresentation jSXAttributeValuePresentation = value;
            if (jSXAttributeValuePresentation == null) {
                ReactXmlExtension.$$$reportNull$$$0(38);
            }
            return jSXAttributeValuePresentation;
        }
        JSCodeStyleSettings.JSXAttributeValuePresentation jSXAttributeValuePresentation = JSCodeStyleSettings.JSXAttributeValuePresentation.QUOTES;
        if (jSXAttributeValuePresentation == null) {
            ReactXmlExtension.$$$reportNull$$$0(39);
        }
        return jSXAttributeValuePresentation;
    }

    @NotNull
    private static XmlExtension.AttributeValuePresentation createValueWithBraces() {
        XmlExtension.AttributeValuePresentation attributeValuePresentation = BRACES_PRESENTATION;
        if (attributeValuePresentation == null) {
            ReactXmlExtension.$$$reportNull$$$0(40);
        }
        return attributeValuePresentation;
    }

    @NotNull
    private static XmlExtension.AttributeValuePresentation createEmptyValue() {
        XmlExtension.AttributeValuePresentation attributeValuePresentation = EMPTY_VALUE_PRESENTATION;
        if (attributeValuePresentation == null) {
            ReactXmlExtension.$$$reportNull$$$0(41);
        }
        return attributeValuePresentation;
    }

    @Nullable
    public static JSType getType(@Nullable XmlAttributeDescriptor descriptor2) {
        if (!(descriptor2 instanceof ReactAttributeDescriptor)) {
            return null;
        }
        return ((ReactAttributeDescriptor)descriptor2).getValueType();
    }

    @Nullable
    public static JSType getPropType(@Nullable PsiElement declaration) {
        String typeString;
        if (declaration instanceof TypeScriptField) {
            TypeScriptField signature = (TypeScriptField)declaration;
            return signature.getType();
        }
        if (declaration instanceof JSLocalImplicitElementImpl) {
            return ((JSLocalImplicitElementImpl)declaration).getJSType();
        }
        if (declaration instanceof JSImplicitElement && !StringUtil.isEmpty((String)(typeString = ((JSImplicitElement)declaration).getTypeString()))) {
            return JSTypeUtils.createType(typeString, JSTypeSourceFactory.createTypeSource(declaration, false));
        }
        return null;
    }

    public static boolean isFunctionComponentBySignature(@NotNull JSFunction element) {
        if (element == null) {
            ReactXmlExtension.$$$reportNull$$$0(42);
        }
        if (element.isConstructor()) {
            return false;
        }
        JSType returnedType = element.getReturnType();
        if (returnedType instanceof JSPrimitiveType || returnedType instanceof JSVoidType) {
            return false;
        }
        JSParameterListElement[] parameters = element.getParameters();
        return parameters.length <= 2;
    }

    @NotNull
    private static Collection<PsiElement> resolveComponentNameForCandidates(@NotNull XmlTag tag, @NotNull Collection<? extends PsiElement> candidates) {
        if (tag == null) {
            ReactXmlExtension.$$$reportNull$$$0(43);
        }
        if (candidates == null) {
            ReactXmlExtension.$$$reportNull$$$0(44);
        }
        if (candidates.isEmpty()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                ReactXmlExtension.$$$reportNull$$$0(45);
            }
            return list;
        }
        HashSet visitedOverloadImplementations = ContainerUtil.newHashSet();
        ArrayList elements = ContainerUtil.newArrayList();
        for (PsiElement psiElement : candidates) {
            for (PsiElement localOrImported : ReactXmlExtension.getElementsByImport(psiElement)) {
                if (!ReactXmlExtension.isPossibleReactComponent(localOrImported)) continue;
                if (localOrImported instanceof TypeScriptFunction) {
                    if (((TypeScriptFunction)localOrImported).isOverloadDeclaration()) {
                        TypeScriptFunction implementation = TypeScriptPsiUtil.getOverloadImplementation((TypeScriptFunction)localOrImported);
                        Object object = localOrImported = implementation == null ? localOrImported : implementation;
                        if (implementation != null && !visitedOverloadImplementations.add(implementation)) {
                            continue;
                        }
                    } else if (((TypeScriptFunction)localOrImported).isOverloadImplementation() && !visitedOverloadImplementations.add(localOrImported)) continue;
                }
                elements.add(ReactXmlExtension.getElementForResolve(psiElement, localOrImported, tag));
            }
        }
        ArrayList arrayList = elements;
        if (arrayList == null) {
            ReactXmlExtension.$$$reportNull$$$0(46);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 45: 
            case 46: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 45: 
            case 46: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullTagName";
                break;
            }
            case 5: 
            case 18: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/react/ReactXmlExtension";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 22: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultAttributeQuote";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/react/ReactXmlExtension";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementForResolve";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsByImport";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveCallExpression";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveCallExpressionForName";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeValuePresentation";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeBasedJSXAttributeValuePresentation";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeValue";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "createValueWithBraces";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyValue";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveComponentNameForCandidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveQualifiedComponent";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFirstQualifierReference";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierReference";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveGlobalComponentElements";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getElementForResolve";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 45: 
            case 46: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resolveComponentForIndexes";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getResolveScopeForIndexProcessing";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getInitializer";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isPossibleReactComponent";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addTagNameVariants";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getLocalName";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "resolveCallExpression";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "resolveCallExpressionForName";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "resolveCallComponentName";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "hasQualifiedName";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableClassComponent";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeValuePresentation";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getTypeBasedJSXAttributeValuePresentation";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isFunctionComponentBySignature";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "resolveComponentNameForCandidates";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 45: 
            case 46: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ReactTagNameReference
    extends TagNameReference {
        ReactTagNameReference(ASTNode nameElement, boolean startTagFlag) {
            super(nameElement, startTagFlag);
        }

        protected int getPrefixIndex(@NotNull String name) {
            if (name == null) {
                ReactTagNameReference.$$$reportNull$$$0(0);
            }
            return name.lastIndexOf(".");
        }

        protected String prependNamespacePrefix(String newElementName, String namespacePrefix) {
            newElementName = (!namespacePrefix.isEmpty() ? namespacePrefix + "." : namespacePrefix) + newElementName;
            return newElementName;
        }

        public PsiElement resolve() {
            XmlTag tag = this.getTagElement();
            if (ReactXmlExtension.nonJsxTag(tag)) {
                return super.resolve();
            }
            PsiElement element = (PsiElement)ResolveCache.getInstance((Project)tag.getProject()).resolveWithCaching((PsiReference)this, RESOLVER, false, false);
            if (element instanceof ES6ImportedBinding) {
                JSElement topLevelContainer = ES6PsiUtil.getExportScope(element);
                JSElement currentContainer = ES6PsiUtil.getExportScope((PsiElement)tag);
                if (topLevelContainer != null && topLevelContainer.isEquivalentTo((PsiElement)currentContainer)) {
                    return element;
                }
            }
            return element != null ? element : super.resolve();
        }

        @Nullable
        public XmlTag getTagElement() {
            return super.getTagElement();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/frameworks/react/ReactXmlExtension$ReactTagNameReference", "getPrefixIndex"));
        }
    }
}

