/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.cvsUpdate;

import com.intellij.cvsSupport2.application.CvsEntriesManager;
import com.intellij.cvsSupport2.cvsoperations.common.PostCvsActivity;
import com.intellij.cvsSupport2.cvsoperations.common.ReceivedFileProcessor;
import com.intellij.cvsSupport2.cvsoperations.common.UpdatedFilesManager;
import com.intellij.cvsSupport2.cvsoperations.cvsUpdate.MergedWithConflictProjectOrModuleFile;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectOpenProcessor;
import java.io.File;
import java.io.IOException;

public class UpdateReceivedFileProcessor
implements ReceivedFileProcessor {
    private final UpdatedFilesManager myUpdatedFilesInfo;
    private final PostCvsActivity myPostCvsActivity;

    public UpdateReceivedFileProcessor(UpdatedFilesManager updatedFilesInfo, PostCvsActivity postCvsActivity) {
        this.myUpdatedFilesInfo = updatedFilesInfo;
        this.myPostCvsActivity = postCvsActivity;
    }

    @Override
    public boolean shouldProcess(VirtualFile virtualFile, File targetFile) throws IOException {
        if (UpdateReceivedFileProcessor.isProjectOrModuleFile(virtualFile) && this.myUpdatedFilesInfo.isMerged(targetFile)) {
            this.myUpdatedFilesInfo.couldNotUpdateFile(targetFile);
            File backupCopy = UpdateReceivedFileProcessor.getCopyFor(virtualFile, targetFile);
            this.myPostCvsActivity.registerCorruptedProjectOrModuleFile(new MergedWithConflictProjectOrModuleFile(virtualFile));
            FileUtil.copy((File)backupCopy, (File)targetFile);
            return false;
        }
        return true;
    }

    private static File getCopyFor(VirtualFile virtualFile, File targetFile) {
        return new File(targetFile.getParentFile(), ".#" + targetFile.getName() + "." + CvsEntriesManager.getInstance().getEntryFor(virtualFile).getRevision());
    }

    private static boolean isProjectOrModuleFile(VirtualFile virtualFile) {
        if (virtualFile == null) {
            return false;
        }
        ProjectOpenProcessor importProvider = ProjectOpenProcessor.getImportProvider((VirtualFile)virtualFile);
        if (importProvider != null && importProvider.isProjectFile(virtualFile)) {
            return true;
        }
        FileType fileType = virtualFile.getFileType();
        return fileType == StdFileTypes.IDEA_PROJECT || fileType == StdFileTypes.IDEA_MODULE || fileType == StdFileTypes.IDEA_WORKSPACE;
    }
}

