/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.interpreters;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.ext.CaseCollector;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.run.remote.PhpInvalidSdkTypeException;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpTextFieldWithSdkBasedBrowse
extends TextFieldWithBrowseButton {
    private static final Logger LOG = Logger.getInstance(PhpTextFieldWithSdkBasedBrowse.class);

    public void init(@Nullable Project project, @Nullable PhpSdkAdditionalData sdkData, @NotNull String title, boolean withFiles, boolean withFolders) {
        if (title == null) {
            PhpTextFieldWithSdkBasedBrowse.$$$reportNull$$$0(0);
        }
        boolean canBrowse = !(sdkData instanceof RemoteSdkAdditionalData) || CaseCollector.useRemoteCredentials((RemoteSdkAdditionalData)((RemoteSdkAdditionalData)sdkData));
        this.getButton().setVisible(canBrowse);
        if (sdkData instanceof RemoteSdkAdditionalData) {
            if (CaseCollector.useRemoteCredentials((RemoteSdkAdditionalData)((RemoteSdkAdditionalData)sdkData))) {
                try {
                    PhpRemoteInterpreterManager manager = PhpRemoteInterpreterManager.getInstance();
                    if (manager != null) {
                        this.addActionListener(manager.createRemoteBrowserAction(project, sdkData, title, this.getTextField(), !withFiles && withFolders));
                    }
                }
                catch (PhpInvalidSdkTypeException e) {
                    LOG.warn("Can not create browse action for sdk");
                }
            }
        } else {
            this.addBrowseFolderListener(null, null, project, new FileChooserDescriptor(withFiles, withFolders, false, false, false, false));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/jetbrains/php/config/interpreters/PhpTextFieldWithSdkBasedBrowse", "init"));
    }
}

