/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang;

import com.intellij.codeInsight.highlighting.HighlightErrorFilter;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlElement;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.smarty.SmartyLanguage;
import org.jetbrains.annotations.NotNull;

public class ErrorFilter
extends HighlightErrorFilter {
    public boolean shouldHighlightErrorElement(@NotNull PsiErrorElement element) {
        Language language;
        if (element == null) {
            ErrorFilter.$$$reportNull$$$0(0);
        }
        if ((language = PsiUtilCore.getTemplateLanguageFile((PsiElement)element.getContainingFile()).getLanguage()) != PhpLanguage.INSTANCE && language != SmartyLanguage.INSTANCE) {
            return true;
        }
        if (element.getParent() instanceof XmlElement) {
            return false;
        }
        if (element.getParent() instanceof CssElement) {
            return false;
        }
        return ErrorFilter.complexCheckForErrorElement(element);
    }

    private static boolean complexCheckForErrorElement(PsiErrorElement element) {
        boolean nextIsOuterLanguageElement;
        if (element.getParent().getLanguage() == PhpLanguage.INSTANCE) {
            return true;
        }
        PsiElement nextSibling = PsiTreeUtil.nextLeaf((PsiElement)element);
        while (nextSibling instanceof PsiWhiteSpace) {
            nextSibling = nextSibling.getNextSibling();
        }
        PsiElement psiElement = nextSibling == null ? null : PsiTreeUtil.findCommonParent((PsiElement)nextSibling, (PsiElement)element);
        boolean bl = nextIsOuterLanguageElement = nextSibling instanceof OuterLanguageElement || nextSibling instanceof PhpPsiElement;
        return !nextIsOuterLanguageElement || psiElement == null || psiElement instanceof PsiFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/lang/ErrorFilter", "shouldHighlightErrorElement"));
    }
}

