/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.refactoring.PhpNamespaceBraceConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpNamespaceBracingIntention
extends PsiElementBaseIntentionAction {
    public static final String TEXT = PhpBundle.message("intention.namespace.bracing", new Object[0]);

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            PhpNamespaceBracingIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PhpNamespaceBracingIntention.$$$reportNull$$$0(1);
        }
        Document document = editor.getDocument();
        PhpNamespaceBraceConverter.braceAllInFile(project, document, element.getContainingFile());
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            PhpNamespaceBracingIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            PhpNamespaceBracingIntention.$$$reportNull$$$0(3);
        }
        if (PhpNamespaceBracingIntention.getNamespaceElement(element) != null) {
            this.setText(PhpBundle.message("intention.namespace.bracing", new Object[0]));
            return true;
        }
        return false;
    }

    @NotNull
    public String getFamilyName() {
        String string = TEXT;
        if (string == null) {
            PhpNamespaceBracingIntention.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    private static PhpNamespace getNamespaceElement(@NotNull PsiElement element) {
        PhpNamespace namespace;
        PsiElement parent;
        if (element == null) {
            PhpNamespaceBracingIntention.$$$reportNull$$$0(5);
        }
        if ((parent = element.getParent()) instanceof PhpNamespace && !(element instanceof GroupStatement) && !(namespace = (PhpNamespace)parent).isBraced()) {
            return namespace;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpNamespaceBracingIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpNamespaceBracingIntention";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNamespaceElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

