/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit.coverage;

import com.intellij.coverage.CoverageRunnerData;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.GenericProgramRunner;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.runners.RunContentBuilder;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.PathUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.commandLine.PhpCommandSettings;
import com.jetbrains.php.config.commandLine.PhpCommandSettingsBuilder;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.debug.PhpDebugExtension;
import com.jetbrains.php.debug.PhpDebugUtil;
import com.jetbrains.php.debug.xdebug.XdebugExtension;
import com.jetbrains.php.debug.zend.ZendDebuggerExtension;
import com.jetbrains.php.phpunit.coverage.PhpCoverageResultManager;
import com.jetbrains.php.run.PhpRunConfiguration;
import com.jetbrains.php.run.PhpRunConfigurationHolder;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpCoverageRunner
extends GenericProgramRunner {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.php.phpunit.coverage.PhpCoverageRunner");

    public RunnerSettings createConfigurationData(ConfigurationInfoProvider settingsProvider) {
        return new CoverageRunnerData();
    }

    protected RunContentDescriptor doExecute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (state == null) {
            PhpCoverageRunner.$$$reportNull$$$0(0);
        }
        if (env == null) {
            PhpCoverageRunner.$$$reportNull$$$0(1);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        RunProfile profile = env.getRunProfile();
        if (!(profile instanceof PhpRunConfigurationHolder)) {
            throw new ExecutionException(PhpBundle.message("coverage.is.not.supported.for.selected.run.profile", new Object[0]));
        }
        PhpRunConfigurationHolder runConfigurationHolder = (PhpRunConfigurationHolder)profile;
        PhpInterpreter interpreter = PhpProjectConfigurationFacade.getInstance(env.getProject()).getInterpreter();
        if (interpreter == null) {
            throw new ExecutionException(PhpCommandSettingsBuilder.INTERPRETER_NOT_FOUND_ERROR);
        }
        PhpDebugExtension debugExtension = PhpDebugUtil.getDebugExtensionByDebuggerId(StringUtil.notNullize((String)interpreter.getDebuggerId()));
        if (debugExtension instanceof XdebugExtension) {
            return this.doExecuteWithXdebug(env, runConfigurationHolder, interpreter);
        }
        if (debugExtension instanceof ZendDebuggerExtension) {
            return this.doExecuteWithZendDebugger(env, runConfigurationHolder, interpreter);
        }
        throw new ExecutionException(PhpBundle.message("debug.error.unknown.debugger.id", new Object[0]));
    }

    private RunContentDescriptor doExecuteWithXdebug(@NotNull ExecutionEnvironment env, @NotNull PhpRunConfigurationHolder runConfigurationHolder, @NotNull PhpInterpreter interpreter) throws ExecutionException {
        ExecutionResult executionResult;
        if (env == null) {
            PhpCoverageRunner.$$$reportNull$$$0(2);
        }
        if (runConfigurationHolder == null) {
            PhpCoverageRunner.$$$reportNull$$$0(3);
        }
        if (interpreter == null) {
            PhpCoverageRunner.$$$reportNull$$$0(4);
        }
        PhpRunConfiguration runConfiguration = runConfigurationHolder.getRunConfiguration();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Execute code coverage for '" + runConfiguration.getName() + "' with xdebug");
        }
        PhpCoverageResultManager resultManager = PhpCoverageResultManager.getCoverageResultManager(interpreter.getPhpSdkAdditionalData());
        CoverageEnabledConfiguration coverageEnabledConfiguration = CoverageEnabledConfiguration.getOrCreate(runConfiguration);
        String localCoverage = coverageEnabledConfiguration.getCoverageFilePath();
        String targetCoverage = StringUtil.isNotEmpty((String)localCoverage) ? resultManager.processCoverageFile(localCoverage) : null;
        RunProfileState state = this.createState(env, interpreter, runConfigurationHolder, this.createCoverageArguments(targetCoverage), localCoverage, targetCoverage);
        ExecutionResult executionResult2 = executionResult = state != null ? state.execute(env.getExecutor(), (ProgramRunner)this) : null;
        if (executionResult == null) {
            return null;
        }
        resultManager.attachToProcess(runConfiguration.getProject(), runConfiguration, executionResult.getProcessHandler(), env.getRunnerSettings());
        return new RunContentBuilder(executionResult, env).showRunContent(env.getContentToReuse());
    }

    protected void setAdditionalMapping(String localCoverage, String targetCoverage, PhpCommandSettings command) {
        if (StringUtil.isNotEmpty((String)localCoverage) && StringUtil.isNotEmpty((String)targetCoverage)) {
            command.setAdditionalMapping(new PathMappingSettings.PathMapping(PathUtil.getParentPath((String)localCoverage), PathUtil.getParentPath((String)targetCoverage)));
        }
    }

    protected RunContentDescriptor doExecuteWithZendDebugger(@NotNull ExecutionEnvironment env, @NotNull PhpRunConfigurationHolder runConfigurationHolder, @NotNull PhpInterpreter interpreter) throws ExecutionException {
        if (env == null) {
            PhpCoverageRunner.$$$reportNull$$$0(5);
        }
        if (runConfigurationHolder == null) {
            PhpCoverageRunner.$$$reportNull$$$0(6);
        }
        if (interpreter == null) {
            PhpCoverageRunner.$$$reportNull$$$0(7);
        }
        throw new ExecutionException(PhpBundle.message("debug.error.wrong.debugger.id", "Zend Debugger"));
    }

    @NotNull
    protected abstract List<String> createCoverageArguments(@Nullable String var1);

    protected abstract RunProfileState createState(@NotNull ExecutionEnvironment var1, @NotNull PhpInterpreter var2, PhpRunConfigurationHolder var3, List<String> var4, String var5, String var6) throws ExecutionException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfigurationHolder";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/phpunit/coverage/PhpCoverageRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doExecute";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doExecuteWithXdebug";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "doExecuteWithZendDebugger";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

