/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.surroundWith;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.surroundWith.PhpStatementSurrounder;

public class PhpForeachSurrounder
extends PhpStatementSurrounder<ForeachStatement> {
    @Override
    protected String getStatementTemplate(Project project, PsiElement[] elements) {
        return "foreach($a as $b){}";
    }

    @Override
    protected PsiElement getInsertInto(ForeachStatement statement) {
        return statement.getLastChild();
    }

    @Override
    protected TextRange getSurroundSelectionRange(ForeachStatement statement) {
        PsiElement arr = statement.getArray();
        assert (arr != null);
        Variable var = statement.getValue();
        assert (var != null);
        int offset = arr.getTextOffset();
        arr.delete();
        var.delete();
        return TextRange.from((int)offset, (int)0);
    }

    public String getTemplateDescription() {
        return "foreach";
    }
}

