/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Tag;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpSdkDependentConfiguration;
import com.jetbrains.php.testFramework.PhpInvalidTestFrameworkException;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfiguration;
import com.jetbrains.php.testFramework.PhpTestFrameworkSettings;
import com.jetbrains.php.testFramework.PhpTestFrameworkStateListener;
import com.jetbrains.php.testFramework.PhpTestFrameworkType;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpTestFrameworkBaseSettingsManager
implements PersistentStateComponent<State> {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.php.testFramework.PhpTestFrameworkBaseSettingsManager");
    protected final Project myProject;
    protected State myState = new State();
    private final List<PhpTestFrameworkStateListener> myStateListeners = new SmartList();

    public PhpTestFrameworkBaseSettingsManager() {
        this(null);
    }

    public PhpTestFrameworkBaseSettingsManager(@Nullable Project project) {
        this.myProject = project;
        if (this.myProject != null) {
            this.myProject.getMessageBus().connect((Disposable)this.myProject).subscribe(PhpInterpretersManagerImpl.PhpInterpreterConflictResolveListener.TOPIC, (Object)new PhpInterpretersManagerImpl.PhpInterpreterConflictResolveListener(){

                @Override
                public void resolveInterpreterConflict(@NotNull Map<String, String> oldInterpreterIdToNew) {
                    if (oldInterpreterIdToNew == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    for (PhpTestFrameworkSettings settings : PhpTestFrameworkBaseSettingsManager.this.myState.getSettings().values()) {
                        for (PhpTestFrameworkConfiguration configuration : settings.getConfigurations()) {
                            String oldInterpreterId;
                            if (!(configuration instanceof PhpSdkDependentConfiguration) || !oldInterpreterIdToNew.containsKey(oldInterpreterId = ((PhpSdkDependentConfiguration)((Object)configuration)).getInterpreterId())) continue;
                            ((PhpSdkDependentConfiguration)((Object)configuration)).setInterpreterId(oldInterpreterIdToNew.get(oldInterpreterId));
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldInterpreterIdToNew", "com/jetbrains/php/testFramework/PhpTestFrameworkBaseSettingsManager$1", "resolveInterpreterConflict"));
                }
            });
        }
    }

    @NotNull
    public Set<PhpTestFrameworkType> getFrameworks() {
        Set<String> tools = this.myState.getSettings().keySet();
        if (tools.isEmpty()) {
            Set<PhpTestFrameworkType> set = Collections.emptySet();
            if (set == null) {
                PhpTestFrameworkBaseSettingsManager.$$$reportNull$$$0(0);
            }
            return set;
        }
        HashSet<PhpTestFrameworkType> frameworkTypes = new HashSet<PhpTestFrameworkType>(tools.size());
        for (String tool : tools) {
            try {
                frameworkTypes.add(PhpTestFrameworkType.getTestFrameworkType(tool));
            }
            catch (RuntimeException e) {
                LOG.warn((Throwable)e);
            }
        }
        HashSet<PhpTestFrameworkType> hashSet = frameworkTypes;
        if (hashSet == null) {
            PhpTestFrameworkBaseSettingsManager.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    @NotNull
    public abstract List<PhpTestFrameworkConfiguration> getConfigurations(@NotNull PhpTestFrameworkType var1);

    public abstract void setConfigurations(@NotNull PhpTestFrameworkType var1, @NotNull List<PhpTestFrameworkConfiguration> var2);

    @Nullable
    protected PhpTestFrameworkConfiguration getConfigById(@NotNull PhpTestFrameworkType frameworkType, @NotNull String id) {
        if (frameworkType == null) {
            PhpTestFrameworkBaseSettingsManager.$$$reportNull$$$0(2);
        }
        if (id == null) {
            PhpTestFrameworkBaseSettingsManager.$$$reportNull$$$0(3);
        }
        for (PhpTestFrameworkConfiguration configuration : this.getConfigurations(frameworkType)) {
            if (!StringUtil.equals((CharSequence)configuration.getId(), (CharSequence)id)) continue;
            return configuration;
        }
        return null;
    }

    protected void onSettingsUpdate() {
        for (PhpTestFrameworkStateListener listener : this.myStateListeners) {
            listener.onSettingsUpdate();
        }
    }

    public void addListener(@NotNull Project project, @NotNull PhpTestFrameworkStateListener listener) {
        if (project == null) {
            PhpTestFrameworkBaseSettingsManager.$$$reportNull$$$0(4);
        }
        if (listener == null) {
            PhpTestFrameworkBaseSettingsManager.$$$reportNull$$$0(5);
        }
        ContainerUtil.add((Object)listener, this.myStateListeners, (Disposable)project);
    }

    @Nullable
    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            PhpTestFrameworkBaseSettingsManager.$$$reportNull$$$0(6);
        }
        this.myState = state;
        this.onSettingsUpdate();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/testFramework/PhpTestFrameworkBaseSettingsManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameworks";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/testFramework/PhpTestFrameworkBaseSettingsManager";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getConfigById";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class State {
        private Map<String, PhpTestFrameworkSettings> mySettings = new HashMap<String, PhpTestFrameworkSettings>();

        @Tag(value="test_tools")
        @MapAnnotation(surroundWithTag=false, keyAttributeName="tool_name", entryTagName="tool", surroundKeyWithTag=false, surroundValueWithTag=false)
        public Map<String, PhpTestFrameworkSettings> getSettings() {
            return this.mySettings;
        }

        public void setSettings(Map<String, PhpTestFrameworkSettings> settings) {
            for (Map.Entry<String, PhpTestFrameworkSettings> entry : settings.entrySet()) {
                try {
                    PhpTestFrameworkType frameworkType = PhpTestFrameworkType.getTestFrameworkType(entry.getKey());
                    for (PhpTestFrameworkConfiguration config : entry.getValue().getConfigurations()) {
                        config.setFrameworkType(frameworkType);
                    }
                }
                catch (PhpInvalidTestFrameworkException e) {
                    LOG.warn((Throwable)e);
                }
            }
            this.mySettings = settings;
        }

        @NotNull
        public List<PhpTestFrameworkConfiguration> getConfigurationsByKey(@NotNull String key) {
            if (key == null) {
                State.$$$reportNull$$$0(0);
            }
            List<PhpTestFrameworkConfiguration> list = this.mySettings.containsKey(key) ? this.mySettings.get(key).getConfigurations() : Collections.emptyList();
            if (list == null) {
                State.$$$reportNull$$$0(1);
            }
            return list;
        }

        public void setConfigurationsByKey(@NotNull String key, @NotNull List<PhpTestFrameworkConfiguration> configurations) {
            if (key == null) {
                State.$$$reportNull$$$0(2);
            }
            if (configurations == null) {
                State.$$$reportNull$$$0(3);
            }
            if (!this.mySettings.containsKey(key)) {
                this.mySettings.put(key, new PhpTestFrameworkSettings());
            }
            this.mySettings.get(key).setConfigurations(configurations);
        }

        public void removeConfigurations(@NotNull String key) {
            if (key == null) {
                State.$$$reportNull$$$0(4);
            }
            this.mySettings.remove(key);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/testFramework/PhpTestFrameworkBaseSettingsManager$State";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurations";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/testFramework/PhpTestFrameworkBaseSettingsManager$State";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConfigurationsByKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getConfigurationsByKey";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setConfigurationsByKey";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "removeConfigurations";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

