/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.blade.lang;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.blade.parser.BladeDirectiveStack;
import com.jetbrains.php.blade.psi.BladeFileImpl;
import com.jetbrains.php.blade.psi.BladePsiDirective;
import com.jetbrains.php.blade.psi.BladeTokenTypes;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BladeFoldingBuilder
implements FoldingBuilder,
DumbAware {
    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull ASTNode node, @NotNull Document document) {
        PsiElement element;
        if (node == null) {
            BladeFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (document == null) {
            BladeFoldingBuilder.$$$reportNull$$$0(1);
        }
        if ((element = node.getPsi()) instanceof BladeFileImpl) {
            BladeFileImpl file = (BladeFileImpl)element;
            final ArrayList<FoldingDescriptor> descriptors = new ArrayList<FoldingDescriptor>();
            BladePsiDirective[] directives = file.getDirectives();
            BladeDirectiveStack stack = new BladeDirectiveStack(){

                @Override
                protected void reportMissingOpeningProblem(BladePsiDirective directive) {
                }

                @Override
                protected void reportMissingClosingProblem(BladePsiDirective directive) {
                }

                @Override
                protected void directiveClosed(@NotNull List<BladePsiDirective> directives) {
                    if (directives == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    int start = -1;
                    for (BladePsiDirective directive : directives) {
                        int endOffset;
                        if (start != -1 && (endOffset = directive.getTextRange().getStartOffset()) > start) {
                            TextRange range = new TextRange(start, endOffset);
                            descriptors.add(new FoldingDescriptor(element, range));
                        }
                        start = directive.getTextRange().getEndOffset();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directives", "com/jetbrains/php/blade/lang/BladeFoldingBuilder$1", "directiveClosed"));
                }
            };
            for (BladePsiDirective directive : directives) {
                stack.pushDirective(directive);
            }
            int commentPrefixLength = "{{--".length();
            int commentPrefixAndSuffixLength = commentPrefixLength + "--}}".length();
            for (PsiElement child : file.getChildren()) {
                TextRange range;
                if (child.getNode().getElementType() != BladeTokenTypes.COMMENT || (range = child.getTextRange()).getLength() <= commentPrefixAndSuffixLength || !child.getText().endsWith("--}}")) continue;
                descriptors.add(new FoldingDescriptor(child, range.shiftRight(commentPrefixLength).grown(-1 * commentPrefixAndSuffixLength)));
            }
            FoldingDescriptor[] foldingDescriptorArray = descriptors.toArray(FoldingDescriptor.EMPTY);
            if (foldingDescriptorArray == null) {
                BladeFoldingBuilder.$$$reportNull$$$0(2);
            }
            return foldingDescriptorArray;
        }
        if (FoldingDescriptor.EMPTY == null) {
            BladeFoldingBuilder.$$$reportNull$$$0(3);
        }
        return FoldingDescriptor.EMPTY;
    }

    @Nullable
    public String getPlaceholderText(@NotNull ASTNode node) {
        if (node == null) {
            BladeFoldingBuilder.$$$reportNull$$$0(4);
        }
        return "...";
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            BladeFoldingBuilder.$$$reportNull$$$0(5);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/blade/lang/BladeFoldingBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/blade/lang/BladeFoldingBuilder";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFoldRegions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildFoldRegions";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholderText";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isCollapsedByDefault";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

