/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.refactoring.extractMethod;

import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.refactoring.extractMethod.ExtractedFunctionSignatureGenerator;
import com.intellij.lang.javascript.refactoring.extractMethod.JSExtractFunctionHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTagChild;
import java.util.ArrayList;
import java.util.List;
import org.coffeescript.refactoring.extractMethod.CoffeeScriptExtractMethodGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoffeeScriptExtractMethodHandler
extends JSExtractFunctionHandler {
    private static final Class[] classTypes = new Class[]{JSObjectLiteralExpression.class, JSFile.class, JSBlockStatement.class, XmlTagChild.class, TypeScriptModule.class};

    protected PsiElement findStatement(PsiElement elementAt, int start, int end) {
        PsiElement element;
        PsiElement result = element = super.findStatement(elementAt, start, end);
        while (element != null && !(element instanceof JSBlockStatement) && element.getTextOffset() >= start && element.getTextOffset() + element.getTextLength() <= end) {
            result = element;
            element = PsiTreeUtil.getParentOfType((PsiElement)element, JSStatement.class);
        }
        return result;
    }

    public List<JSExtractFunctionHandler.IntroductionScope> findBases(PsiElement at) {
        ArrayList<JSExtractFunctionHandler.IntroductionScope> scopes = new ArrayList<JSExtractFunctionHandler.IntroductionScope>();
        JSExtractFunctionHandler.IntroductionScope currentScope = this.findBase(at, true);
        while (currentScope != null && !(currentScope.getParent() instanceof JSFile) && !(currentScope.getParent() instanceof XmlTagChild)) {
            if (!(currentScope.getParent() instanceof JSObjectLiteralExpression)) {
                scopes.add(currentScope);
            }
            currentScope = this.findBase(currentScope.getParent(), true);
        }
        if (currentScope != null) {
            scopes.add(currentScope);
        }
        return scopes;
    }

    protected boolean needInsertAfter(@NotNull PsiElement parent, @Nullable PsiElement functionAnchor) {
        if (parent == null) {
            CoffeeScriptExtractMethodHandler.$$$reportNull$$$0(0);
        }
        return false;
    }

    @NotNull
    protected ExtractedFunctionSignatureGenerator getSignatureGenerator() {
        CoffeeScriptExtractMethodGenerator coffeeScriptExtractMethodGenerator = new CoffeeScriptExtractMethodGenerator();
        if (coffeeScriptExtractMethodGenerator == null) {
            CoffeeScriptExtractMethodHandler.$$$reportNull$$$0(1);
        }
        return coffeeScriptExtractMethodGenerator;
    }

    protected String addBodyToSignature(String signature, String body) {
        return signature + "\n  " + body;
    }

    protected String getVariableDeclarationPrefix(@Nullable JSVariable variable, @Nullable DialectOptionHolder dialect) {
        return "";
    }

    protected String getReturnStatementPrefix() {
        return "";
    }

    protected int getExtractFragmentStartOffset(Editor editor) {
        int result;
        String text = editor.getDocument().getText();
        for (result = super.getExtractFragmentStartOffset(editor); result < text.length() && StringUtil.isWhiteSpace((char)text.charAt(result)); ++result) {
        }
        return result;
    }

    protected int getExtractFragmentEndOffset(Editor editor) {
        int result;
        String text = editor.getDocument().getText();
        for (result = super.getExtractFragmentEndOffset(editor); result < text.length() && result > 0 && StringUtil.isWhiteSpace((char)text.charAt(result - 1)) && StringUtil.isWhiteSpace((char)text.charAt(result)); --result) {
        }
        return result;
    }

    protected String getStatementTerminator(JSExtractFunctionHandler.ContextInfo contextInfo) {
        return "";
    }

    @Nullable
    protected JSExtractFunctionHandler.IntroductionScope createPairWithPresentation(PsiElement parent) {
        if (parent instanceof JSBlockStatement && parent.getParent() instanceof JSClass) {
            String presentation = "class " + ((JSClass)parent.getParent()).getName();
            return new JSExtractFunctionHandler.IntroductionScope(parent, presentation);
        }
        return super.createPairWithPresentation(parent);
    }

    protected boolean acceptBlockStatementAsScope(JSBlockStatement blockStatement) {
        return blockStatement.getParent() instanceof JSClass;
    }

    protected Class[] getScopeTypes() {
        return classTypes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/coffeescript/refactoring/extractMethod/CoffeeScriptExtractMethodHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/coffeescript/refactoring/extractMethod/CoffeeScriptExtractMethodHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignatureGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "needInsertAfter";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

