/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.mocha.execution;

import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.ide.BrowserUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import com.intellij.webcore.ui.PathShortener;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.mocha.MochaUtil;
import com.jetbrains.nodejs.mocha.execution.MochaRunConfiguration;
import com.jetbrains.nodejs.mocha.execution.MochaRunSettings;
import com.jetbrains.nodejs.mocha.execution.MochaTestKind;
import com.jetbrains.nodejs.mocha.execution.MochaTestKindView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MochaRunConfigurationEditor
extends SettingsEditor<MochaRunConfiguration> {
    private final Project myProject;
    private final JPanel myComponent;
    private final NodeJsInterpreterField myNodeInterpreterField;
    private final RawCommandLineEditor myNodeOptions;
    private final TextFieldWithBrowseButton myWorkingDirTextFieldWithBrowseButton;
    private final EnvironmentVariablesTextFieldWithBrowseButton myEnvironmentVariablesTextFieldWithBrowseButton;
    private final NodePackageField myMochaPackageField;
    private final TextFieldWithHistory myUiComponent;
    private final RawCommandLineEditor myExtraMochaOptions;
    private final Map<MochaTestKind, JRadioButton> myRadioButtonMap;
    private final Map<MochaTestKind, MochaTestKindView> myTestKindViewMap;
    private final JPanel mySelectedTestKindPanel;
    private final int myLongestLabelWidth;

    public MochaRunConfigurationEditor(@NotNull Project project) {
        if (project == null) {
            MochaRunConfigurationEditor.$$$reportNull$$$0(0);
        }
        this.myRadioButtonMap = ContainerUtil.newHashMap();
        this.myTestKindViewMap = ContainerUtil.newHashMap();
        this.myProject = project;
        this.myNodeInterpreterField = new NodeJsInterpreterField(project, false);
        this.myNodeOptions = new RawCommandLineEditor();
        this.myWorkingDirTextFieldWithBrowseButton = MochaRunConfigurationEditor.createWorkingDirTextField(project);
        this.myEnvironmentVariablesTextFieldWithBrowseButton = new EnvironmentVariablesTextFieldWithBrowseButton();
        this.myMochaPackageField = new NodePackageField(this.myNodeInterpreterField, MochaUtil.PACKAGE_DESCRIPTOR, null);
        this.myUiComponent = MochaRunConfigurationEditor.createUiComponent();
        ComponentWithBrowseButton<TextFieldWithHistory> uiComponentWithInfoButton = this.createUiComponentWithInfoButton();
        this.myExtraMochaOptions = MochaRunConfigurationEditor.createExtraOptionsEditor();
        JPanel testKindPanel = this.createTestKindRadioButtonPanel();
        this.mySelectedTestKindPanel = new JPanel(new BorderLayout());
        this.myLongestLabelWidth = new JLabel((String)"Environment variables:").getPreferredSize().width;
        this.myComponent = new FormBuilder().setAlignLabelOnRight(false).addLabeledComponent("Node &interpreter:", (JComponent)this.myNodeInterpreterField).addLabeledComponent("Node &options:", (JComponent)this.myNodeOptions).addLabeledComponent("&Working directory:", (JComponent)this.myWorkingDirTextFieldWithBrowseButton).addLabeledComponent("&Environment variables:", (JComponent)this.myEnvironmentVariablesTextFieldWithBrowseButton).addLabeledComponent("&Mocha package:", (JComponent)this.myMochaPackageField).addLabeledComponent("&User interface:", (JComponent)SwingHelper.wrapWithoutStretch(uiComponentWithInfoButton)).addLabeledComponent("E&xtra Mocha options:", (JComponent)this.myExtraMochaOptions).addSeparator(8).addComponent((JComponent)testKindPanel).addComponent((JComponent)this.mySelectedTestKindPanel).addComponentFillVertically((JComponent)new JPanel(), 0).getPanel();
    }

    @NotNull
    private static RawCommandLineEditor createExtraOptionsEditor() {
        RawCommandLineEditor editor = new RawCommandLineEditor();
        JTextField field = editor.getTextField();
        if (field instanceof ExpandableTextField) {
            field.putClientProperty("monospaced", false);
        }
        if (field instanceof ComponentWithEmptyText) {
            ((ComponentWithEmptyText)field).getEmptyText().setText("CLI options, e.g. --watch");
        }
        RawCommandLineEditor rawCommandLineEditor = editor;
        if (rawCommandLineEditor == null) {
            MochaRunConfigurationEditor.$$$reportNull$$$0(1);
        }
        return rawCommandLineEditor;
    }

    @NotNull
    private JPanel createTestKindRadioButtonPanel() {
        JPanel testKindPanel = new JPanel(new FlowLayout(1, JBUI.scale((int)30), 0));
        testKindPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)10));
        ButtonGroup buttonGroup = new ButtonGroup();
        for (final MochaTestKind testKind : MochaTestKind.values()) {
            JRadioButton radioButton = new JRadioButton(UIUtil.removeMnemonic((String)testKind.getName()));
            int index = UIUtil.getDisplayMnemonicIndex((String)testKind.getName());
            if (index != -1) {
                radioButton.setMnemonic(testKind.getName().charAt(index + 1));
                radioButton.setDisplayedMnemonicIndex(index);
            }
            radioButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MochaRunConfigurationEditor.this.setTestKind(testKind);
                }
            });
            this.myRadioButtonMap.put(testKind, radioButton);
            testKindPanel.add(radioButton);
            buttonGroup.add(radioButton);
        }
        JPanel jPanel = testKindPanel;
        if (jPanel == null) {
            MochaRunConfigurationEditor.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    @Nullable
    private MochaTestKind getTestKind() {
        for (Map.Entry<MochaTestKind, JRadioButton> entry : this.myRadioButtonMap.entrySet()) {
            if (!entry.getValue().isSelected()) continue;
            return entry.getKey();
        }
        return null;
    }

    private void setTestKind(@NotNull MochaTestKind testKind) {
        MochaTestKind selectedTestKind;
        if (testKind == null) {
            MochaRunConfigurationEditor.$$$reportNull$$$0(3);
        }
        if ((selectedTestKind = this.getTestKind()) != testKind) {
            JRadioButton radioButton = this.myRadioButtonMap.get((Object)testKind);
            radioButton.setSelected(true);
        }
        MochaTestKindView view = this.getTestKindView(testKind);
        MochaRunConfigurationEditor.setCenterBorderLayoutComponent(this.mySelectedTestKindPanel, view.getComponent());
    }

    private static void setCenterBorderLayoutComponent(@NotNull JPanel panel, @NotNull Component child) {
        Component prevChild;
        if (panel == null) {
            MochaRunConfigurationEditor.$$$reportNull$$$0(4);
        }
        if (child == null) {
            MochaRunConfigurationEditor.$$$reportNull$$$0(5);
        }
        if ((prevChild = ((BorderLayout)panel.getLayout()).getLayoutComponent("Center")) != null) {
            panel.remove(prevChild);
        }
        panel.add(child, "Center");
        panel.revalidate();
        panel.repaint();
    }

    @NotNull
    private MochaTestKindView getTestKindView(@NotNull MochaTestKind testKind) {
        MochaTestKindView view;
        if (testKind == null) {
            MochaRunConfigurationEditor.$$$reportNull$$$0(6);
        }
        if ((view = this.myTestKindViewMap.get((Object)testKind)) == null) {
            view = testKind.createView(this.myProject);
            this.myTestKindViewMap.put(testKind, view);
            JComponent component = view.getComponent();
            if (component.getLayout() instanceof GridBagLayout) {
                component.add(Box.createHorizontalStrut(this.myLongestLabelWidth), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 13, 0, (Insets)JBUI.insetsRight((int)10), 0, 0));
            }
        }
        MochaTestKindView mochaTestKindView = view;
        if (mochaTestKindView == null) {
            MochaRunConfigurationEditor.$$$reportNull$$$0(7);
        }
        return mochaTestKindView;
    }

    @NotNull
    private ComponentWithBrowseButton<TextFieldWithHistory> createUiComponentWithInfoButton() {
        ComponentWithBrowseButton componentWithBrowseButton = SwingHelper.wrapWithInfoButton((JComponent)this.myUiComponent, (String)"Show description in browser", (ActionListener)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserUtil.browse((String)"https://mochajs.org/#interfaces");
            }
        });
        if (componentWithBrowseButton == null) {
            MochaRunConfigurationEditor.$$$reportNull$$$0(8);
        }
        return componentWithBrowseButton;
    }

    @NotNull
    private static TextFieldWithBrowseButton createWorkingDirTextField(@NotNull Project project) {
        if (project == null) {
            MochaRunConfigurationEditor.$$$reportNull$$$0(9);
        }
        TextFieldWithBrowseButton textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        SwingHelper.installFileCompletionAndBrowseDialog((Project)project, (TextFieldWithBrowseButton)textFieldWithBrowseButton, (String)NodeJSBundle.message("runConfiguration.mocha.working_dir.browse_dialog.title", new Object[0]), (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFolderDescriptor());
        PathShortener.enablePathShortening((JTextField)textFieldWithBrowseButton.getTextField(), null);
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = textFieldWithBrowseButton;
        if (textFieldWithBrowseButton2 == null) {
            MochaRunConfigurationEditor.$$$reportNull$$$0(10);
        }
        return textFieldWithBrowseButton2;
    }

    @NotNull
    private static TextFieldWithHistory createUiComponent() {
        TextFieldWithHistory textFieldWithHistory = new TextFieldWithHistory();
        textFieldWithHistory.setHistorySize(-1);
        textFieldWithHistory.setHistory(MochaUtil.getMochaUiList());
        TextFieldWithHistory textFieldWithHistory2 = textFieldWithHistory;
        if (textFieldWithHistory2 == null) {
            MochaRunConfigurationEditor.$$$reportNull$$$0(11);
        }
        return textFieldWithHistory2;
    }

    protected void resetEditorFrom(@NotNull MochaRunConfiguration configuration) {
        if (configuration == null) {
            MochaRunConfigurationEditor.$$$reportNull$$$0(12);
        }
        MochaRunSettings runSettings = configuration.getRunSettings();
        this.myNodeInterpreterField.setInterpreterRef(runSettings.getInterpreterRef());
        this.myNodeOptions.setText(runSettings.getNodeOptions());
        this.myWorkingDirTextFieldWithBrowseButton.setText(FileUtil.toSystemDependentName((String)runSettings.getWorkingDir()));
        this.myEnvironmentVariablesTextFieldWithBrowseButton.setData(runSettings.getEnvData());
        this.myMochaPackageField.setSelected(configuration.getMochaPackage());
        this.myUiComponent.setTextAndAddToHistory(runSettings.getUi());
        this.myExtraMochaOptions.setText(runSettings.getExtraMochaOptions());
        this.setTestKind(runSettings.getTestKind());
        MochaTestKindView view = this.getTestKindView(runSettings.getTestKind());
        view.resetFrom(runSettings);
        this.updatePreferredWidth();
    }

    private void updatePreferredWidth() {
        DialogWrapper dialogWrapper = DialogWrapper.findInstance((Component)this.myComponent);
        if (dialogWrapper instanceof SingleConfigurableEditor) {
            this.myNodeInterpreterField.setPreferredWidthToFitText();
            this.myMochaPackageField.setPreferredWidthToFitText();
            SwingHelper.setPreferredWidthToFitText((TextFieldWithBrowseButton)this.myWorkingDirTextFieldWithBrowseButton);
            ApplicationManager.getApplication().invokeLater(() -> SwingHelper.adjustDialogSizeToFitPreferredSize((DialogWrapper)dialogWrapper), ModalityState.any());
        }
    }

    protected void applyEditorTo(@NotNull MochaRunConfiguration configuration) {
        if (configuration == null) {
            MochaRunConfigurationEditor.$$$reportNull$$$0(13);
        }
        MochaRunSettings.Builder builder = new MochaRunSettings.Builder();
        NodeJsInterpreterRef interpreterRef2 = this.myNodeInterpreterField.getInterpreterRef();
        builder.setInterpreterRef(interpreterRef2);
        builder.setNodeOptions(this.myNodeOptions.getText());
        builder.setWorkingDir(PathShortener.getAbsolutePath((JTextField)this.myWorkingDirTextFieldWithBrowseButton.getTextField()));
        builder.setEnvData(this.myEnvironmentVariablesTextFieldWithBrowseButton.getData());
        builder.setMochaPackage(this.myMochaPackageField.getSelected());
        builder.setUi(StringUtil.notNullize((String)this.myUiComponent.getText()));
        builder.setExtraMochaOptions(this.myExtraMochaOptions.getText());
        MochaTestKind testKind = this.getTestKind();
        if (testKind != null) {
            builder.setTestKind(testKind);
            MochaTestKindView view = this.getTestKindView(testKind);
            view.applyTo(builder);
        }
        configuration.setRunSettings(builder.build());
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myComponent;
        if (jPanel == null) {
            MochaRunConfigurationEditor.$$$reportNull$$$0(14);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/mocha/execution/MochaRunConfigurationEditor";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testKind";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/mocha/execution/MochaRunConfigurationEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createExtraOptionsEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestKindRadioButtonPanel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestKindView";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createUiComponentWithInfoButton";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createWorkingDirTextField";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createUiComponent";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setTestKind";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setCenterBorderLayoutComponent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTestKindView";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createWorkingDirTextField";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

