/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.incrementalMerge;

import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.incrementalMerge.MergeFragment;
import com.intellij.openapi.diff.impl.util.ContextLogger;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class MergeBuilder {
    @NotNull
    private final ContextLogger LOG;
    @NotNull
    private final ArrayList<MergeFragment> myResult;
    @NotNull
    private final int[] myProcessed;
    @NotNull
    private final EqualPair[] myPairs;

    MergeBuilder(@NotNull ContextLogger log2) {
        if (log2 == null) {
            MergeBuilder.$$$reportNull$$$0(0);
        }
        this.myResult = new ArrayList();
        this.myProcessed = new int[]{0, 0, 0};
        this.myPairs = new EqualPair[2];
        this.LOG = log2;
    }

    public void add(@NotNull TextRange base, @NotNull TextRange version, @NotNull FragmentSide side) {
        if (base == null) {
            MergeBuilder.$$$reportNull$$$0(1);
        }
        if (version == null) {
            MergeBuilder.$$$reportNull$$$0(2);
        }
        if (side == null) {
            MergeBuilder.$$$reportNull$$$0(3);
        }
        int index = side.getIndex();
        int otherIndex = side.otherSide().getIndex();
        EqualPair pair = new EqualPair(base, version, side);
        this.LOG.assertTrue(this.myPairs[index] == null || pair.getBaseStart() - this.myPairs[index].getBaseEnd() >= 0);
        this.LOG.assertTrue(this.myPairs[otherIndex] == null || pair.getBaseStart() >= this.myPairs[otherIndex].getBaseStart());
        this.myPairs[index] = pair;
        if (this.myPairs[otherIndex] != null && this.myPairs[index].getBaseStart() >= this.myPairs[otherIndex].getBaseEnd()) {
            this.myPairs[otherIndex] = null;
        }
        this.process();
    }

    @NotNull
    public List<MergeFragment> finish(int leftLength, int baseLength, int rightLength) {
        if (!MergeBuilder.compare(new int[]{leftLength, rightLength, baseLength}, this.myProcessed)) {
            this.processConflict(leftLength, baseLength, rightLength);
        }
        ArrayList<MergeFragment> arrayList = this.myResult;
        if (arrayList == null) {
            MergeBuilder.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private void process() {
        while (this.myPairs[0] != null && this.myPairs[1] != null) {
            if (this.myPairs[0].startsFrom(this.myProcessed) && this.myPairs[1].startsFrom(this.myProcessed)) {
                int len = Math.min(this.myPairs[0].getLength(), this.myPairs[1].getLength());
                if (!this.myPairs[0].cutHead(len)) {
                    this.myPairs[0] = null;
                }
                if (!this.myPairs[1].cutHead(len)) {
                    this.myPairs[1] = null;
                }
                this.myProcessed[0] = this.myProcessed[0] + len;
                this.myProcessed[1] = this.myProcessed[1] + len;
                this.myProcessed[2] = this.myProcessed[2] + len;
                continue;
            }
            int nextBase = Math.max(this.myPairs[0].getBaseStart(), this.myPairs[1].getBaseStart());
            int[] nextVersion = new int[]{nextBase - this.myPairs[0].getBaseStart() + this.myPairs[0].getVersionStart(), nextBase - this.myPairs[1].getBaseStart() + this.myPairs[1].getVersionStart()};
            this.processConflict(nextVersion[0], nextBase, nextVersion[1]);
            if (!this.myPairs[0].cutHead(nextBase - this.myPairs[0].getBaseStart())) {
                this.myPairs[0] = null;
            }
            if (this.myPairs[1].cutHead(nextBase - this.myPairs[1].getBaseStart())) continue;
            this.myPairs[1] = null;
        }
    }

    private void processConflict(int nextLeft, int nextBase, int nextRight) {
        this.addConflict(new TextRange(this.myProcessed[0], nextLeft), new TextRange(this.myProcessed[2], nextBase), new TextRange(this.myProcessed[1], nextRight));
        this.myProcessed[0] = nextLeft;
        this.myProcessed[1] = nextRight;
        this.myProcessed[2] = nextBase;
    }

    private void addConflict(@NotNull TextRange left, @NotNull TextRange base, @NotNull TextRange right) {
        if (left == null) {
            MergeBuilder.$$$reportNull$$$0(5);
        }
        if (base == null) {
            MergeBuilder.$$$reportNull$$$0(6);
        }
        if (right == null) {
            MergeBuilder.$$$reportNull$$$0(7);
        }
        this.myResult.add(new MergeFragment(left, base, right));
    }

    private static boolean compare(@NotNull int[] lengths, @NotNull int[] processed2) {
        if (lengths == null) {
            MergeBuilder.$$$reportNull$$$0(8);
        }
        if (processed2 == null) {
            MergeBuilder.$$$reportNull$$$0(9);
        }
        for (int i = 0; i < lengths.length; ++i) {
            if (lengths[i] == processed2[i]) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "log";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/incrementalMerge/MergeBuilder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lengths";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processed";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/incrementalMerge/MergeBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "finish";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addConflict";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "compare";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class EqualPair {
        private int myBaseStart;
        private int myVersionStart;
        private int myLength;
        private final FragmentSide mySide;

        EqualPair(@NotNull TextRange base, @NotNull TextRange version, FragmentSide side) {
            if (base == null) {
                EqualPair.$$$reportNull$$$0(0);
            }
            if (version == null) {
                EqualPair.$$$reportNull$$$0(1);
            }
            if (side == null) {
                EqualPair.$$$reportNull$$$0(2);
            }
            MergeBuilder.this.LOG.assertTrue(base.getLength() == version.getLength());
            MergeBuilder.this.LOG.assertTrue(base.getLength() > 0);
            this.myBaseStart = base.getStartOffset();
            this.myVersionStart = version.getStartOffset();
            this.myLength = base.getLength();
            this.mySide = side;
        }

        public int getBaseStart() {
            return this.myBaseStart;
        }

        public int getVersionStart() {
            return this.myVersionStart;
        }

        public int getLength() {
            return this.myLength;
        }

        public int getBaseEnd() {
            return this.myBaseStart + this.myLength;
        }

        @NotNull
        public FragmentSide getSide() {
            FragmentSide fragmentSide = this.mySide;
            if (fragmentSide == null) {
                EqualPair.$$$reportNull$$$0(3);
            }
            return fragmentSide;
        }

        public int getIndex() {
            return this.mySide.getIndex();
        }

        public boolean startsFrom(int[] bound) {
            return this.versionStartsFrom(bound) && this.baseStartFrom(bound);
        }

        public boolean versionStartsFrom(int[] bound) {
            return this.myVersionStart == bound[this.mySide.getIndex()];
        }

        public boolean baseStartFrom(int[] bound) {
            return this.myBaseStart == bound[2];
        }

        public boolean cutHead(int delta) {
            MergeBuilder.this.LOG.assertTrue(this.myLength >= delta);
            MergeBuilder.this.LOG.assertTrue(delta >= 0);
            this.myBaseStart += delta;
            this.myVersionStart += delta;
            this.myLength -= delta;
            return this.myLength > 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "base";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "version";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/diff/impl/incrementalMerge/MergeBuilder$EqualPair";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/diff/impl/incrementalMerge/MergeBuilder$EqualPair";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSide";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

