/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate.quick;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.changes.issueLinks.LinkMouseListenerBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerEvaluateActionHandler;
import com.intellij.xdebugger.impl.evaluate.quick.XDebuggerPsiEvaluator;
import com.intellij.xdebugger.impl.evaluate.quick.XDebuggerTreeCreator;
import com.intellij.xdebugger.impl.evaluate.quick.common.AbstractValueHint;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueHintType;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.impl.ui.tree.nodes.XEvaluationCallbackBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodePresentationConfigurator;
import java.awt.Point;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XValueHint
extends AbstractValueHint {
    private static final Logger LOG = Logger.getInstance(XValueHint.class);
    private final XDebuggerEditorsProvider myEditorsProvider;
    private final XDebuggerEvaluator myEvaluator;
    private final XDebugSession myDebugSession;
    private final boolean myFromKeyboard;
    private final String myExpression;
    private final String myValueName;
    private final PsiElement myElement;
    private final XSourcePosition myExpressionPosition;
    private Disposable myDisposable;
    private static final Key<XValueHint> HINT_KEY = Key.create((String)"allows only one value hint per editor");

    public XValueHint(@NotNull Project project, @NotNull Editor editor, @NotNull Point point, @NotNull ValueHintType type, @NotNull ExpressionInfo expressionInfo, @NotNull XDebuggerEvaluator evaluator, @NotNull XDebugSession session2, boolean fromKeyboard) {
        if (project == null) {
            XValueHint.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            XValueHint.$$$reportNull$$$0(1);
        }
        if (point == null) {
            XValueHint.$$$reportNull$$$0(2);
        }
        if (type == null) {
            XValueHint.$$$reportNull$$$0(3);
        }
        if (expressionInfo == null) {
            XValueHint.$$$reportNull$$$0(4);
        }
        if (evaluator == null) {
            XValueHint.$$$reportNull$$$0(5);
        }
        if (session2 == null) {
            XValueHint.$$$reportNull$$$0(6);
        }
        this(project, session2.getDebugProcess().getEditorsProvider(), editor, point, type, expressionInfo, evaluator, session2, fromKeyboard);
    }

    protected XValueHint(@NotNull Project project, @NotNull XDebuggerEditorsProvider editorsProvider, @NotNull Editor editor, @NotNull Point point, @NotNull ValueHintType type, @NotNull ExpressionInfo expressionInfo, @NotNull XDebuggerEvaluator evaluator, boolean fromKeyboard) {
        if (project == null) {
            XValueHint.$$$reportNull$$$0(7);
        }
        if (editorsProvider == null) {
            XValueHint.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            XValueHint.$$$reportNull$$$0(9);
        }
        if (point == null) {
            XValueHint.$$$reportNull$$$0(10);
        }
        if (type == null) {
            XValueHint.$$$reportNull$$$0(11);
        }
        if (expressionInfo == null) {
            XValueHint.$$$reportNull$$$0(12);
        }
        if (evaluator == null) {
            XValueHint.$$$reportNull$$$0(13);
        }
        this(project, editorsProvider, editor, point, type, expressionInfo, evaluator, null, fromKeyboard);
    }

    private XValueHint(@NotNull Project project, @NotNull XDebuggerEditorsProvider editorsProvider, @NotNull Editor editor, @NotNull Point point, @NotNull ValueHintType type, @NotNull ExpressionInfo expressionInfo, @NotNull XDebuggerEvaluator evaluator, @Nullable XDebugSession session2, boolean fromKeyboard) {
        LanguageConsoleView console;
        if (project == null) {
            XValueHint.$$$reportNull$$$0(14);
        }
        if (editorsProvider == null) {
            XValueHint.$$$reportNull$$$0(15);
        }
        if (editor == null) {
            XValueHint.$$$reportNull$$$0(16);
        }
        if (point == null) {
            XValueHint.$$$reportNull$$$0(17);
        }
        if (type == null) {
            XValueHint.$$$reportNull$$$0(18);
        }
        if (expressionInfo == null) {
            XValueHint.$$$reportNull$$$0(19);
        }
        if (evaluator == null) {
            XValueHint.$$$reportNull$$$0(20);
        }
        super(project, editor, point, type, expressionInfo.getTextRange());
        this.myEditorsProvider = editorsProvider;
        this.myEvaluator = evaluator;
        this.myDebugSession = session2;
        this.myFromKeyboard = fromKeyboard;
        this.myExpression = XDebuggerEvaluateActionHandler.getExpressionText(expressionInfo, editor.getDocument());
        this.myValueName = XDebuggerEvaluateActionHandler.getDisplayText(expressionInfo, editor.getDocument());
        this.myElement = expressionInfo.getElement();
        ConsoleView consoleView = (ConsoleView)ConsoleViewImpl.CONSOLE_VIEW_IN_EDITOR_VIEW.get((UserDataHolder)editor);
        VirtualFile file2 = consoleView instanceof LanguageConsoleView ? ((console = (LanguageConsoleView)consoleView).getHistoryViewer() == editor ? console.getVirtualFile() : null) : FileDocumentManager.getInstance().getFile(editor.getDocument());
        this.myExpressionPosition = file2 != null ? XDebuggerUtil.getInstance().createPositionByOffset(file2, expressionInfo.getTextRange().getStartOffset()) : null;
    }

    @Override
    protected boolean canShowHint() {
        return true;
    }

    @Override
    protected boolean showHint(JComponent component) {
        boolean result2 = super.showHint(component);
        if (result2) {
            XValueHint prev2 = (XValueHint)this.getEditor().getUserData(HINT_KEY);
            if (prev2 != null) {
                prev2.hideHint();
            }
            this.getEditor().putUserData(HINT_KEY, (Object)this);
        }
        return result2;
    }

    @Override
    protected void onHintHidden() {
        super.onHintHidden();
        XValueHint prev2 = (XValueHint)this.getEditor().getUserData(HINT_KEY);
        if (prev2 == this) {
            this.getEditor().putUserData(HINT_KEY, null);
        }
        this.disposeVisibleHint();
    }

    @Override
    public void hideHint() {
        super.hideHint();
        this.disposeVisibleHint();
    }

    @Override
    protected void evaluateAndShowHint() {
        final AtomicBoolean showEvaluating = new AtomicBoolean(true);
        EdtExecutorService.getScheduledExecutorInstance().schedule(() -> {
            if (this.myCurrentHint == null && showEvaluating.get()) {
                SimpleColoredComponent component = HintUtil.createInformationComponent();
                component.append(XDebuggerUIConstants.EVALUATING_EXPRESSION_MESSAGE);
                this.showHint((JComponent)component);
            }
        }, 200L, TimeUnit.MILLISECONDS);
        XEvaluationCallbackBase callback2 = new XEvaluationCallbackBase(){

            public void evaluated(final @NotNull XValue result2) {
                if (result2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                result2.computePresentation((XValueNode)new XValueNodePresentationConfigurator.ConfigurableXValueNodeImpl(){
                    private XFullValueEvaluator myFullValueEvaluator;
                    private boolean myShown = false;

                    @Override
                    public void applyPresentation(@Nullable Icon icon, @NotNull XValuePresentation valuePresenter, boolean hasChildren) {
                        if (valuePresenter == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        showEvaluating.set(false);
                        if (XValueHint.this.isHintHidden()) {
                            return;
                        }
                        SimpleColoredText text = new SimpleColoredText();
                        XValueNodeImpl.buildText(valuePresenter, (ColoredTextContainer)text, false);
                        if (!hasChildren) {
                            JComponent component = XValueHint.this.createHintComponent(text, valuePresenter, this.myFullValueEvaluator);
                            XValueHint.this.showHint(component);
                        } else if (XValueHint.this.getType() == ValueHintType.MOUSE_CLICK_HINT) {
                            if (!this.myShown) {
                                XValueHint.this.showTree(result2);
                            }
                        } else {
                            if (XValueHint.this.getType() == ValueHintType.MOUSE_OVER_HINT) {
                                if (XValueHint.this.myFromKeyboard) {
                                    text.insert(0, "(" + KeymapUtil.getFirstKeyboardShortcutText((String)"ShowErrorDescription") + ") ", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                                }
                                XValueHint.this.disposeVisibleHint();
                                XValueHint.this.myDisposable = Disposer.newDisposable();
                                ShortcutSet shortcut = ActionManager.getInstance().getAction("ShowErrorDescription").getShortcutSet();
                                DumbAwareAction.create(e -> {
                                    if (result2 == null) {
                                        1.$$$reportNull$$$0(3);
                                    }
                                    XValueHint.this.showTree(result2);
                                }).registerCustomShortcutSet(shortcut, XValueHint.this.getEditor().getContentComponent(), XValueHint.this.myDisposable);
                            }
                            XValueHint.this.showHint(XValueHint.this.createExpandableHintComponent(text, () -> {
                                if (result2 == null) {
                                    1.$$$reportNull$$$0(2);
                                }
                                XValueHint.this.showTree(result2);
                            }));
                        }
                        this.myShown = true;
                    }

                    public void setFullValueEvaluator(@NotNull XFullValueEvaluator fullValueEvaluator) {
                        if (fullValueEvaluator == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        this.myFullValueEvaluator = fullValueEvaluator;
                    }

                    public boolean isObsolete() {
                        return XValueHint.this.isHintHidden();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "valuePresenter";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "fullValueEvaluator";
                                break;
                            }
                            case 2: 
                            case 3: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "result";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/xdebugger/impl/evaluate/quick/XValueHint$1$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "applyPresentation";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "setFullValueEvaluator";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "lambda$applyPresentation$1";
                                break;
                            }
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[2] = "lambda$applyPresentation$0";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                }, XValuePlace.TOOLTIP);
            }

            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    1.$$$reportNull$$$0(1);
                }
                showEvaluating.set(false);
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (errorMessage == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (XValueHint.this.getType() == ValueHintType.MOUSE_CLICK_HINT) {
                        XValueHint.this.showHint(HintUtil.createErrorLabel(errorMessage));
                    } else if (XValueHint.this.myCurrentHint != null) {
                        XValueHint.this.myCurrentHint.hide();
                    }
                });
                LOG.debug("Cannot evaluate '" + XValueHint.this.myExpression + "':" + errorMessage);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "result";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/xdebugger/impl/evaluate/quick/XValueHint$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "evaluated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "errorOccurred";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$errorOccurred$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (this.myElement != null && this.myEvaluator instanceof XDebuggerPsiEvaluator) {
            ((XDebuggerPsiEvaluator)this.myEvaluator).evaluate(this.myElement, callback2);
        } else {
            this.myEvaluator.evaluate(this.myExpression, (XDebuggerEvaluator.XEvaluationCallback)callback2, this.myExpressionPosition);
        }
    }

    @NotNull
    protected JComponent createHintComponent(@NotNull SimpleColoredText text, @NotNull XValuePresentation presentation, @Nullable XFullValueEvaluator evaluator) {
        if (text == null) {
            XValueHint.$$$reportNull$$$0(21);
        }
        if (presentation == null) {
            XValueHint.$$$reportNull$$$0(22);
        }
        SimpleColoredComponent component = HintUtil.createInformationComponent();
        text.appendToComponent((ColoredTextContainer)component);
        if (evaluator != null) {
            component.append(evaluator.getLinkText(), XDebuggerTreeNodeHyperlink.TEXT_ATTRIBUTES, event -> DebuggerUIUtil.showValuePopup(evaluator, event, this.getProject(), this.getEditor()));
            LinkMouseListenerBase.installSingleTagOn(component);
        }
        SimpleColoredComponent simpleColoredComponent = component;
        if (simpleColoredComponent == null) {
            XValueHint.$$$reportNull$$$0(23);
        }
        return simpleColoredComponent;
    }

    private void disposeVisibleHint() {
        if (this.myDisposable != null) {
            Disposer.dispose((Disposable)this.myDisposable);
            this.myDisposable = null;
        }
    }

    private void showTree(@NotNull XValue value) {
        if (value == null) {
            XValueHint.$$$reportNull$$$0(24);
        }
        if (this.myCurrentHint != null) {
            this.myCurrentHint.hide();
        }
        XValueMarkers<?, ?> valueMarkers = this.myDebugSession == null ? null : ((XDebugSessionImpl)this.myDebugSession).getValueMarkers();
        XSourcePosition position = this.myDebugSession == null ? null : this.myDebugSession.getCurrentPosition();
        XDebuggerTreeCreator creator = new XDebuggerTreeCreator(this.getProject(), this.myEditorsProvider, position, valueMarkers);
        this.showTreePopup(creator, Pair.create((Object)value, (Object)this.myValueName));
    }

    public String toString() {
        return this.myExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 3: 
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: 
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionInfo";
                break;
            }
            case 5: 
            case 13: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorsProvider";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/evaluate/quick/XValueHint";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/evaluate/quick/XValueHint";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createHintComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createHintComponent";
                break;
            }
            case 23: {
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "showTree";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

