/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.sablecc;

import java.util.Set;
import java.util.TreeSet;
import org.sablecc.sablecc.CharSet;
import org.sablecc.sablecc.NFA;
import org.sablecc.sablecc.ResolveIds;
import org.sablecc.sablecc.analysis.DepthFirstAdapter;
import org.sablecc.sablecc.node.ACharBasic;
import org.sablecc.sablecc.node.ACharChar;
import org.sablecc.sablecc.node.AConcat;
import org.sablecc.sablecc.node.ADecChar;
import org.sablecc.sablecc.node.AGrammar;
import org.sablecc.sablecc.node.AHelperDef;
import org.sablecc.sablecc.node.AHexChar;
import org.sablecc.sablecc.node.AIdBasic;
import org.sablecc.sablecc.node.AIntervalSet;
import org.sablecc.sablecc.node.AMinusBinOp;
import org.sablecc.sablecc.node.AOperationSet;
import org.sablecc.sablecc.node.APlusBinOp;
import org.sablecc.sablecc.node.APlusUnOp;
import org.sablecc.sablecc.node.AQMarkUnOp;
import org.sablecc.sablecc.node.ARegExp;
import org.sablecc.sablecc.node.ARegExpBasic;
import org.sablecc.sablecc.node.ASetBasic;
import org.sablecc.sablecc.node.AStarUnOp;
import org.sablecc.sablecc.node.AStateList;
import org.sablecc.sablecc.node.AStateListTail;
import org.sablecc.sablecc.node.AStringBasic;
import org.sablecc.sablecc.node.ATokenDef;
import org.sablecc.sablecc.node.ATokens;
import org.sablecc.sablecc.node.AUnExp;
import org.sablecc.sablecc.node.Node;
import org.sablecc.sablecc.node.Start;

public class ConstructNFA
extends DepthFirstAdapter {
    private ResolveIds ids;
    private String stateName;

    ConstructNFA(ResolveIds ids, String stateName) {
        this.ids = ids;
        this.stateName = stateName;
    }

    @Override
    public void outStart(Start node) {
        this.setOut(node, this.getOut(node.getPGrammar()));
        if (this.getOut(node.getPGrammar()) != null) {
            this.setOut(node.getPGrammar(), null);
        }
    }

    @Override
    public void outAGrammar(AGrammar node) {
        this.setOut(node, this.getOut(node.getTokens()));
        if (this.getOut(node.getTokens()) != null) {
            this.setOut(node.getTokens(), null);
        }
    }

    @Override
    public void outAHelperDef(AHelperDef node) {
        this.setOut(node, this.getOut(node.getRegExp()));
        if (this.getOut(node.getRegExp()) != null) {
            this.setOut(node.getRegExp(), null);
        }
    }

    @Override
    public void outATokens(ATokens node) {
        ATokenDef[] tokenDefs = node.getTokenDefs().toArray(new ATokenDef[0]);
        NFA result = null;
        for (int i = tokenDefs.length - 1; i >= 0; --i) {
            NFA nfa = (NFA)this.getOut(tokenDefs[i]);
            if (nfa == null) continue;
            result = result == null ? nfa : nfa.merge(result);
            if (this.getOut(tokenDefs[i]) == null) continue;
            this.setOut(tokenDefs[i], null);
        }
        if (result != null) {
            this.setOut(node, result);
        }
    }

    @Override
    public void outATokenDef(ATokenDef node) {
        Set set = (Set)this.getOut(node.getStateList());
        Object o1 = this.getOut(node.getRegExp());
        if (set == null || set.size() == 0 || set.contains(this.stateName)) {
            String name;
            NFA n1 = o1 instanceof NFA ? (NFA)o1 : new NFA((CharSet)o1);
            n1.states[n1.states.length - 1].accept = name = (String)this.ids.names.get(node);
            this.setOut(node, n1);
        }
        if (this.getOut(node.getStateList()) != null) {
            this.setOut(node.getStateList(), null);
        }
        if (this.getOut(node.getRegExp()) != null) {
            this.setOut(node.getRegExp(), null);
        }
    }

    @Override
    public void outAStateList(AStateList node) {
        TreeSet<String> set = new TreeSet<String>();
        AStateListTail[] stateListTails = node.getStateLists().toArray(new AStateListTail[0]);
        for (int i = stateListTails.length - 1; i >= 0; --i) {
            String str = stateListTails[i].getId().getText().toUpperCase();
            set.add(str);
        }
        set.add(node.getId().getText().toUpperCase());
        this.setOut(node, set);
    }

    @Override
    public void outARegExp(ARegExp node) {
        AConcat[] concats = node.getConcats().toArray(new AConcat[0]);
        NFA result = null;
        if (concats.length > 1) {
            for (int i = concats.length - 1; i >= 0; --i) {
                Object o = this.getOut(concats[i]);
                NFA nfa = o instanceof NFA ? (NFA)o : new NFA((CharSet)o);
                result = result == null ? nfa : nfa.alternate(result);
                if (this.getOut(concats[i]) == null) continue;
                this.setOut(concats[i], null);
            }
            this.setOut(node, result);
        } else if (concats.length == 1) {
            this.setOut(node, this.getOut(concats[0]));
            if (this.getOut(concats[0]) != null) {
                this.setOut(concats[0], null);
            }
        }
    }

    @Override
    public void outAConcat(AConcat node) {
        AUnExp[] unExps = node.getUnExps().toArray(new AUnExp[0]);
        if (unExps.length == 0) {
            this.setOut(node, new NFA());
        } else if (unExps.length == 1) {
            this.setOut(node, this.getOut(unExps[0]));
            if (this.getOut(unExps[0]) != null) {
                this.setOut(unExps[0], null);
            }
        } else {
            NFA result = null;
            for (int i = unExps.length - 1; i >= 0; --i) {
                Object o = this.getOut(unExps[i]);
                NFA nfa = o instanceof NFA ? (NFA)o : new NFA((CharSet)o);
                result = result == null ? nfa : nfa.concatenate(result);
                if (this.getOut(unExps[i]) == null) continue;
                this.setOut(unExps[i], null);
            }
            this.setOut(node, result);
        }
    }

    @Override
    public void outAUnExp(AUnExp node) {
        Object o = this.getOut(node.getBasic());
        int c = 32;
        if (node.getUnOp() != null) {
            c = ((Character)this.getOut(node.getUnOp())).charValue();
        }
        switch (c) {
            case 42: {
                NFA n = o instanceof NFA ? (NFA)o : new NFA((CharSet)o);
                this.setOut(node, n.zeroOrMore());
                break;
            }
            case 63: {
                NFA n = o instanceof NFA ? (NFA)o : new NFA((CharSet)o);
                this.setOut(node, n.zeroOrOne());
                break;
            }
            case 43: {
                NFA n = o instanceof NFA ? (NFA)o : new NFA((CharSet)o);
                this.setOut(node, n.oneOrMore());
                break;
            }
            default: {
                this.setOut(node, o);
            }
        }
        if (this.getOut(node.getBasic()) != null) {
            this.setOut(node.getBasic(), null);
        }
        if (this.getOut(node.getUnOp()) != null) {
            this.setOut(node.getUnOp(), null);
        }
    }

    @Override
    public void outACharBasic(ACharBasic node) {
        char c = ((Character)this.getOut(node.getChar())).charValue();
        this.setOut(node, new CharSet(c));
        if (this.getOut(node.getChar()) != null) {
            this.setOut(node.getChar(), null);
        }
    }

    @Override
    public void outASetBasic(ASetBasic node) {
        this.setOut(node, this.getOut(node.getSet()));
        if (this.getOut(node.getSet()) != null) {
            this.setOut(node.getSet(), null);
        }
    }

    @Override
    public void outAStringBasic(AStringBasic node) {
        String s = node.getString().getText();
        s = s.substring(1, s.length() - 1);
        this.setOut(node, new NFA(s));
    }

    @Override
    public void outAIdBasic(AIdBasic node) {
        Object o = this.getOut((Node)this.ids.helpers.get(node.getId().getText()));
        if (o instanceof NFA) {
            this.setOut(node, ((NFA)o).clone());
        } else {
            this.setOut(node, ((CharSet)o).clone());
        }
    }

    @Override
    public void outARegExpBasic(ARegExpBasic node) {
        this.setOut(node, this.getOut(node.getRegExp()));
        if (this.getOut(node.getRegExp()) != null) {
            this.setOut(node.getRegExp(), null);
        }
    }

    @Override
    public void outACharChar(ACharChar node) {
        this.setOut(node, new Character(node.getChar().getText().charAt(1)));
    }

    @Override
    public void outADecChar(ADecChar node) {
        this.setOut(node, new Character((char)Integer.parseInt(node.getDecChar().getText())));
    }

    @Override
    public void outAHexChar(AHexChar node) {
        this.setOut(node, new Character((char)Integer.parseInt(node.getHexChar().getText().substring(2), 16)));
    }

    @Override
    public void outAOperationSet(AOperationSet node) {
        try {
            CharSet cs1 = (CharSet)this.getOut(node.getLeft());
            CharSet cs2 = (CharSet)this.getOut(node.getRight());
            char binop = ((Character)this.getOut(node.getBinOp())).charValue();
            switch (binop) {
                case '+': {
                    this.setOut(node, cs1.union(cs2));
                    break;
                }
                case '-': {
                    this.setOut(node, cs1.diff(cs2));
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(node + " is invalid.");
        }
        if (this.getOut(node.getLeft()) != null) {
            this.setOut(node.getLeft(), null);
        }
        if (this.getOut(node.getBinOp()) != null) {
            this.setOut(node.getBinOp(), null);
        }
        if (this.getOut(node.getRight()) != null) {
            this.setOut(node.getRight(), null);
        }
    }

    @Override
    public void outAIntervalSet(AIntervalSet node) {
        char c2;
        char c1 = ((Character)this.getOut(node.getLeft())).charValue();
        if (c1 > (c2 = ((Character)this.getOut(node.getRight())).charValue())) {
            throw new RuntimeException(node + " is invalid.");
        }
        this.setOut(node, new CharSet(c1, c2));
        if (this.getOut(node.getLeft()) != null) {
            this.setOut(node.getLeft(), null);
        }
        if (this.getOut(node.getRight()) != null) {
            this.setOut(node.getRight(), null);
        }
    }

    @Override
    public void outAStarUnOp(AStarUnOp node) {
        this.setOut(node, new Character('*'));
    }

    @Override
    public void outAQMarkUnOp(AQMarkUnOp node) {
        this.setOut(node, new Character('?'));
    }

    @Override
    public void outAPlusUnOp(APlusUnOp node) {
        this.setOut(node, new Character('+'));
    }

    @Override
    public void outAPlusBinOp(APlusBinOp node) {
        this.setOut(node, new Character('+'));
    }

    @Override
    public void outAMinusBinOp(AMinusBinOp node) {
        this.setOut(node, new Character('-'));
    }

    @Override
    public Object getOut(Node node) {
        if (node == null) {
            return null;
        }
        return super.getOut(node);
    }

    @Override
    public void setOut(Node node, Object out) {
        if (node == null) {
            throw new NullPointerException();
        }
        super.setOut(node, out);
    }
}

