/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.tables;

import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.caffinitas.ohc.OHCacheBuilder;
import org.caffinitas.ohc.histo.EstimatedHistogram;
import org.caffinitas.ohc.tables.HashEntries;
import org.caffinitas.ohc.tables.KeyBuffer;
import org.caffinitas.ohc.tables.LongArrayList;
import org.caffinitas.ohc.tables.Uns;
import org.caffinitas.ohc.tables.Util;

final class OffHeapMap {
    private static final int MAX_TABLE_SIZE = 0x40000000;
    private final int entriesPerBucket;
    private long size;
    private Table table;
    private long threshold;
    private final float loadFactor;
    private long lruCompactions;
    private long hitCount;
    private long missCount;
    private long putAddCount;
    private long putReplaceCount;
    private long removeCount;
    private long rehashes;
    private long evictedEntries;
    private long freeCapacity;
    private final ReentrantLock lock;
    private final boolean throwOOME;

    OffHeapMap(OHCacheBuilder builder, long freeCapacity) {
        int bl;
        this.freeCapacity = freeCapacity;
        this.throwOOME = builder.isThrowOOME();
        this.lock = builder.isUnlocked() ? null : new ReentrantLock();
        int hts = builder.getHashTableSize();
        if (hts <= 0) {
            hts = 8192;
        }
        if (hts < 256) {
            hts = 256;
        }
        if ((bl = builder.getBucketLength()) <= 0) {
            bl = 8;
        }
        int buckets = (int)Util.roundUpToPowerOf2(hts, 0x40000000L);
        this.entriesPerBucket = (int)Util.roundUpToPowerOf2(bl, 0x40000000L);
        this.table = Table.create(buckets, this.entriesPerBucket, this.throwOOME);
        if (this.table == null) {
            throw new RuntimeException("unable to allocate off-heap memory for segment");
        }
        float lf = builder.getLoadFactor();
        if ((double)lf <= 0.0) {
            lf = 0.75f;
        }
        if ((double)lf >= 1.0) {
            throw new IllegalArgumentException("load factor must not be greater that 1");
        }
        this.loadFactor = lf;
        this.threshold = (long)((double)this.table.size() * (double)this.loadFactor);
    }

    void release() {
        this.lock();
        try {
            this.table.release();
            this.table = null;
        }
        finally {
            this.unlock();
        }
    }

    long size() {
        return this.size;
    }

    long hitCount() {
        return this.hitCount;
    }

    long missCount() {
        return this.missCount;
    }

    long putAddCount() {
        return this.putAddCount;
    }

    long putReplaceCount() {
        return this.putReplaceCount;
    }

    long removeCount() {
        return this.removeCount;
    }

    void resetStatistics() {
        this.rehashes = 0L;
        this.evictedEntries = 0L;
        this.hitCount = 0L;
        this.missCount = 0L;
        this.putAddCount = 0L;
        this.putReplaceCount = 0L;
        this.removeCount = 0L;
        this.lruCompactions = 0L;
    }

    long rehashes() {
        return this.rehashes;
    }

    long freeCapacity() {
        return this.freeCapacity;
    }

    void updateFreeCapacity(long diff) {
        this.lock();
        try {
            this.freeCapacity += diff;
        }
        finally {
            this.unlock();
        }
    }

    long evictedEntries() {
        return this.evictedEntries;
    }

    long lruCompactions() {
        return this.lruCompactions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getEntry(KeyBuffer key, boolean reference, boolean updateLRU) {
        this.lock();
        try {
            long hashEntryAdr;
            long ptr = this.table.bucketOffset(key.hash());
            int idx = 0;
            while (idx < this.entriesPerBucket && (hashEntryAdr = this.table.getEntryAdr(ptr)) != 0L) {
                if (this.table.getHash(ptr) == key.hash() && !OffHeapMap.notSameKey(key, hashEntryAdr)) {
                    if (updateLRU) {
                        this.touch(hashEntryAdr);
                    }
                    if (reference) {
                        HashEntries.reference(hashEntryAdr);
                    }
                    ++this.hitCount;
                    long l = hashEntryAdr;
                    return l;
                }
                ++idx;
                ptr += 16L;
            }
            ++this.missCount;
            long l = 0L;
            return l;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean putEntry(long newHashEntryAdr, long hash, long keyLen, long bytes, boolean ifAbsent, long oldValueAdr, long oldValueLen) {
        long removeHashEntryAdr = 0L;
        LongArrayList derefList = null;
        this.lock();
        try {
            boolean bl;
            long hashEntryAdr;
            long ptr = this.table.bucketOffset(hash);
            int idx = 0;
            while (idx < this.entriesPerBucket && (hashEntryAdr = this.table.getEntryAdr(ptr)) != 0L) {
                if (this.table.getHash(ptr) == hash) {
                    long allocLen = HashEntries.getAllocLen(hashEntryAdr);
                    if (!OffHeapMap.notSameKey(newHashEntryAdr, keyLen, hashEntryAdr)) {
                        if (ifAbsent) {
                            boolean bl2 = false;
                            return bl2;
                        }
                        if (!(oldValueAdr == 0L || HashEntries.getValueLen(hashEntryAdr) == oldValueLen && HashEntries.compare(hashEntryAdr, 40L + Util.roundUpTo8(keyLen), oldValueAdr, 0L, oldValueLen))) {
                            boolean bl3 = false;
                            return bl3;
                        }
                        this.freeCapacity += allocLen;
                        this.table.removeFromTableWithOff(hashEntryAdr, ptr, idx);
                        removeHashEntryAdr = hashEntryAdr;
                        break;
                    }
                }
                ++idx;
                ptr += 16L;
            }
            if (this.freeCapacity < bytes) {
                derefList = new LongArrayList();
                do {
                    long eldestEntryAdr;
                    if ((eldestEntryAdr = this.table.removeEldest()) == 0L) {
                        if (removeHashEntryAdr != 0L) {
                            --this.size;
                        }
                        boolean bl4 = false;
                        return bl4;
                    }
                    this.freeCapacity += HashEntries.getAllocLen(eldestEntryAdr);
                    --this.size;
                    ++this.evictedEntries;
                    derefList.add(eldestEntryAdr);
                } while (this.freeCapacity < bytes);
            }
            if (removeHashEntryAdr == 0L) {
                if (this.size >= this.threshold) {
                    this.rehash();
                }
                ++this.size;
            }
            if (!this.add(newHashEntryAdr, hash)) {
                bl = false;
                return bl;
            }
            this.freeCapacity -= bytes;
            if (removeHashEntryAdr == 0L) {
                ++this.putAddCount;
            } else {
                ++this.putReplaceCount;
            }
            bl = true;
            return bl;
        }
        finally {
            this.unlock();
            if (removeHashEntryAdr != 0L) {
                HashEntries.dereference(removeHashEntryAdr);
            }
            if (derefList != null) {
                for (int i = 0; i < derefList.size(); ++i) {
                    HashEntries.dereference(derefList.getLong(i));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        this.lock();
        try {
            this.size = 0L;
            long freed = 0L;
            for (int p = 0; p < this.table.size(); ++p) {
                long hashEntryAdr;
                long ptr = this.table.bucketOffset(p);
                int idx = 0;
                while (idx < this.entriesPerBucket && (hashEntryAdr = this.table.getEntryAdr(ptr)) != 0L) {
                    freed += HashEntries.getAllocLen(hashEntryAdr);
                    HashEntries.dereference(hashEntryAdr);
                    ++idx;
                    ptr += 16L;
                }
            }
            this.table.clear();
            this.freeCapacity += freed;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeEntry(long removeHashEntryAdr) {
        this.lock();
        try {
            long hashEntryAdr;
            long hash = HashEntries.getHash(removeHashEntryAdr);
            long ptr = this.table.bucketOffset(hash);
            int idx = 0;
            while (idx < this.entriesPerBucket && (hashEntryAdr = this.table.getEntryAdr(ptr)) != 0L) {
                if (hashEntryAdr == removeHashEntryAdr) {
                    this.removeInternal(hashEntryAdr, ptr, idx);
                    return;
                }
                ++idx;
                ptr += 16L;
            }
            removeHashEntryAdr = 0L;
        }
        finally {
            this.unlock();
            if (removeHashEntryAdr != 0L) {
                HashEntries.dereference(removeHashEntryAdr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeEntry(KeyBuffer key) {
        long removeHashEntryAdr = 0L;
        this.lock();
        try {
            long ptr = this.table.bucketOffset(key.hash());
            int idx = 0;
            while (idx < this.entriesPerBucket) {
                long hashEntryAdr = this.table.getEntryAdr(ptr);
                if (hashEntryAdr == 0L) {
                    break;
                }
                if (this.table.getHash(ptr) == key.hash() && !OffHeapMap.notSameKey(key, hashEntryAdr)) {
                    removeHashEntryAdr = hashEntryAdr;
                    this.removeInternal(hashEntryAdr, ptr, idx);
                    return;
                }
                ++idx;
                ptr += 16L;
            }
        }
        finally {
            this.unlock();
            if (removeHashEntryAdr != 0L) {
                HashEntries.dereference(removeHashEntryAdr);
            }
        }
    }

    private void removeInternal(long hashEntryAdr, long off, int idx) {
        this.table.removeFromTableWithOff(hashEntryAdr, off, idx);
        this.freeCapacity += HashEntries.getAllocLen(hashEntryAdr);
        --this.size;
        ++this.removeCount;
    }

    private static boolean notSameKey(KeyBuffer key, long hashEntryAdr) {
        long serKeyLen = HashEntries.getKeyLen(hashEntryAdr);
        return serKeyLen != (long)key.size() || !HashEntries.compareKey(hashEntryAdr, key, serKeyLen);
    }

    private static boolean notSameKey(long newHashEntryAdr, long newKeyLen, long hashEntryAdr) {
        long serKeyLen = HashEntries.getKeyLen(hashEntryAdr);
        return serKeyLen != newKeyLen || !HashEntries.compare(hashEntryAdr, 40L, newHashEntryAdr, 40L, serKeyLen);
    }

    private void rehash() {
        Table tab = this.table;
        int tableSize = tab.size();
        if (tableSize > 0x40000000) {
            return;
        }
        Table newTable = Table.create(tableSize * 2, this.entriesPerBucket, this.throwOOME);
        if (newTable == null) {
            return;
        }
        for (int part = 0; part < tableSize; ++part) {
            long hashEntryAdr;
            long ptr = this.table.bucketOffset(part);
            int idx = 0;
            while (idx < this.entriesPerBucket && (hashEntryAdr = this.table.getEntryAdr(ptr)) != 0L) {
                if (!newTable.addToTable(this.table.getHash(ptr), hashEntryAdr)) {
                    HashEntries.dereference(hashEntryAdr);
                }
                ++idx;
                ptr += 16L;
            }
        }
        newTable.copyLRU(this.table);
        this.threshold = (long)((float)newTable.size() * this.loadFactor);
        this.table.release();
        this.table = newTable;
        ++this.rehashes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long[] hotN(int n) {
        this.lock();
        try {
            long[] r = new long[n];
            this.table.fillHotN(r, n);
            for (long hashEntryAdr : r) {
                if (hashEntryAdr == 0L) continue;
                HashEntries.reference(hashEntryAdr);
            }
            long[] lArray = r;
            return lArray;
        }
        finally {
            this.unlock();
        }
    }

    float loadFactor() {
        return this.loadFactor;
    }

    int hashTableSize() {
        return this.table.size();
    }

    void updateBucketHistogram(EstimatedHistogram hist) {
        this.lock();
        try {
            this.table.updateBucketHistogram(hist);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getEntryAddresses(int mapSegmentIndex, int nSegments, List<Long> hashEntryAdrs) {
        this.lock();
        try {
            while (nSegments-- > 0 && mapSegmentIndex < this.table.size()) {
                long hashEntryAdr;
                long ptr = this.table.bucketOffset(mapSegmentIndex);
                int idx = 0;
                while (idx < this.entriesPerBucket && (hashEntryAdr = this.table.getEntryAdr(ptr)) != 0L) {
                    hashEntryAdrs.add(hashEntryAdr);
                    HashEntries.reference(hashEntryAdr);
                    ++idx;
                    ptr += 16L;
                }
                ++mapSegmentIndex;
            }
        }
        finally {
            this.unlock();
        }
    }

    private boolean add(long hashEntryAdr, long hash) {
        if (!this.table.addToTable(hash, hashEntryAdr)) {
            return false;
        }
        this.addToLRU(hashEntryAdr);
        return true;
    }

    private void touch(long hashEntryAdr) {
        this.table.removeFromLRU(hashEntryAdr);
        this.addToLRU(hashEntryAdr);
    }

    private void addToLRU(long hashEntryAdr) {
        if (this.table.addToLRU(hashEntryAdr)) {
            ++this.lruCompactions;
        }
    }

    private void lock() {
        if (this.lock != null) {
            this.lock.lock();
        }
    }

    private void unlock() {
        if (this.lock != null) {
            this.lock.unlock();
        }
    }

    static final class Table {
        final int mask;
        final long address;
        private final int entriesPerBucket;
        private boolean released;
        private final long lruOffset;
        private int lruWriteTarget;
        private int lruEldestIndex;

        static Table create(int hashTableSize, int entriesPerBucket, boolean throwOOME) {
            int msz = 16 * hashTableSize * entriesPerBucket;
            long address = Uns.allocate(msz += hashTableSize * 8, throwOOME);
            return address != 0L ? new Table(address, hashTableSize, entriesPerBucket) : null;
        }

        private Table(long address, int hashTableSize, int entriesPerBucket) {
            this.address = address;
            this.mask = hashTableSize - 1;
            this.entriesPerBucket = entriesPerBucket;
            this.lruOffset = 16L * (long)hashTableSize * (long)entriesPerBucket;
            this.lruWriteTarget = 0;
            this.clear();
        }

        void removeFromTableWithOff(long hashEntryAdr, long off, int idx) {
            while (idx < this.entriesPerBucket) {
                if (idx < this.entriesPerBucket - 1) {
                    long adr = this.getEntryAdr(off + 16L);
                    long h = this.getHash(off + 16L);
                    this.setEntryAdr(off, adr);
                    this.setHash(off, h);
                    if (adr == 0L) {
                        break;
                    }
                } else {
                    this.setEntryAdr(off, 0L);
                }
                ++idx;
                off += 16L;
            }
            this.removeFromLRU(hashEntryAdr);
        }

        long removeEldest() {
            int i = this.lruEldestIndex;
            long off = this.lruOffset(i);
            while (i < this.lruWriteTarget) {
                block5: {
                    long hashEntryAdr = Uns.getAndPutLong(this.address, off, 0L);
                    if (hashEntryAdr == 0L) break block5;
                    this.lruEldestIndex = i + 1;
                    off = this.bucketOffset(HashEntries.getHash(hashEntryAdr));
                    boolean st = false;
                    i = 0;
                    while (i < this.entriesPerBucket) {
                        block8: {
                            long adr;
                            block6: {
                                block7: {
                                    if (st) break block6;
                                    adr = this.getEntryAdr(off);
                                    if (adr != hashEntryAdr) break block7;
                                    st = true;
                                    break block6;
                                }
                                if (adr == 0L) {
                                    break;
                                }
                                break block8;
                            }
                            adr = this.getEntryAdr(off + 16L);
                            long h = this.getHash(off + 16L);
                            if (i < this.entriesPerBucket - 1) {
                                this.setEntryAdr(off, adr);
                                this.setHash(off, h);
                            } else {
                                this.setEntryAdr(off, 0L);
                            }
                            if (adr == 0L) break;
                        }
                        ++i;
                        off += 16L;
                    }
                    return hashEntryAdr;
                }
                ++i;
                off += 8L;
            }
            return 0L;
        }

        void fillHotN(long[] r, int n) {
            int c = 0;
            int i = this.lruWriteTarget - 1;
            long off = this.lruOffset(i);
            while (i >= this.lruEldestIndex) {
                long hashEntryAdr = Uns.getLong(this.address, off);
                if (hashEntryAdr != 0L) {
                    r[c++] = hashEntryAdr;
                    if (c == n) {
                        return;
                    }
                }
                --i;
                off -= 8L;
            }
        }

        void copyLRU(Table srcTable) {
            this.lruEldestIndex = srcTable.lruEldestIndex;
            this.lruWriteTarget = srcTable.lruWriteTarget;
            Uns.copyMemory(srcTable.address, srcTable.lruOffset(0), this.address, this.lruOffset(0), (long)(this.lruWriteTarget * 8));
        }

        boolean addToLRU(long hashEntryAdr) {
            if (this.lruWriteTarget < this.size()) {
                this.entryToLRU(hashEntryAdr, this.lruWriteTarget++);
                return false;
            }
            int id = 0;
            int is = this.lruEldestIndex;
            long off = this.lruOffset(is);
            while (is < this.size()) {
                long adr = Uns.getLong(this.address, off);
                if (adr != 0L) {
                    if (is != id) {
                        this.entryToLRU(adr, id);
                    }
                    ++id;
                }
                ++is;
                off += 8L;
            }
            this.entryToLRU(hashEntryAdr, id++);
            this.lruWriteTarget = id;
            this.lruEldestIndex = 0;
            Uns.setMemory(this.address, this.lruOffset(id), (this.size() - id) * 8, (byte)0);
            return true;
        }

        private void entryToLRU(long hashEntryAdr, int id) {
            Uns.putLong(this.address, this.lruOffset(id), hashEntryAdr);
            HashEntries.setLRUIndex(hashEntryAdr, id);
        }

        void removeFromLRU(long hashEntryAdr) {
            int lruIndex = HashEntries.getLRUIndex(hashEntryAdr);
            if (this.lruEldestIndex == lruIndex) {
                ++this.lruEldestIndex;
            }
            if (lruIndex == this.lruWriteTarget - 1) {
                this.lruWriteTarget = lruIndex;
            }
            Uns.putLong(this.address, this.lruOffset(lruIndex), 0L);
        }

        private long lruOffset(int i) {
            return this.lruOffset + (long)(i * 8);
        }

        void clear() {
            Uns.setMemory(this.address, 0L, 16L * (long)this.entriesPerBucket * (long)this.size() + (long)(8 * this.size()), (byte)0);
        }

        void release() {
            Uns.free(this.address);
            this.released = true;
        }

        protected void finalize() throws Throwable {
            if (!this.released) {
                Uns.free(this.address);
            }
            super.finalize();
        }

        boolean addToTable(long hash, long hashEntryAdr) {
            long off = this.bucketOffset(hash);
            int i = 0;
            while (i < this.entriesPerBucket) {
                if (Uns.compareAndSwapLong(this.address, off, 0L, hashEntryAdr)) {
                    this.setHash(off, hash);
                    return true;
                }
                ++i;
                off += 16L;
            }
            return false;
        }

        long bucketOffset(long hash) {
            return (long)(this.bucketIndexForHash(hash) * this.entriesPerBucket) * 16L;
        }

        private int bucketIndexForHash(long hash) {
            return (int)(hash & (long)this.mask);
        }

        int size() {
            return this.mask + 1;
        }

        void updateBucketHistogram(EstimatedHistogram h) {
            for (int p = 0; p < this.size(); ++p) {
                h.add(this.bucketLength(p) + 1);
            }
        }

        private int bucketLength(long hash) {
            int len = 0;
            long off = this.bucketOffset(hash);
            int i = 0;
            while (i < this.entriesPerBucket && this.getEntryAdr(off) != 0L) {
                ++len;
                ++i;
                off += 16L;
            }
            return len;
        }

        long getEntryAdr(long entryOff) {
            return Uns.getLong(this.address, entryOff);
        }

        private void setEntryAdr(long entryOff, long adr) {
            Uns.putLong(this.address, entryOff, adr);
        }

        long getHash(long entryOff) {
            return Uns.getLong(this.address, entryOff + 8L);
        }

        private void setHash(long entryOff, long adr) {
            Uns.putLong(this.address, entryOff + 8L, adr);
        }
    }
}

