/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.monitoring;

import org.apache.cassandra.db.monitoring.ApproximateTime;
import org.apache.cassandra.db.monitoring.Monitorable;
import org.apache.cassandra.db.monitoring.MonitoringState;
import org.apache.cassandra.db.monitoring.MonitoringTask;

public abstract class MonitorableImpl
implements Monitorable {
    private MonitoringState state = MonitoringState.IN_PROGRESS;
    private boolean isSlow = false;
    private long constructionTime = -1L;
    private long timeout;
    private long slowTimeout;
    private boolean isCrossNode;

    protected MonitorableImpl() {
    }

    public void setMonitoringTime(long constructionTime, boolean isCrossNode, long timeout, long slowTimeout) {
        assert (constructionTime >= 0L);
        this.constructionTime = constructionTime;
        this.isCrossNode = isCrossNode;
        this.timeout = timeout;
        this.slowTimeout = slowTimeout;
    }

    @Override
    public long constructionTime() {
        return this.constructionTime;
    }

    @Override
    public long timeout() {
        return this.timeout;
    }

    @Override
    public boolean isCrossNode() {
        return this.isCrossNode;
    }

    @Override
    public long slowTimeout() {
        return this.slowTimeout;
    }

    @Override
    public boolean isInProgress() {
        this.check();
        return this.state == MonitoringState.IN_PROGRESS;
    }

    @Override
    public boolean isAborted() {
        this.check();
        return this.state == MonitoringState.ABORTED;
    }

    @Override
    public boolean isCompleted() {
        this.check();
        return this.state == MonitoringState.COMPLETED;
    }

    @Override
    public boolean isSlow() {
        this.check();
        return this.isSlow;
    }

    @Override
    public boolean abort() {
        if (this.state == MonitoringState.IN_PROGRESS) {
            if (this.constructionTime >= 0L) {
                MonitoringTask.addFailedOperation(this, ApproximateTime.currentTimeMillis());
            }
            this.state = MonitoringState.ABORTED;
            return true;
        }
        return this.state == MonitoringState.ABORTED;
    }

    @Override
    public boolean complete() {
        if (this.state == MonitoringState.IN_PROGRESS) {
            if (this.isSlow && this.slowTimeout > 0L && this.constructionTime >= 0L) {
                MonitoringTask.addSlowOperation(this, ApproximateTime.currentTimeMillis());
            }
            this.state = MonitoringState.COMPLETED;
            return true;
        }
        return this.state == MonitoringState.COMPLETED;
    }

    private void check() {
        if (this.constructionTime < 0L || this.state != MonitoringState.IN_PROGRESS) {
            return;
        }
        long elapsed = ApproximateTime.currentTimeMillis() - this.constructionTime;
        if (elapsed >= this.slowTimeout && !this.isSlow) {
            this.isSlow = true;
        }
        if (elapsed >= this.timeout) {
            this.abort();
        }
    }
}

