/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import io.airlift.command.Command;
import io.airlift.command.Option;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.db.compaction.CompactionManagerMBean;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;
import org.apache.cassandra.tools.nodetool.formatter.TableBuilder;

@Command(name="compactionstats", description="Print statistics on compactions")
public class CompactionStats
extends NodeTool.NodeToolCmd {
    @Option(title="human_readable", name={"-H", "--human-readable"}, description="Display bytes in human readable form, i.e. KiB, MiB, GiB, TiB")
    private boolean humanReadable = false;

    @Override
    public void execute(NodeProbe probe) {
        CompactionManagerMBean cm = probe.getCompactionManagerProxy();
        Map pendingTaskNumberByTable = (Map)probe.getCompactionMetric("PendingTasksByTableName");
        int numTotalPendingTask = 0;
        for (Map.Entry ksEntry : pendingTaskNumberByTable.entrySet()) {
            for (Map.Entry tableEntry : ((Map)ksEntry.getValue()).entrySet()) {
                numTotalPendingTask += ((Integer)tableEntry.getValue()).intValue();
            }
        }
        System.out.println("pending tasks: " + numTotalPendingTask);
        for (Map.Entry ksEntry : pendingTaskNumberByTable.entrySet()) {
            String ksName = (String)ksEntry.getKey();
            for (Map.Entry tableEntry : ((Map)ksEntry.getValue()).entrySet()) {
                String tableName = (String)tableEntry.getKey();
                int pendingTaskCount = (Integer)tableEntry.getValue();
                System.out.println("- " + ksName + '.' + tableName + ": " + pendingTaskCount);
            }
        }
        System.out.println();
        CompactionStats.reportCompactionTable(cm.getCompactions(), probe.getCompactionThroughput(), this.humanReadable);
    }

    public static void reportCompactionTable(List<Map<String, String>> compactions, int compactionThroughput, boolean humanReadable) {
        if (!compactions.isEmpty()) {
            long remainingBytes = 0L;
            TableBuilder table = new TableBuilder();
            table.add("id", "compaction type", "keyspace", "table", "completed", "total", "unit", "progress");
            for (Map<String, String> c : compactions) {
                long total = Long.parseLong(c.get("total"));
                long completed = Long.parseLong(c.get("completed"));
                String taskType = c.get("taskType");
                String keyspace = c.get("keyspace");
                String columnFamily = c.get("columnfamily");
                String completedStr = humanReadable ? FileUtils.stringifyFileSize(completed) : Long.toString(completed);
                String totalStr = humanReadable ? FileUtils.stringifyFileSize(total) : Long.toString(total);
                String unit = c.get("unit");
                String percentComplete = total == 0L ? "n/a" : new DecimalFormat("0.00").format((double)completed / (double)total * 100.0) + "%";
                String id = c.get("compactionId");
                table.add(id, taskType, keyspace, columnFamily, completedStr, totalStr, unit, percentComplete);
                if (!taskType.equals(OperationType.COMPACTION.toString())) continue;
                remainingBytes += total - completed;
            }
            table.printTo(System.out);
            String remainingTime = "n/a";
            if (compactionThroughput != 0) {
                long remainingTimeInSecs = remainingBytes / (0x100000L * (long)compactionThroughput);
                remainingTime = String.format("%dh%02dm%02ds", remainingTimeInSecs / 3600L, remainingTimeInSecs % 3600L / 60L, remainingTimeInSecs % 60L);
            }
            System.out.printf("%25s%10s%n", "Active compaction remaining time : ", remainingTime);
        }
    }
}

