/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.randomizedtesting.generators;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public final class RandomPicks {
    public static byte randomFrom(Random r, byte[] array) {
        RandomPicks.checkZeroLength(array.length);
        return array[r.nextInt(array.length)];
    }

    public static short randomFrom(Random r, short[] array) {
        RandomPicks.checkZeroLength(array.length);
        return array[r.nextInt(array.length)];
    }

    public static int randomFrom(Random r, int[] array) {
        RandomPicks.checkZeroLength(array.length);
        return array[r.nextInt(array.length)];
    }

    public static char randomFrom(Random r, char[] array) {
        RandomPicks.checkZeroLength(array.length);
        return array[r.nextInt(array.length)];
    }

    public static float randomFrom(Random r, float[] array) {
        RandomPicks.checkZeroLength(array.length);
        return array[r.nextInt(array.length)];
    }

    public static long randomFrom(Random r, long[] array) {
        RandomPicks.checkZeroLength(array.length);
        return array[r.nextInt(array.length)];
    }

    public static double randomFrom(Random r, double[] array) {
        RandomPicks.checkZeroLength(array.length);
        return array[r.nextInt(array.length)];
    }

    private static void checkZeroLength(int length) {
        if (length == 0) {
            throw new IllegalArgumentException("Can't pick a random object from an empty array.");
        }
    }

    public static <T> T randomFrom(Random r, T[] array) {
        RandomPicks.checkZeroLength(array.length);
        return array[r.nextInt(array.length)];
    }

    public static <T> T randomFrom(Random r, List<T> list) {
        if (list.size() == 0) {
            throw new IllegalArgumentException("Can't pick a random object from an empty list.");
        }
        return list.get(r.nextInt(list.size()));
    }

    public static <T> T randomFrom(Random r, Collection<T> collection) {
        int size = collection.size();
        if (size == 0) {
            throw new IllegalArgumentException("Can't pick a random object from an empty collection.");
        }
        int pick = r.nextInt(size);
        T value = null;
        Iterator<T> i = collection.iterator();
        while (true) {
            value = i.next();
            if (pick == 0) break;
            --pick;
        }
        return value;
    }
}

