/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.audio.dvi;

import com.ibm.media.codec.audio.AudioCodec;
import com.ibm.media.codec.audio.dvi.DVI;
import com.ibm.media.codec.audio.dvi.DVIState;
import com.sun.media.controls.SilenceSuppressionAdapter;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.format.AudioFormat;

public class JavaDecoder
extends AudioCodec {
    private DVIState dviState;

    public JavaDecoder() {
        this.supportedInputFormats = new AudioFormat[]{new AudioFormat("dvi/rtp")};
        this.defaultOutputFormats = new AudioFormat[]{new AudioFormat("LINEAR")};
        this.PLUGIN_NAME = "DVI Decoder";
    }

    protected Format[] getMatchingOutputFormats(Format in) {
        AudioFormat af = (AudioFormat)in;
        this.supportedOutputFormats = new AudioFormat[]{new AudioFormat("LINEAR", af.getSampleRate(), 16, af.getChannels(), 0, 1)};
        return this.supportedOutputFormats;
    }

    public void open() {
        this.dviState = new DVIState();
    }

    public void close() {
        this.dviState = null;
    }

    public int process(Buffer inputBuffer, Buffer outputBuffer) {
        int outLength = 0;
        if (!this.checkInputBuffer(inputBuffer)) {
            return 1;
        }
        if (this.isEOM(inputBuffer)) {
            this.propagateEOM(outputBuffer);
            return 0;
        }
        int channels = this.outputFormat.getChannels();
        byte[] inData = (byte[])inputBuffer.getData();
        byte[] outData = this.validateByteArraySize(outputBuffer, (inData.length - 4) * 4);
        int offset = inputBuffer.getOffset();
        int prevVal = inData[offset++] << 8;
        int n2 = offset++;
        int index = inData[offset++] & 0xFF;
        this.dviState.valprev = prevVal |= inData[n2] & 0xFF;
        this.dviState.index = index;
        DVI.decode(inData, ++offset, outData, 0, 2 * (inputBuffer.getLength() - 4), this.dviState);
        outLength = 4 * (inputBuffer.getLength() - 4);
        this.updateOutput(outputBuffer, this.outputFormat, outLength, 0);
        return 0;
    }

    public Object[] getControls() {
        if (this.controls == null) {
            this.controls = new Control[1];
            this.controls[0] = new SilenceSuppressionAdapter(this, false, false);
        }
        return this.controls;
    }
}

