/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gtpregress;

import java.io.PrintStream;
import java.util.ArrayList;
import net.sf.gogui.gtpregress.GtpRegress;
import net.sf.gogui.utils.Options;
import net.sf.gogui.utils.StringUtils;
import net.sf.gogui.version.Version;

public final class Main {
    public static void main(String[] stringArray) {
        try {
            String[] stringArray2 = new String[]{"config:", "help", "long", "output:", "verbose", "version"};
            Options options = Options.parse(stringArray, stringArray2);
            if (options.isSet("help")) {
                Main.printUsage(System.out);
                return;
            }
            if (options.isSet("version")) {
                System.out.println("GtpRegress " + Version.get());
                return;
            }
            boolean bl = options.isSet("verbose");
            boolean bl2 = options.isSet("long");
            String string = options.getString("output", "");
            ArrayList arrayList = options.getArguments();
            int n = arrayList.size();
            if (n < 2) {
                Main.printUsage(System.err);
                System.exit(-1);
            }
            String string2 = (String)arrayList.get(0);
            String[] stringArray3 = new String[n - 1];
            for (int i = 0; i < n - 1; ++i) {
                stringArray3[i] = (String)arrayList.get(i + 1);
            }
            GtpRegress gtpRegress = new GtpRegress(string2, stringArray3, string, bl2, bl);
            System.exit(gtpRegress.getResult() ? 0 : 1);
        }
        catch (Throwable throwable) {
            StringUtils.printException(throwable);
            System.exit(2);
        }
    }

    private Main() {
    }

    private static void printUsage(PrintStream printStream) {
        printStream.print("Usage: java -jar gtpregress.jar [options] program test.tst [...]\n\n-config       Config file\n-help         Display this help and exit\n-long         Longer output to standard out\n-output       Output directory\n-verbose      Log GTP stream to stderr\n-version      Display this help and exit\n");
    }
}

