/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gtpdisplay;

import java.io.PrintStream;
import java.util.ArrayList;
import net.sf.gogui.gtpdisplay.GtpDisplay;
import net.sf.gogui.gui.GuiUtils;
import net.sf.gogui.utils.Options;
import net.sf.gogui.utils.StringUtils;
import net.sf.gogui.version.Version;

public final class Main {
    public static void main(String[] stringArray) {
        try {
            String[] stringArray2 = new String[]{"config:", "fast", "help", "laf:", "verbose", "version"};
            Options options = Options.parse(stringArray, stringArray2);
            if (options.isSet("help")) {
                Main.printUsage(System.out);
                System.exit(0);
            }
            if (options.isSet("version")) {
                System.out.println("GtpDisplay " + Version.get());
                System.exit(0);
            }
            boolean bl = options.isSet("verbose");
            boolean bl2 = options.isSet("fast");
            String string = options.getString("laf", null);
            ArrayList arrayList = options.getArguments();
            if (arrayList.size() > 1) {
                Main.printUsage(System.err);
                System.exit(-1);
            }
            String string2 = null;
            if (arrayList.size() == 1) {
                string2 = (String)arrayList.get(0);
            }
            GuiUtils.initLookAndFeel(string);
            GtpDisplay gtpDisplay = new GtpDisplay(string2, bl, bl2);
            gtpDisplay.mainLoop(System.in, System.out);
            gtpDisplay.close();
        }
        catch (Throwable throwable) {
            StringUtils.printException(throwable);
            System.exit(-1);
        }
    }

    private Main() {
    }

    private static void printUsage(PrintStream printStream) {
        String string = "Usage: java -jar gtpdisplay.jar program\n\n-config       Config file\n-fast         Fast and simple graphics\n-help         Print help and exit\n-laf          Set Swing look and feel\n-verbose      Log GTP stream to stderr\n-version      Print version and exit\n";
        printStream.print(string);
    }
}

