/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.bouncycastle.tls.PskIdentity;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsHandshakeHash;
import org.bouncycastle.tls.TlsPSK;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsCryptoUtils;
import org.bouncycastle.tls.crypto.TlsHash;
import org.bouncycastle.tls.crypto.TlsHashOutputStream;
import org.bouncycastle.tls.crypto.TlsSecret;

public class OfferedPsks {
    protected final Vector identities;
    protected final Vector binders;
    protected final int bindersSize;

    public OfferedPsks(Vector vector) {
        this(vector, null, -1);
    }

    private OfferedPsks(Vector vector, Vector vector2, int n) {
        if (null == vector || vector.isEmpty()) {
            throw new IllegalArgumentException("'identities' cannot be null or empty");
        }
        if (null != vector2 && vector.size() != vector2.size()) {
            throw new IllegalArgumentException("'binders' must be the same length as 'identities' (or null)");
        }
        if (null != vector2 != n >= 0) {
            throw new IllegalArgumentException("'bindersSize' must be >= 0 iff 'binders' are present");
        }
        this.identities = vector;
        this.binders = vector2;
        this.bindersSize = n;
    }

    public Vector getBinders() {
        return this.binders;
    }

    public int getBindersSize() {
        return this.bindersSize;
    }

    public Vector getIdentities() {
        return this.identities;
    }

    public int getIndexOfIdentity(PskIdentity pskIdentity) {
        int n = this.identities.size();
        for (int i = 0; i < n; ++i) {
            if (!pskIdentity.equals(this.identities.elementAt(i))) continue;
            return i;
        }
        return -1;
    }

    public void encode(OutputStream outputStream) throws IOException {
        Object object;
        int n;
        int n2 = 0;
        for (n = 0; n < this.identities.size(); ++n) {
            object = (PskIdentity)this.identities.elementAt(n);
            n2 += ((PskIdentity)object).getEncodedLength();
        }
        TlsUtils.checkUint16(n2);
        TlsUtils.writeUint16(n2, outputStream);
        for (n = 0; n < this.identities.size(); ++n) {
            object = (PskIdentity)this.identities.elementAt(n);
            ((PskIdentity)object).encode(outputStream);
        }
        if (null != this.binders) {
            n2 = 0;
            for (n = 0; n < this.binders.size(); ++n) {
                object = (byte[])this.binders.elementAt(n);
                n2 += 1 + ((Object)object).length;
            }
            TlsUtils.checkUint16(n2);
            TlsUtils.writeUint16(n2, outputStream);
            for (n = 0; n < this.binders.size(); ++n) {
                object = (byte[])this.binders.elementAt(n);
                TlsUtils.writeOpaque8((byte[])object, outputStream);
            }
        }
    }

    static void encodeBinders(OutputStream outputStream, TlsCrypto tlsCrypto, TlsHandshakeHash tlsHandshakeHash, BindersConfig bindersConfig) throws IOException {
        TlsPSK[] tlsPSKArray = bindersConfig.psks;
        TlsSecret[] tlsSecretArray = bindersConfig.earlySecrets;
        int n = bindersConfig.bindersSize - 2;
        TlsUtils.checkUint16(n);
        TlsUtils.writeUint16(n, outputStream);
        int n2 = 0;
        for (int i = 0; i < tlsPSKArray.length; ++i) {
            TlsPSK tlsPSK = tlsPSKArray[i];
            TlsSecret tlsSecret = tlsSecretArray[i];
            boolean bl = true;
            int n3 = TlsCryptoUtils.getHashForPRF(tlsPSK.getPRFAlgorithm());
            TlsHash tlsHash = tlsCrypto.createHash(n3);
            tlsHandshakeHash.copyBufferTo(new TlsHashOutputStream(tlsHash));
            byte[] byArray = tlsHash.calculateHash();
            byte[] byArray2 = TlsUtils.calculatePSKBinder(tlsCrypto, bl, n3, tlsSecret, byArray);
            n2 += 1 + byArray2.length;
            TlsUtils.writeOpaque8(byArray2, outputStream);
        }
        if (n != n2) {
            throw new TlsFatalAlert(80);
        }
    }

    static int getBindersSize(TlsPSK[] tlsPSKArray) throws IOException {
        int n = 0;
        for (int i = 0; i < tlsPSKArray.length; ++i) {
            TlsPSK tlsPSK = tlsPSKArray[i];
            int n2 = tlsPSK.getPRFAlgorithm();
            int n3 = TlsCryptoUtils.getHashForPRF(n2);
            n += 1 + TlsCryptoUtils.getHashOutputSize(n3);
        }
        TlsUtils.checkUint16(n);
        return 2 + n;
    }

    public static OfferedPsks parse(InputStream inputStream) throws IOException {
        Object object;
        Vector<PskIdentity> vector = new Vector<PskIdentity>();
        int n = TlsUtils.readUint16(inputStream);
        if (n < 7) {
            throw new TlsFatalAlert(50);
        }
        byte[] byArray = TlsUtils.readFully(n, inputStream);
        Object object2 = new ByteArrayInputStream(byArray);
        do {
            object = PskIdentity.parse((InputStream)object2);
            vector.add((PskIdentity)object);
        } while (((ByteArrayInputStream)object2).available() > 0);
        Vector<byte[]> vector2 = new Vector<byte[]>();
        int n2 = TlsUtils.readUint16(inputStream);
        if (n2 < 33) {
            throw new TlsFatalAlert(50);
        }
        object2 = TlsUtils.readFully(n2, inputStream);
        object = new ByteArrayInputStream((byte[])object2);
        do {
            byte[] byArray2 = TlsUtils.readOpaque8((InputStream)object, 32);
            vector2.add(byArray2);
        } while (((ByteArrayInputStream)object).available() > 0);
        return new OfferedPsks(vector, vector2, 2 + n2);
    }

    static class BindersConfig {
        final TlsPSK[] psks;
        final short[] pskKeyExchangeModes;
        final TlsSecret[] earlySecrets;
        final int bindersSize;

        BindersConfig(TlsPSK[] tlsPSKArray, short[] sArray, TlsSecret[] tlsSecretArray, int n) {
            this.psks = tlsPSKArray;
            this.pskKeyExchangeModes = sArray;
            this.earlySecrets = tlsSecretArray;
            this.bindersSize = n;
        }
    }

    static class SelectedConfig {
        final int index;
        final TlsPSK psk;
        final short[] pskKeyExchangeModes;
        final TlsSecret earlySecret;

        SelectedConfig(int n, TlsPSK tlsPSK, short[] sArray, TlsSecret tlsSecret) {
            this.index = n;
            this.psk = tlsPSK;
            this.pskKeyExchangeModes = sArray;
            this.earlySecret = tlsSecret;
        }
    }
}

