/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.srtp.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import org.jitsi.srtp.crypto.OpenSslAesCipherSpi;

public final class OpenSslAesEcbCipherSpi
extends OpenSslAesCipherSpi {
    private static native long EVP_aes_128_ecb();

    private static native long EVP_aes_192_ecb();

    private static native long EVP_aes_256_ecb();

    public OpenSslAesEcbCipherSpi() {
        super("ECB");
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params != null) {
            throw new InvalidAlgorithmParameterException("ECB mode cannot use IV");
        }
        this.iv = null;
        this.doEngineInit(opmode, key);
    }

    @Override
    protected long getOpenSSLCipher(Key key) throws InvalidKeyException {
        switch (key.getEncoded().length) {
            case 16: {
                return OpenSslAesEcbCipherSpi.EVP_aes_128_ecb();
            }
            case 24: {
                return OpenSslAesEcbCipherSpi.EVP_aes_192_ecb();
            }
            case 32: {
                return OpenSslAesEcbCipherSpi.EVP_aes_256_ecb();
            }
        }
        throw new InvalidKeyException("Invalid AES key length: " + key.getEncoded().length + " bytes");
    }
}

