/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.time.Clock;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.health.Result;
import org.jitsi.nlj.DebugStateMode;
import org.jitsi.shutdown.ShutdownServiceImpl;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.VideobridgeConfig;
import org.jitsi.videobridge.colibri2.Colibri2UtilKt;
import org.jitsi.videobridge.health.JvbHealthChecker;
import org.jitsi.videobridge.load_management.JvbLoadManager;
import org.jitsi.videobridge.metrics.VideobridgeMetrics;
import org.jitsi.videobridge.shutdown.ShutdownManager;
import org.jitsi.videobridge.shutdown.ShutdownState;
import org.jitsi.videobridge.stats.PacketTransitStats;
import org.jitsi.videobridge.xmpp.XmppConnection;
import org.jitsi.xmpp.extensions.colibri2.ConferenceModifyIQ;
import org.jitsi.xmpp.extensions.health.HealthCheckIQ;
import org.jitsi.xmpp.util.ErrorUtilKt;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smackx.iqversion.packet.Version;
import org.json.simple.JSONObject;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;

public class Videobridge {
    private static final Logger logger = new LoggerImpl(Videobridge.class.getName());
    public static final Random RANDOM = new Random();
    private final Map<String, Conference> conferencesById = new HashMap<String, Conference>();
    private final Map<String, Conference> conferencesByMeetingId = new HashMap<String, Conference>();
    private final JvbHealthChecker jvbHealthChecker = new JvbHealthChecker();
    @NotNull
    private final Clock clock;
    @NotNull
    private final JvbLoadManager<?> jvbLoadManager;
    @NotNull
    private final org.jitsi.utils.version.Version version;
    @NotNull
    private final ShutdownManager shutdownManager;
    private boolean drainMode = VideobridgeConfig.Companion.getInitialDrainMode();

    public Videobridge(@Nullable XmppConnection xmppConnection, @NotNull ShutdownServiceImpl shutdownService, @NotNull org.jitsi.utils.version.Version version, @NotNull Clock clock) {
        this.clock = clock;
        this.jvbLoadManager = JvbLoadManager.create(this);
        if (xmppConnection != null) {
            xmppConnection.setEventHandler(new XmppConnectionEventHandler());
        }
        this.version = version;
        this.shutdownManager = new ShutdownManager(shutdownService, logger);
        this.jvbHealthChecker.start();
    }

    @NotNull
    public JvbHealthChecker getJvbHealthChecker() {
        return this.jvbHealthChecker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Conference doCreateConference(@Nullable EntityBareJid name, String meetingId, boolean isRtcStatsEnabled) {
        Conference conference = null;
        do {
            String id = this.generateConferenceID();
            Map<String, Conference> map = this.conferencesById;
            synchronized (map) {
                if (meetingId != null && this.conferencesByMeetingId.containsKey(meetingId)) {
                    throw new IllegalStateException("Already have a meeting with meetingId " + meetingId);
                }
                if (!this.conferencesById.containsKey(id)) {
                    conference = new Conference(this, id, name, meetingId, isRtcStatsEnabled);
                    this.conferencesById.put(id, conference);
                    VideobridgeMetrics.currentConferences.inc();
                    if (meetingId != null) {
                        this.conferencesByMeetingId.put(meetingId, conference);
                    }
                }
            }
        } while (conference == null);
        return conference;
    }

    void localEndpointCreated(boolean visitor2) {
        VideobridgeMetrics.currentLocalEndpoints.inc();
        if (visitor2) {
            VideobridgeMetrics.currentVisitors.inc();
        }
    }

    void localEndpointExpired(boolean visitor2) {
        long remainingEndpoints = VideobridgeMetrics.currentLocalEndpoints.decAndGet();
        if (visitor2) {
            VideobridgeMetrics.currentVisitors.dec();
        }
        if (remainingEndpoints < 0L) {
            logger.warn("Invalid endpoint count " + remainingEndpoints + ". Disabling endpoint-count based shutdown!");
            return;
        }
        this.shutdownManager.maybeShutdown(remainingEndpoints);
    }

    @NotNull
    private Conference createConference(@Nullable EntityBareJid name, String meetingId, boolean isRtcStatsEnabled) {
        Conference conference = this.doCreateConference(name, meetingId, isRtcStatsEnabled);
        logger.info(() -> "create_conf, id=" + conference.getID() + " meeting_id=" + meetingId);
        return conference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expireConference(Conference conference) {
        String id = conference.getID();
        String meetingId = conference.getMeetingId();
        Map<String, Conference> map = this.conferencesById;
        synchronized (map) {
            if (conference.equals(this.conferencesById.get(id))) {
                this.conferencesById.remove(id);
                VideobridgeMetrics.currentConferences.dec();
                if (meetingId != null && conference.equals(this.conferencesByMeetingId.get(meetingId))) {
                    this.conferencesByMeetingId.remove(meetingId);
                }
                conference.expire();
            }
        }
    }

    private String generateConferenceID() {
        return Long.toHexString(System.currentTimeMillis() + RANDOM.nextLong());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Conference getConference(String id) {
        Map<String, Conference> map = this.conferencesById;
        synchronized (map) {
            return this.conferencesById.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Conference getConferenceByMeetingId(@NotNull String meetingId) {
        Map<String, Conference> map = this.conferencesById;
        synchronized (map) {
            return this.conferencesByMeetingId.get(meetingId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Conference> getConferences() {
        Map<String, Conference> map = this.conferencesById;
        synchronized (map) {
            return new HashSet<Conference>(this.conferencesById.values());
        }
    }

    public IQ handleConferenceModifyIq(ConferenceModifyIQ conferenceModifyIQ) {
        Conference conference;
        try {
            conference = this.getOrCreateConference(conferenceModifyIQ);
        }
        catch (ConferenceNotFoundException e) {
            return Colibri2UtilKt.createConferenceNotFoundError(conferenceModifyIQ, conferenceModifyIQ.getMeetingId());
        }
        catch (ConferenceAlreadyExistsException e) {
            return Colibri2UtilKt.createConferenceAlreadyExistsError(conferenceModifyIQ, conferenceModifyIQ.getMeetingId());
        }
        catch (InGracefulShutdownException e) {
            return Colibri2UtilKt.createGracefulShutdownErrorResponse(conferenceModifyIQ);
        }
        catch (XmppStringprepException e) {
            return ErrorUtilKt.createError(conferenceModifyIQ, StanzaError.Condition.bad_request, "Invalid conference name (not a JID)");
        }
        return conference.handleConferenceModifyIQ(conferenceModifyIQ);
    }

    private void handleColibriRequest(XmppConnection.ColibriRequest request) {
        Conference conference;
        ConferenceModifyIQ iq = request.getRequest();
        String id = request.getRequest().getMeetingId();
        try {
            conference = this.getOrCreateConference(request.getRequest());
        }
        catch (ConferenceNotFoundException e) {
            request.getCallback().invoke(Colibri2UtilKt.createConferenceNotFoundError(iq, id));
            return;
        }
        catch (ConferenceAlreadyExistsException e) {
            request.getCallback().invoke(Colibri2UtilKt.createConferenceAlreadyExistsError(iq, id));
            return;
        }
        catch (InGracefulShutdownException e) {
            request.getCallback().invoke(Colibri2UtilKt.createGracefulShutdownErrorResponse(iq));
            return;
        }
        catch (XmppStringprepException e) {
            request.getCallback().invoke(ErrorUtilKt.createError(iq, StanzaError.Condition.bad_request, "Invalid conference name (not a JID)"));
            return;
        }
        conference.enqueueColibriRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Conference getOrCreateConference(ConferenceModifyIQ conferenceModifyIQ) throws InGracefulShutdownException, XmppStringprepException, ConferenceAlreadyExistsException, ConferenceNotFoundException {
        String meetingId = conferenceModifyIQ.getMeetingId();
        Map<String, Conference> map = this.conferencesById;
        synchronized (map) {
            Conference conference = this.getConferenceByMeetingId(meetingId);
            if (conferenceModifyIQ.getCreate()) {
                if (conference != null) {
                    logger.warn("Will not create conference, conference already exists for meetingId=" + meetingId);
                    throw new ConferenceAlreadyExistsException();
                }
                if (this.isInGracefulShutdown()) {
                    logger.warn("Will not create conference in shutdown mode.");
                    throw new InGracefulShutdownException();
                }
                String conferenceName = conferenceModifyIQ.getConferenceName();
                EntityBareJid entityBareJid = conferenceName == null ? null : JidCreate.entityBareFrom(conferenceName);
                return this.createConference(entityBareJid, meetingId, conferenceModifyIQ.isRtcstatsEnabled());
            }
            if (conference == null) {
                logger.warn("Conference with meeting_id=" + meetingId + " not found.");
                throw new ConferenceNotFoundException();
            }
            return conference;
        }
    }

    public void shutdown(boolean graceful) {
        this.shutdownManager.initiateShutdown(graceful);
        this.shutdownManager.maybeShutdown(VideobridgeMetrics.currentLocalEndpoints.get());
    }

    public void setDrainMode(boolean enable) {
        logger.info("Received drain request. enable=" + enable);
        VideobridgeMetrics.INSTANCE.getDrainMode().set(enable);
        this.drainMode = enable;
    }

    public boolean getDrainMode() {
        return this.drainMode;
    }

    public boolean isInGracefulShutdown() {
        return this.shutdownManager.getState() == ShutdownState.GRACEFUL_SHUTDOWN;
    }

    public ShutdownState getShutdownState() {
        return this.shutdownManager.getState();
    }

    void stop() {
        this.jvbLoadManager.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrderedJsonObject getDebugState(String conferenceId, String endpointId, DebugStateMode mode) {
        OrderedJsonObject debugState = new OrderedJsonObject();
        if (mode == DebugStateMode.FULL || mode == DebugStateMode.SHORT) {
            debugState.put("shutdown_state", this.shutdownManager.getState().toString());
            debugState.put("drain", (Object)this.drainMode);
            debugState.put("time", (Object)System.currentTimeMillis());
            debugState.put("load_management", this.jvbLoadManager.getStats());
            Double jitter = PacketTransitStats.getBridgeJitter();
            if (jitter != null) {
                debugState.put("overall_bridge_jitter", jitter);
            }
        }
        JSONObject conferences = new JSONObject();
        debugState.put("conferences", conferences);
        if (StringUtils.isBlank(conferenceId)) {
            this.getConferences().stream().filter(c -> mode != DebugStateMode.STATS || c.isRtcStatsEnabled()).forEach(conference -> conferences.put(conference.getID(), conference.getDebugState(mode, null)));
        } else {
            Conference conference2;
            JSONObject jSONObject = conferences;
            synchronized (jSONObject) {
                conference2 = this.conferencesById.get(conferenceId);
            }
            conferences.put(conferenceId, conference2 == null ? "null" : conference2.getDebugState(mode, endpointId));
        }
        return debugState;
    }

    @NotNull
    public org.jitsi.utils.version.Version getVersion() {
        return this.version;
    }

    private class XmppConnectionEventHandler
    implements XmppConnection.EventHandler {
        private XmppConnectionEventHandler() {
        }

        @Override
        public void colibriRequestReceived(@NotNull XmppConnection.ColibriRequest request) {
            Videobridge.this.handleColibriRequest(request);
        }

        @Override
        @NotNull
        public IQ versionIqReceived(@NotNull Version iq) {
            Version versionResult = new Version(Videobridge.this.version.getApplicationName(), Videobridge.this.version.toString(), System.getProperty("os.name"));
            versionResult.setType(IQ.Type.result);
            return versionResult;
        }

        @Override
        @NotNull
        public IQ healthCheckIqReceived(@NotNull HealthCheckIQ iq) {
            Result result = Videobridge.this.jvbHealthChecker.getResult();
            if (result.getSuccess()) {
                return IQ.createResultIQ(iq);
            }
            return IQ.createErrorResponse((IQ)iq, StanzaError.from(StanzaError.Condition.internal_server_error, result.getMessage()).build());
        }
    }

    private static class ConferenceNotFoundException
    extends Exception {
        private ConferenceNotFoundException() {
        }
    }

    private static class ConferenceAlreadyExistsException
    extends Exception {
        private ConferenceAlreadyExistsException() {
        }
    }

    private static class InGracefulShutdownException
    extends Exception {
        private InGracefulShutdownException() {
        }
    }
}

