/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.cc.av1;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.RtpLayerDesc;
import org.jitsi.nlj.rtp.codec.av1.Av1DDPacket;
import org.jitsi.nlj.rtp.codec.av1.Av1DDPacketKt;
import org.jitsi.nlj.rtp.codec.av1.Av1DDRtpLayerDesc;
import org.jitsi.rtp.rtcp.RtcpSrPacket;
import org.jitsi.rtp.rtp.header_extensions.Av1DependencyDescriptorHeaderExtension;
import org.jitsi.rtp.rtp.header_extensions.Av1DependencyDescriptorHeaderExtensionKt;
import org.jitsi.rtp.rtp.header_extensions.Av1TemplateDependencyStructure;
import org.jitsi.rtp.rtp.header_extensions.DTI;
import org.jitsi.rtp.rtp.header_extensions.FrameInfo;
import org.jitsi.rtp.util.RtpUtils;
import org.jitsi.rtp.util.RtpUtilsKt;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging.TimeSeriesLogger;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.videobridge.cc.AdaptiveSourceProjectionContext;
import org.jitsi.videobridge.cc.RewriteException;
import org.jitsi.videobridge.cc.RtpState;
import org.jitsi.videobridge.cc.av1.Av1DDFrame;
import org.jitsi.videobridge.cc.av1.Av1DDFrameMap;
import org.jitsi.videobridge.cc.av1.Av1DDFrameProjection;
import org.jitsi.videobridge.cc.av1.Av1DDQualityFilter;
import org.jitsi.videobridge.cc.av1.Av1PersistentState;
import org.jitsi.videobridge.cc.av1.PacketInsertionResult;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 J2\u00020\u0001:\u0001JB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J \u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0014\u0010%\u001a\u00020\u0017*\u00020\u001d2\u0006\u0010&\u001a\u00020\u001bH\u0002J\u0018\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020\u001dH\u0002J\u0010\u0010*\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\u001dH\u0002J\u0010\u0010+\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\u001dH\u0002J\u0012\u0010,\u001a\u0004\u0018\u00010\u001d2\u0006\u0010#\u001a\u00020\u001dH\u0002J\u0012\u0010-\u001a\u0004\u0018\u00010\u001d2\u0006\u0010#\u001a\u00020\u001dH\u0002J\u0012\u0010.\u001a\u0004\u0018\u00010\u001d2\u0006\u0010#\u001a\u00020\u001dH\u0002J\u0012\u0010/\u001a\u0004\u0018\u00010\u001d2\u0006\u0010#\u001a\u00020\u001dH\u0002JI\u00100\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u001d2\u0006\u00101\u001a\u00020\u001f2\u0006\u00102\u001a\u00020\u00172\u0006\u00103\u001a\u00020\u00172\u0006\u00104\u001a\u00020\u00172\b\u00105\u001a\u0004\u0018\u00010\u001b2\b\u00106\u001a\u0004\u0018\u000107H\u0002\u00a2\u0006\u0002\u00108J9\u00109\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u001d2\u0006\u00101\u001a\u00020\u001f2\u0006\u00102\u001a\u00020\u00172\b\u00105\u001a\u0004\u0018\u00010\u001b2\b\u00106\u001a\u0004\u0018\u000107H\u0002\u00a2\u0006\u0002\u0010:J9\u0010;\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u001d2\u0006\u00101\u001a\u00020\u001f2\u0006\u00102\u001a\u00020\u00172\b\u00105\u001a\u0004\u0018\u00010\u001b2\b\u00106\u001a\u0004\u0018\u000107H\u0002\u00a2\u0006\u0002\u0010:J9\u0010<\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u001d2\u0006\u00101\u001a\u00020\u001f2\u0006\u00102\u001a\u00020\u00172\b\u00105\u001a\u0004\u0018\u00010\u001b2\b\u00106\u001a\u0004\u0018\u000107H\u0002\u00a2\u0006\u0002\u0010:J9\u0010=\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u001d2\u0006\u00101\u001a\u00020\u001f2\u0006\u00102\u001a\u00020\u00172\b\u00105\u001a\u0004\u0018\u00010\u001b2\b\u00106\u001a\u0004\u0018\u000107H\u0002\u00a2\u0006\u0002\u0010:JA\u0010=\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u001d2\u0006\u0010>\u001a\u00020\u001d2\u0006\u00101\u001a\u00020\u001f2\u0006\u00102\u001a\u00020\u00172\b\u00105\u001a\u0004\u0018\u00010\u001b2\b\u00106\u001a\u0004\u0018\u000107H\u0002\u00a2\u0006\u0002\u0010?J\b\u0010@\u001a\u00020\u0017H\u0016J\u0010\u0010A\u001a\u00020B2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010C\u001a\u00020\u00172\u0006\u0010D\u001a\u00020EH\u0016J\b\u0010F\u001a\u00020\u0005H\u0016J\b\u0010G\u001a\u00020\u0007H\u0016J\b\u0010H\u001a\u00020IH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lorg/jitsi/videobridge/cc/av1/Av1DDAdaptiveSourceProjectionContext;", "Lorg/jitsi/videobridge/cc/AdaptiveSourceProjectionContext;", "diagnosticContext", "Lorg/jitsi/utils/logging/DiagnosticContext;", "rtpState", "Lorg/jitsi/videobridge/cc/RtpState;", "persistentState", "", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "<init>", "(Lorg/jitsi/utils/logging/DiagnosticContext;Lorg/jitsi/videobridge/cc/RtpState;Ljava/lang/Object;Lorg/jitsi/utils/logging2/Logger;)V", "logger", "av1FrameMaps", "Ljava/util/HashMap;", "", "Lorg/jitsi/videobridge/cc/av1/Av1DDFrameMap;", "av1QualityFilter", "Lorg/jitsi/videobridge/cc/av1/Av1DDQualityFilter;", "lastAv1FrameProjection", "Lorg/jitsi/videobridge/cc/av1/Av1DDFrameProjection;", "lastFrameNumberIndexResumption", "accept", "", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "targetIndex", "", "lookupAv1Frame", "Lorg/jitsi/videobridge/cc/av1/Av1DDFrame;", "av1Packet", "Lorg/jitsi/nlj/rtp/codec/av1/Av1DDPacket;", "insertPacketInMap", "Lorg/jitsi/videobridge/cc/av1/PacketInsertionResult;", "haveSubsequentNonAcceptedChain", "frame", "incomingEncoding", "partOfActiveChain", "chainIdx", "seqGap", "frame1", "frame2", "frameIsNewSsrc", "frameIsProjectable", "prevFrame", "nextFrame", "findPrevAcceptedFrame", "findNextAcceptedFrame", "createProjection", "initialPacket", "mark", "isResumption", "isReset", "newDt", "receivedTime", "Ljava/time/Instant;", "(Lorg/jitsi/videobridge/cc/av1/Av1DDFrame;Lorg/jitsi/nlj/rtp/codec/av1/Av1DDPacket;ZZZLjava/lang/Integer;Ljava/time/Instant;)Lorg/jitsi/videobridge/cc/av1/Av1DDFrameProjection;", "createEncodingSwitchProjection", "(Lorg/jitsi/videobridge/cc/av1/Av1DDFrame;Lorg/jitsi/nlj/rtp/codec/av1/Av1DDPacket;ZLjava/lang/Integer;Ljava/time/Instant;)Lorg/jitsi/videobridge/cc/av1/Av1DDFrameProjection;", "createResumptionProjection", "createResetProjection", "createInEncodingProjection", "refFrame", "(Lorg/jitsi/videobridge/cc/av1/Av1DDFrame;Lorg/jitsi/videobridge/cc/av1/Av1DDFrame;Lorg/jitsi/nlj/rtp/codec/av1/Av1DDPacket;ZLjava/lang/Integer;Ljava/time/Instant;)Lorg/jitsi/videobridge/cc/av1/Av1DDFrameProjection;", "needsKeyframe", "rewriteRtp", "", "rewriteRtcp", "rtcpSrPacket", "Lorg/jitsi/rtp/rtcp/RtcpSrPacket;", "getRtpState", "getPersistentState", "getDebugState", "Lorg/json/simple/JSONObject;", "Companion", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nAv1DDAdaptiveSourceProjectionContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Av1DDAdaptiveSourceProjectionContext.kt\norg/jitsi/videobridge/cc/av1/Av1DDAdaptiveSourceProjectionContext\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,694:1\n372#2,7:695\n1603#3,9:702\n1855#3:711\n1856#3:713\n1612#3:714\n1747#3,3:716\n1#4:712\n1#4:715\n*S KotlinDebug\n*F\n+ 1 Av1DDAdaptiveSourceProjectionContext.kt\norg/jitsi/videobridge/cc/av1/Av1DDAdaptiveSourceProjectionContext\n*L\n184#1:695,7\n194#1:702,9\n194#1:711\n194#1:713\n194#1:714\n200#1:716,3\n194#1:712\n*E\n"})
public final class Av1DDAdaptiveSourceProjectionContext
implements AdaptiveSourceProjectionContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DiagnosticContext diagnosticContext;
    @NotNull
    private final Logger logger;
    @NotNull
    private final HashMap<Long, Av1DDFrameMap> av1FrameMaps;
    @NotNull
    private final Av1DDQualityFilter av1QualityFilter;
    @NotNull
    private Av1DDFrameProjection lastAv1FrameProjection;
    private long lastFrameNumberIndexResumption;
    private static final TimeSeriesLogger timeSeriesLogger = TimeSeriesLogger.getTimeSeriesLogger(Av1DDAdaptiveSourceProjectionContext.class);

    public Av1DDAdaptiveSourceProjectionContext(@NotNull DiagnosticContext diagnosticContext, @NotNull RtpState rtpState, @Nullable Object persistentState, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter(diagnosticContext, "diagnosticContext");
        Intrinsics.checkNotNullParameter(rtpState, "rtpState");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        this.diagnosticContext = diagnosticContext;
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        this.av1FrameMaps = new HashMap();
        this.av1QualityFilter = new Av1DDQualityFilter((Map<Long, Av1DDFrameMap>)this.av1FrameMaps, this.logger);
        Object object = persistentState;
        if (!(object == null ? true : object instanceof Av1PersistentState)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Av1PersistentState av1PersistentState = persistentState instanceof Av1PersistentState ? (Av1PersistentState)persistentState : null;
        Av1PersistentState av1PersistentState2 = persistentState instanceof Av1PersistentState ? (Av1PersistentState)persistentState : null;
        this.lastAv1FrameProjection = new Av1DDFrameProjection(this.diagnosticContext, rtpState.ssrc, rtpState.maxSequenceNumber, rtpState.maxTimestamp, av1PersistentState != null ? Integer.valueOf(av1PersistentState.getFrameNumber()) : null, av1PersistentState2 != null ? Integer.valueOf(av1PersistentState2.getTemplateId()) : null);
        this.lastFrameNumberIndexResumption = -1L;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean accept(@NotNull PacketInfo packetInfo, int targetIndex) {
        block16: {
            block15: {
                Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
                packet = packetInfo.getPacket();
                if (!(packet instanceof Av1DDPacket)) {
                    this.logger.warn("Packet is not AV1 DD Packet");
                    return false;
                }
                incomingEncoding = ((Av1DDPacket)packet).getEncodingId();
                v0 = this.insertPacketInMap((Av1DDPacket)packet);
                if (v0 == null) {
                    return false;
                }
                result = v0;
                frame = result.getFrame();
                if (result.isNewFrame()) {
                    if (((Av1DDPacket)packet).isKeyframe() && this.frameIsNewSsrc(frame) && this.haveSubsequentNonAcceptedChain(frame, incomingEncoding, targetIndex)) {
                        frame.setKeyframe(false);
                    }
                    frame.setAccepted((acceptResult = this.av1QualityFilter.acceptFrame(frame, incomingEncoding, targetIndex, receivedTime = packetInfo.getReceivedTime())).getAccept() != false && this.frameIsProjectable(frame) != false);
                    if (frame.isAccepted()) {
                        projection = null;
                        try {
                            var10_11 = (Av1DDPacket)packet;
                            var11_13 = acceptResult.isResumption();
                            var12_14 = result.isReset();
                            var13_15 = acceptResult.getMark();
                            var14_16 = acceptResult.getNewDt();
                            projection = this.createProjection(frame, var10_11, var13_15, var11_13, var12_14, var14_16, receivedTime);
                        }
                        catch (Exception e) {
                            this.logger.warn("Failed to create frame projection", e);
                            frame.setAccepted(false);
                            return false;
                        }
                        frame.setProjection(projection);
                        if (RtpUtilsKt.isNewerThan(projection.getEarliestProjectedSeqNum(), this.lastAv1FrameProjection.getLatestProjectedSeqNum())) {
                            this.lastAv1FrameProjection = projection;
                        }
                    }
                }
                if (!frame.isAccepted()) ** GOTO lbl-1000
                v1 = frame.getProjection();
                v2 = v1 != null ? v1.accept((Av1DDPacket)packet) : false;
                if (!v2) break block15;
                v3 = true;
                break block16;
            }
            if (frame.getProjection() == null) ** GOTO lbl-1000
            v4 = frame.getProjection();
            if (!(v4 != null ? v4.getClosedSeq() == -1 : false)) {
                v5 = frame.getProjection();
                this.logger.debug("Not accepting " + packet + ": frame projection is closed at " + (v5 != null ? Integer.valueOf(v5.getClosedSeq()) : null));
            } else if (frame.getProjection() == null) {
                this.logger.warn("Not accepting " + packet + ": frame has no projection, even though QF accepted it");
            } else {
                this.logger.warn("Not accepting " + packet + ", even though frame projection is not closed");
            }
            v3 = false;
        }
        if (v3) {
            v6 = true;
        } else lbl-1000:
        // 2 sources

        {
            v6 = accept = false;
        }
        if (Av1DDAdaptiveSourceProjectionContext.timeSeriesLogger.isTraceEnabled()) {
            v7 = ((Av1DDPacket)packet).getDescriptor();
            v8 = ((Av1DDPacket)packet).getFrameInfo();
            v9 = ((Av1DDPacket)packet).getFrameInfo();
            v10 = ((Av1DDPacket)packet).getFrameInfo();
            pt = this.diagnosticContext.makeTimeSeriesPoint("rtp_av1").addField("ssrc", ((Av1DDPacket)packet).getSsrc()).addField("timestamp", ((Av1DDPacket)packet).getTimestamp()).addField("seq", ((Av1DDPacket)packet).getSequenceNumber()).addField("frameNumber", ((Av1DDPacket)packet).getFrameNumber()).addField("templateId", ((Av1DDPacket)packet).getStatelessDescriptor().getFrameDependencyTemplateId()).addField("hasStructure", (v7 != null ? v7.getNewTemplateDependencyStructure() : null) != null).addField("spatialLayer", v8 != null ? Integer.valueOf(v8.getSpatialId()) : null).addField("temporalLayer", v9 != null ? Integer.valueOf(v9.getTemporalId()) : null).addField("dti", (v11 = ((Av1DDPacket)packet).getFrameInfo()) != null && (v11 = v11.getDti()) != null ? Av1DependencyDescriptorHeaderExtensionKt.toShortString((List<? extends DTI>)v11) : null).addField("hasInterPictureDependency", v10 != null ? Boolean.valueOf(v10.hasInterPictureDependency()) : null).addField("targetIndex", Av1DDRtpLayerDesc.Companion.indexString(targetIndex)).addField("new_frame", result.isNewFrame()).addField("accept", accept).addField("payload_length", ((Av1DDPacket)packet).getPayloadLength()).addField("packet_length", packet.length);
            Intrinsics.checkNotNull(pt);
            this.av1QualityFilter.addDiagnosticContext$jitsi_videobridge(pt);
            Av1DDAdaptiveSourceProjectionContext.timeSeriesLogger.trace(pt);
        }
        return accept;
    }

    private final Av1DDFrame lookupAv1Frame(Av1DDPacket av1Packet) {
        Av1DDFrameMap av1DDFrameMap = this.av1FrameMaps.get(av1Packet.getSsrc());
        return av1DDFrameMap != null ? av1DDFrameMap.findFrame(av1Packet) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final PacketInsertionResult insertPacketInMap(Av1DDPacket av1Packet) {
        Object object;
        void $this$getOrPut$iv;
        Map map = this.av1FrameMaps;
        Long key$iv = av1Packet.getSsrc();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Av1DDFrameMap answer$iv = new Av1DDFrameMap(this.logger);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return ((Av1DDFrameMap)object).insertPacket(av1Packet);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean haveSubsequentNonAcceptedChain(Av1DDFrame frame, int incomingEncoding, int targetIndex) {
        void $this$mapNotNullTo$iv$iv;
        Object object;
        Av1DDFrameMap av1DDFrameMap = this.av1FrameMaps.get(frame.getSsrc());
        if (av1DDFrameMap == null) {
            return false;
        }
        Av1DDFrameMap map = av1DDFrameMap;
        Av1TemplateDependencyStructure av1TemplateDependencyStructure = frame.getStructure();
        if (av1TemplateDependencyStructure == null) {
            return false;
        }
        Av1TemplateDependencyStructure structure = av1TemplateDependencyStructure;
        Collection dtsToCheck = incomingEncoding == RtpLayerDesc.Companion.getEidFromIndex(targetIndex) ? (Collection)SetsKt.setOf(Av1DDRtpLayerDesc.Companion.getDtFromIndex(targetIndex)) : ((object = frame.getFrameInfo()) != null && (object = ((FrameInfo)object).getDtisPresent()) != null ? (Collection)object : (Collection)SetsKt.emptySet());
        Iterable $this$mapNotNull$iv = dtsToCheck;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Integer it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            int it = ((Number)element$iv$iv).intValue();
            boolean bl2 = false;
            if (CollectionsKt.getOrNull(structure.getDecodeTargetProtectedBy(), it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set chainsToCheck = CollectionsKt.toSet((List)destination$iv$iv);
        return map.nextFrameWith(frame, arg_0 -> Av1DDAdaptiveSourceProjectionContext.haveSubsequentNonAcceptedChain$lambda$3(structure, this, chainsToCheck, arg_0)) != null;
    }

    private final boolean partOfActiveChain(Av1DDFrame $this$partOfActiveChain, int chainIdx) {
        Av1TemplateDependencyStructure av1TemplateDependencyStructure = $this$partOfActiveChain.getStructure();
        if (av1TemplateDependencyStructure == null) {
            return false;
        }
        Av1TemplateDependencyStructure structure = av1TemplateDependencyStructure;
        FrameInfo frameInfo = $this$partOfActiveChain.getFrameInfo();
        if (frameInfo == null) {
            return false;
        }
        FrameInfo frameInfo2 = frameInfo;
        int n = ((Collection)structure.getDecodeTargetProtectedBy()).size();
        for (int i = 0; i < n; ++i) {
            if (((Number)structure.getDecodeTargetProtectedBy().get(i)).intValue() != chainIdx || frameInfo2.getDti().get(i) != DTI.NOT_PRESENT && frameInfo2.getDti().get(i) != DTI.DISCARDABLE) continue;
            return false;
        }
        return true;
    }

    private final int seqGap(Av1DDFrame frame1, Av1DDFrame frame2) {
        int seqGap = RtpUtils.Companion.getSequenceNumberDelta(frame2.getEarliestKnownSequenceNumber(), frame1.getLatestKnownSequenceNumber());
        if (!frame1.isAccepted() && !frame2.isAccepted() && frame2.isImmediatelyAfter(frame1)) {
            seqGap = 0;
        } else {
            if (!frame1.isAccepted() && !frame1.getSeenEndOfFrame() && seqGap > 1) {
                --seqGap;
            }
            if (!frame2.isAccepted() && !frame2.getSeenStartOfFrame() && seqGap > 1) {
                --seqGap;
            }
            if (!frame1.isAccepted() && seqGap > 0) {
                --seqGap;
            }
        }
        return seqGap;
    }

    private final boolean frameIsNewSsrc(Av1DDFrame frame) {
        Av1DDFrame av1DDFrame = this.lastAv1FrameProjection.getAv1Frame();
        return !(av1DDFrame != null ? av1DDFrame.matchesSSRC(frame) : false);
    }

    private final boolean frameIsProjectable(Av1DDFrame frame) {
        return this.frameIsNewSsrc(frame) || frame.getIndex() >= this.lastFrameNumberIndexResumption;
    }

    private final synchronized Av1DDFrame prevFrame(Av1DDFrame frame) {
        Av1DDFrameMap av1DDFrameMap = this.av1FrameMaps.get(frame.getSsrc());
        return av1DDFrameMap != null ? av1DDFrameMap.prevFrame(frame) : null;
    }

    private final synchronized Av1DDFrame nextFrame(Av1DDFrame frame) {
        Av1DDFrameMap av1DDFrameMap = this.av1FrameMaps.get(frame.getSsrc());
        return av1DDFrameMap != null ? av1DDFrameMap.nextFrame(frame) : null;
    }

    private final Av1DDFrame findPrevAcceptedFrame(Av1DDFrame frame) {
        Av1DDFrameMap av1DDFrameMap = this.av1FrameMaps.get(frame.getSsrc());
        return av1DDFrameMap != null ? av1DDFrameMap.findPrevAcceptedFrame(frame) : null;
    }

    private final Av1DDFrame findNextAcceptedFrame(Av1DDFrame frame) {
        Av1DDFrameMap av1DDFrameMap = this.av1FrameMaps.get(frame.getSsrc());
        return av1DDFrameMap != null ? av1DDFrameMap.findNextAcceptedFrame(frame) : null;
    }

    private final Av1DDFrameProjection createProjection(Av1DDFrame frame, Av1DDPacket initialPacket, boolean mark, boolean isResumption, boolean isReset, Integer newDt, Instant receivedTime) {
        if (this.frameIsNewSsrc(frame)) {
            return this.createEncodingSwitchProjection(frame, initialPacket, mark, newDt, receivedTime);
        }
        if (isResumption) {
            return this.createResumptionProjection(frame, initialPacket, mark, newDt, receivedTime);
        }
        if (isReset) {
            return this.createResetProjection(frame, initialPacket, mark, newDt, receivedTime);
        }
        return this.createInEncodingProjection(frame, initialPacket, mark, newDt, receivedTime);
    }

    /*
     * Unable to fully structure code
     */
    private final Av1DDFrameProjection createEncodingSwitchProjection(Av1DDFrame frame, Av1DDPacket initialPacket, boolean mark, Integer newDt, Instant receivedTime) {
        var6_6 = frame.isKeyframe();
        if (_Assertions.ENABLED && !var6_6) {
            var7_7 = "Assertion failed";
            throw new AssertionError((Object)var7_7);
        }
        var6_6 = initialPacket.isStartOfFrame();
        if (_Assertions.ENABLED && !var6_6) {
            var7_8 = "Assertion failed";
            throw new AssertionError((Object)var7_8);
        }
        this.lastFrameNumberIndexResumption = frame.getIndex();
        projectedSeqGap = 1;
        v0 = this.lastAv1FrameProjection.getAv1Frame();
        v1 = v0 != null ? !v0.getSeenEndOfFrame() : false;
        if (v1) {
            ++projectedSeqGap;
            this.lastAv1FrameProjection.close();
        }
        projectedSeq = RtpUtils.Companion.applySequenceNumberDelta(this.lastAv1FrameProjection.getLatestProjectedSeqNum(), projectedSeqGap);
        v2 = this.lastAv1FrameProjection.getCreated();
        if (v2 == null) ** GOTO lbl-1000
        created = v2;
        $i$a$-let-Av1DDAdaptiveSourceProjectionContext$createEncodingSwitchProjection$tsDelta$1 = false;
        v3 = receivedTime;
        if (v3 != null) {
            it = v3;
            $i$a$-let-Av1DDAdaptiveSourceProjectionContext$createEncodingSwitchProjection$tsDelta$1$1 = 0;
            v4 = (long)3000 * RangesKt.coerceAtLeast(Duration.between(created, receivedTime).dividedBy(33L).getSeconds(), 1L);
        } else {
            v4 = null;
        }
        v2 = v4;
        if (v4 != null) {
            v5 = v2.longValue();
        } else lbl-1000:
        // 2 sources

        {
            v5 = 3000L;
        }
        tsDelta = v5;
        projectedTs = RtpUtils.Companion.applyTimestampDelta(this.lastAv1FrameProjection.getTimestamp(), tsDelta);
        frameNumber = 0;
        templateIdDelta = 0;
        nextTemplateId = this.lastAv1FrameProjection.getNextTemplateId();
        if (nextTemplateId != null) {
            frameNumber = RtpUtils.Companion.applySequenceNumberDelta(this.lastAv1FrameProjection.getFrameNumber(), 1);
            structure = frame.getStructure();
            if (!(structure != null)) {
                var17_19 = "Check failed.";
                throw new IllegalStateException(var17_19.toString());
            }
            templateIdDelta = Av1DDPacketKt.getTemplateIdDelta(nextTemplateId, structure.getTemplateIdOffset());
        } else {
            frameNumber = frame.getFrameNumber();
            templateIdDelta = 0;
        }
        v6 = this.diagnosticContext;
        v7 = frame;
        v8 = this.lastAv1FrameProjection.getSsrc();
        v9 = projectedTs;
        v10 = RtpUtils.Companion.getSequenceNumberDelta(projectedSeq, initialPacket.getSequenceNumber());
        v11 = frameNumber;
        v12 = templateIdDelta;
        v13 = newDt;
        if (v13 != null) {
            $i$a$-let-Av1DDAdaptiveSourceProjectionContext$createEncodingSwitchProjection$tsDelta$1$1 = ((Number)v13).intValue();
            var26_21 = v12;
            var25_22 = v11;
            var24_23 = v10;
            var22_24 = v9;
            var20_25 = v8;
            var19_26 = v7;
            var18_27 = v6;
            $i$a$-let-Av1DDAdaptiveSourceProjectionContext$createEncodingSwitchProjection$1 = false;
            v14 = frame.getStructure();
            var27_28 = v14 != null ? Integer.valueOf(v14.getDtBitmaskForDt((int)it)) : null;
            v6 = var18_27;
            v7 = var19_26;
            v8 = var20_25;
            v9 = var22_24;
            v10 = var24_23;
            v11 = var25_22;
            v12 = var26_21;
            v15 = var27_28;
        } else {
            v15 = null;
        }
        var28_29 = receivedTime;
        var29_30 = mark;
        var30_31 = v15;
        var31_32 = v12;
        var32_33 = v11;
        var33_34 = v10;
        var34_35 = v9;
        var36_36 = v8;
        var38_37 = v7;
        var39_38 = v6;
        return new Av1DDFrameProjection(var39_38, var38_37, var36_36, var34_35, var33_34, var32_33, var31_32, var30_31, var29_30, var28_29);
    }

    /*
     * WARNING - void declaration
     */
    private final Av1DDFrameProjection createResumptionProjection(Av1DDFrame frame, Av1DDPacket initialPacket, boolean mark, Integer newDt, Instant receivedTime) {
        Integer n;
        int n2;
        this.lastFrameNumberIndexResumption = frame.getIndex();
        Av1DDFrame av1DDFrame = this.prevFrame(frame);
        Intrinsics.checkNotNull(av1DDFrame);
        Av1DDFrame lastFrame = av1DDFrame;
        Av1DDFrame av1DDFrame2 = this.lastAv1FrameProjection.getAv1Frame();
        Intrinsics.checkNotNull(av1DDFrame2);
        Av1DDFrame lastProjectedFrame = av1DDFrame2;
        long tsDelta = RtpUtils.Companion.getTimestampDiff(this.lastAv1FrameProjection.getTimestamp(), lastProjectedFrame.getTimestamp());
        long projectedTs = RtpUtils.Companion.applyTimestampDelta(frame.getTimestamp(), tsDelta);
        int projectedFrameNumber = RtpUtils.Companion.applySequenceNumberDelta(this.lastAv1FrameProjection.getFrameNumber(), 1);
        if (frame.getStructure() != null) {
            Integer nextTemplateId = this.lastAv1FrameProjection.getNextTemplateId();
            if (nextTemplateId != null) {
                Av1TemplateDependencyStructure structure = frame.getStructure();
                if (!(structure != null)) {
                    String string = "Check failed.";
                    throw new IllegalStateException(string.toString());
                }
                n2 = Av1DDPacketKt.getTemplateIdDelta(nextTemplateId, structure.getTemplateIdOffset());
            } else {
                n2 = 0;
            }
        } else {
            n2 = 0;
        }
        int templateIdDelta = n2;
        int seqGap = RtpUtils.Companion.getSequenceNumberDelta(initialPacket.getSequenceNumber(), lastFrame.getLatestKnownSequenceNumber());
        int newSeq = RtpUtils.Companion.applySequenceNumberDelta(this.lastAv1FrameProjection.getLatestProjectedSeqNum(), seqGap);
        int seqDelta = RtpUtils.Companion.getSequenceNumberDelta(newSeq, initialPacket.getSequenceNumber());
        DiagnosticContext diagnosticContext = this.diagnosticContext;
        Av1DDFrame av1DDFrame3 = frame;
        long l = this.lastAv1FrameProjection.getSsrc();
        long l2 = projectedTs;
        int n3 = seqDelta;
        int n4 = projectedFrameNumber;
        int n5 = templateIdDelta;
        Integer n6 = newDt;
        if (n6 != null) {
            void it;
            int n7 = ((Number)n6).intValue();
            int n8 = n5;
            int n9 = n4;
            int n10 = n3;
            long l3 = l2;
            long l4 = l;
            Av1DDFrame av1DDFrame4 = av1DDFrame3;
            DiagnosticContext diagnosticContext2 = diagnosticContext;
            boolean bl = false;
            Av1TemplateDependencyStructure av1TemplateDependencyStructure = frame.getStructure();
            Integer n11 = av1TemplateDependencyStructure != null ? Integer.valueOf(av1TemplateDependencyStructure.getDtBitmaskForDt((int)it)) : null;
            diagnosticContext = diagnosticContext2;
            av1DDFrame3 = av1DDFrame4;
            l = l4;
            l2 = l3;
            n3 = n10;
            n4 = n9;
            n5 = n8;
            n = n11;
        } else {
            n = null;
        }
        Instant instant = receivedTime;
        boolean bl = mark;
        Integer n12 = n;
        int n13 = n5;
        int n14 = n4;
        int n15 = n3;
        long l5 = l2;
        long l6 = l;
        Av1DDFrame av1DDFrame5 = av1DDFrame3;
        DiagnosticContext diagnosticContext3 = diagnosticContext;
        return new Av1DDFrameProjection(diagnosticContext3, av1DDFrame5, l6, l5, n15, n14, n13, n12, bl, instant);
    }

    /*
     * WARNING - void declaration
     */
    private final Av1DDFrameProjection createResetProjection(Av1DDFrame frame, Av1DDPacket initialPacket, boolean mark, Integer newDt, Instant receivedTime) {
        Integer n;
        int n2;
        Av1DDFrame av1DDFrame = this.lastAv1FrameProjection.getAv1Frame();
        Intrinsics.checkNotNull(av1DDFrame);
        Av1DDFrame lastFrame = av1DDFrame;
        int seqDelta = RtpUtils.Companion.getSequenceNumberDelta(this.lastAv1FrameProjection.getLatestProjectedSeqNum(), lastFrame.getLatestKnownSequenceNumber());
        long tsDelta = RtpUtils.Companion.getTimestampDiff(this.lastAv1FrameProjection.getTimestamp(), lastFrame.getTimestamp());
        int frameNumberDelta = RtpUtils.Companion.applySequenceNumberDelta(this.lastAv1FrameProjection.getFrameNumber(), lastFrame.getFrameNumber());
        long projectedTs = RtpUtils.Companion.applyTimestampDelta(frame.getTimestamp(), tsDelta);
        int projectedFrameNumber = RtpUtils.Companion.applySequenceNumberDelta(frame.getFrameNumber(), frameNumberDelta);
        if (frame.getStructure() != null) {
            Integer nextTemplateId = this.lastAv1FrameProjection.getNextTemplateId();
            if (nextTemplateId != null) {
                Av1TemplateDependencyStructure structure = frame.getStructure();
                if (!(structure != null)) {
                    String string = "Check failed.";
                    throw new IllegalStateException(string.toString());
                }
                n2 = Av1DDPacketKt.getTemplateIdDelta(nextTemplateId, structure.getTemplateIdOffset());
            } else {
                n2 = 0;
            }
        } else {
            n2 = 0;
        }
        int templateIdDelta = n2;
        DiagnosticContext diagnosticContext = this.diagnosticContext;
        Av1DDFrame av1DDFrame2 = frame;
        long l = this.lastAv1FrameProjection.getSsrc();
        long l2 = projectedTs;
        int n3 = seqDelta;
        int n4 = projectedFrameNumber;
        int n5 = templateIdDelta;
        Integer n6 = newDt;
        if (n6 != null) {
            void it;
            int structure = ((Number)n6).intValue();
            int n7 = n5;
            int n8 = n4;
            int n9 = n3;
            long l3 = l2;
            long l4 = l;
            Av1DDFrame av1DDFrame3 = av1DDFrame2;
            DiagnosticContext diagnosticContext2 = diagnosticContext;
            boolean bl = false;
            Av1TemplateDependencyStructure av1TemplateDependencyStructure = frame.getStructure();
            Integer n10 = av1TemplateDependencyStructure != null ? Integer.valueOf(av1TemplateDependencyStructure.getDtBitmaskForDt((int)it)) : null;
            diagnosticContext = diagnosticContext2;
            av1DDFrame2 = av1DDFrame3;
            l = l4;
            l2 = l3;
            n3 = n9;
            n4 = n8;
            n5 = n7;
            n = n10;
        } else {
            n = null;
        }
        Instant instant = receivedTime;
        boolean bl = mark;
        Integer n11 = n;
        int n12 = n5;
        int n13 = n4;
        int n14 = n3;
        long l5 = l2;
        long l6 = l;
        Av1DDFrame av1DDFrame4 = av1DDFrame2;
        DiagnosticContext diagnosticContext3 = diagnosticContext;
        return new Av1DDFrameProjection(diagnosticContext3, av1DDFrame4, l6, l5, n14, n13, n12, n11, bl, instant);
    }

    private final Av1DDFrameProjection createInEncodingProjection(Av1DDFrame frame, Av1DDPacket initialPacket, boolean mark, Integer newDt, Instant receivedTime) {
        Av1DDFrame prevFrame = this.findPrevAcceptedFrame(frame);
        if (prevFrame != null) {
            return this.createInEncodingProjection(frame, prevFrame, initialPacket, mark, newDt, receivedTime);
        }
        Av1DDFrame nextFrame = this.findNextAcceptedFrame(frame);
        if (nextFrame != null) {
            return this.createInEncodingProjection(frame, nextFrame, initialPacket, mark, newDt, receivedTime);
        }
        Av1DDFrame av1DDFrame = this.lastAv1FrameProjection.getAv1Frame();
        Intrinsics.checkNotNull(av1DDFrame);
        return this.createInEncodingProjection(frame, av1DDFrame, initialPacket, mark, newDt, receivedTime);
    }

    /*
     * WARNING - void declaration
     */
    private final Av1DDFrameProjection createInEncodingProjection(Av1DDFrame frame, Av1DDFrame refFrame, Av1DDPacket initialPacket, boolean mark, Integer newDt, Instant receivedTime) {
        Integer n;
        long tsGap = RtpUtils.Companion.getTimestampDiff(frame.getTimestamp(), refFrame.getTimestamp());
        int frameNumGap = RtpUtils.Companion.getSequenceNumberDelta(frame.getFrameNumber(), refFrame.getFrameNumber());
        int seqGap = 0;
        Av1DDFrame f1 = null;
        f1 = refFrame;
        Av1DDFrame f2 = null;
        int refSeq = 0;
        if (frameNumGap > 0) {
            do {
                if ((f2 = this.nextFrame(f1)) == null) {
                    boolean $i$a$-checkNotNull-Av1DDAdaptiveSourceProjectionContext$createInEncodingProjection$32 = false;
                    String $i$a$-checkNotNull-Av1DDAdaptiveSourceProjectionContext$createInEncodingProjection$32 = "No next frame found after frame with frame number " + f1.getFrameNumber() + ", even though refFrame " + refFrame.getFrameNumber() + " is before frame " + frame.getFrameNumber() + "!";
                    throw new IllegalStateException($i$a$-checkNotNull-Av1DDAdaptiveSourceProjectionContext$createInEncodingProjection$32.toString());
                }
                seqGap += this.seqGap(f1, f2);
                f1 = f2;
            } while (f2 != frame);
            Av1DDFrameProjection av1DDFrameProjection = refFrame.getProjection();
            Intrinsics.checkNotNull(av1DDFrameProjection);
            refSeq = av1DDFrameProjection.getLatestProjectedSeqNum();
        } else {
            do {
                if ((f2 = this.prevFrame(f1)) == null) {
                    boolean $i$a$-checkNotNull-Av1DDAdaptiveSourceProjectionContext$createInEncodingProjection$42 = false;
                    String $i$a$-checkNotNull-Av1DDAdaptiveSourceProjectionContext$createInEncodingProjection$42 = "No previous frame found before frame with frame number " + f1.getFrameNumber() + ", even though refFrame " + refFrame.getFrameNumber() + " is after frame " + frame.getFrameNumber() + "!";
                    throw new IllegalStateException($i$a$-checkNotNull-Av1DDAdaptiveSourceProjectionContext$createInEncodingProjection$42.toString());
                }
                seqGap += -this.seqGap(f2, f1);
                f1 = f2;
            } while (f2 != frame);
            Av1DDFrameProjection av1DDFrameProjection = refFrame.getProjection();
            Intrinsics.checkNotNull(av1DDFrameProjection);
            refSeq = av1DDFrameProjection.getEarliestProjectedSeqNum();
        }
        int projectedSeq = RtpUtils.Companion.applySequenceNumberDelta(refSeq, seqGap);
        Av1DDFrameProjection av1DDFrameProjection = refFrame.getProjection();
        Intrinsics.checkNotNull(av1DDFrameProjection);
        long projectedTs = RtpUtils.Companion.applyTimestampDelta(av1DDFrameProjection.getTimestamp(), tsGap);
        Av1DDFrameProjection av1DDFrameProjection2 = refFrame.getProjection();
        Intrinsics.checkNotNull(av1DDFrameProjection2);
        int projectedFrameNumber = RtpUtils.Companion.applySequenceNumberDelta(av1DDFrameProjection2.getFrameNumber(), frameNumGap);
        DiagnosticContext diagnosticContext = this.diagnosticContext;
        Av1DDFrame av1DDFrame = frame;
        long l = this.lastAv1FrameProjection.getSsrc();
        long l2 = projectedTs;
        int n2 = RtpUtils.Companion.getSequenceNumberDelta(projectedSeq, initialPacket.getSequenceNumber());
        int n3 = projectedFrameNumber;
        int n4 = this.lastAv1FrameProjection.getTemplateIdDelta();
        Integer n5 = newDt;
        if (n5 != null) {
            void it;
            int n6 = ((Number)n5).intValue();
            int n7 = n4;
            int n8 = n3;
            int n9 = n2;
            long l3 = l2;
            long l4 = l;
            Av1DDFrame av1DDFrame2 = av1DDFrame;
            DiagnosticContext diagnosticContext2 = diagnosticContext;
            boolean bl = false;
            Av1TemplateDependencyStructure av1TemplateDependencyStructure = frame.getStructure();
            Integer n10 = av1TemplateDependencyStructure != null ? Integer.valueOf(av1TemplateDependencyStructure.getDtBitmaskForDt((int)it)) : null;
            diagnosticContext = diagnosticContext2;
            av1DDFrame = av1DDFrame2;
            l = l4;
            l2 = l3;
            n2 = n9;
            n3 = n8;
            n4 = n7;
            n = n10;
        } else {
            n = null;
        }
        Instant instant = receivedTime;
        boolean bl = mark;
        Integer n11 = n;
        int n12 = n4;
        int n13 = n3;
        int n14 = n2;
        long l5 = l2;
        long l6 = l;
        Av1DDFrame av1DDFrame3 = av1DDFrame;
        DiagnosticContext diagnosticContext3 = diagnosticContext;
        return new Av1DDFrameProjection(diagnosticContext3, av1DDFrame3, l6, l5, n14, n13, n12, n11, bl, instant);
    }

    @Override
    public boolean needsKeyframe() {
        if (this.av1QualityFilter.getNeedsKeyframe()) {
            return true;
        }
        return this.lastAv1FrameProjection.getAv1Frame() == null;
    }

    @Override
    public void rewriteRtp(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        if (!(packetInfo.getPacket() instanceof Av1DDPacket)) {
            this.logger.info("Got a non-AV1 DD packet.");
            throw new RewriteException("Non-AV1 DD packet in AV1 DD source projection");
        }
        Av1DDPacket av1Packet = (Av1DDPacket)packetInfo.packetAs();
        Av1DDFrame av1DDFrame = this.lookupAv1Frame(av1Packet);
        if (av1DDFrame == null) {
            throw new RewriteException("Frame not in tracker (aged off?)");
        }
        Av1DDFrame av1Frame = av1DDFrame;
        Av1DDFrameProjection av1DDFrameProjection = av1Frame.getProjection();
        if (av1DDFrameProjection == null) {
            throw new RewriteException("Frame does not have projection?");
        }
        Av1DDFrameProjection av1Projection = av1DDFrameProjection;
        this.logger.trace(() -> Av1DDAdaptiveSourceProjectionContext.rewriteRtp$lambda$12(av1Packet));
        av1Projection.rewriteRtp(av1Packet);
    }

    @Override
    public boolean rewriteRtcp(@NotNull RtcpSrPacket rtcpSrPacket) {
        Intrinsics.checkNotNullParameter(rtcpSrPacket, "rtcpSrPacket");
        Av1DDFrameProjection lastAv1FrameProjectionCopy = this.lastAv1FrameProjection;
        Av1DDFrame av1DDFrame = lastAv1FrameProjectionCopy.getAv1Frame();
        if (!(av1DDFrame != null ? rtcpSrPacket.getSenderSsrc() == av1DDFrame.getSsrc() : false)) {
            return false;
        }
        rtcpSrPacket.setSenderSsrc(lastAv1FrameProjectionCopy.getSsrc());
        long srcTs = rtcpSrPacket.getSenderInfo().getRtpTimestamp();
        long delta = RtpUtils.Companion.getTimestampDiff(lastAv1FrameProjectionCopy.getTimestamp(), lastAv1FrameProjectionCopy.getAv1Frame().getTimestamp());
        long dstTs = RtpUtils.Companion.applyTimestampDelta(srcTs, delta);
        if (srcTs != dstTs) {
            rtcpSrPacket.getSenderInfo().setRtpTimestamp(dstTs);
        }
        return true;
    }

    @Override
    @NotNull
    public RtpState getRtpState() {
        return new RtpState(this.lastAv1FrameProjection.getSsrc(), this.lastAv1FrameProjection.getLatestProjectedSeqNum(), this.lastAv1FrameProjection.getTimestamp());
    }

    @Override
    @NotNull
    public Object getPersistentState() {
        Integer n = this.lastAv1FrameProjection.getNextTemplateId();
        return new Av1PersistentState(this.lastAv1FrameProjection.getFrameNumber(), n != null ? n : 0);
    }

    @Override
    @NotNull
    public JSONObject getDebugState() {
        JSONObject debugState = new JSONObject();
        ((Map)debugState).put("class", Av1DDAdaptiveSourceProjectionContext.class.getSimpleName());
        JSONArray mapSizes = new JSONArray();
        Iterator<Map.Entry<Long, Av1DDFrameMap>> iterator2 = this.av1FrameMaps.entrySet().iterator();
        while (iterator2.hasNext()) {
            Av1DDFrameMap value2;
            Long key;
            Map.Entry<Long, Av1DDFrameMap> entry;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            Intrinsics.checkNotNullExpressionValue(entry.getKey(), "component1(...)");
            Intrinsics.checkNotNullExpressionValue(entry.getValue(), "component2(...)");
            JSONObject sizeInfo = new JSONObject();
            ((Map)sizeInfo).put("ssrc", key);
            ((Map)sizeInfo).put("size", value2.size());
            mapSizes.add(sizeInfo);
        }
        ((Map)debugState).put("av1FrameMaps", mapSizes);
        ((Map)debugState).put("av1QualityFilter", this.av1QualityFilter.getDebugState());
        return debugState;
    }

    private static final boolean haveSubsequentNonAcceptedChain$lambda$3(Av1TemplateDependencyStructure $structure, Av1DDAdaptiveSourceProjectionContext this$0, Set $chainsToCheck, Av1DDFrame it) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter($structure, "$structure");
            Intrinsics.checkNotNullParameter(this$0, "this$0");
            Intrinsics.checkNotNullParameter($chainsToCheck, "$chainsToCheck");
            Intrinsics.checkNotNullParameter(it, "it");
            if (it.isAccepted()) {
                return false;
            }
            if (it.getFrameInfo() == null) {
                it.updateParse($structure, this$0.logger);
            }
            Iterable $this$any$iv = $chainsToCheck;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    int chainIdx = ((Number)element$iv).intValue();
                    boolean bl2 = false;
                    if (!this$0.partOfActiveChain(it, chainIdx)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final String rewriteRtp$lambda$12(Av1DDPacket $av1Packet) {
        Intrinsics.checkNotNullParameter($av1Packet, "$av1Packet");
        Av1DependencyDescriptorHeaderExtension av1DependencyDescriptorHeaderExtension = $av1Packet.getDescriptor();
        return "Rewriting packet with structure " + System.identityHashCode(av1DependencyDescriptorHeaderExtension != null ? av1DependencyDescriptorHeaderExtension.getStructure() : null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jitsi/videobridge/cc/av1/Av1DDAdaptiveSourceProjectionContext$Companion;", "", "<init>", "()V", "timeSeriesLogger", "Lorg/jitsi/utils/logging/TimeSeriesLogger;", "kotlin.jvm.PlatformType", "Lorg/jitsi/utils/logging/TimeSeriesLogger;", "jitsi-videobridge"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

