/*
 * Decompiled with CFR 0.152.
 */
package org.xeustechnologies.jcl.proxy;

import java.lang.reflect.Method;
import java.util.ArrayList;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.xeustechnologies.jcl.JclUtils;
import org.xeustechnologies.jcl.proxy.ProxyProvider;

public class CglibProxyProvider
implements ProxyProvider {
    @Override
    public Object createProxy(Object object, Class superClass, Class[] interfaces, ClassLoader cl) {
        CglibProxyHandler handler = new CglibProxyHandler(object);
        Enhancer enhancer = new Enhancer();
        if (superClass != null) {
            enhancer.setSuperclass(superClass);
        }
        enhancer.setCallback(handler);
        if (interfaces != null) {
            ArrayList<Class> il = new ArrayList<Class>();
            for (Class i : interfaces) {
                if (!i.isInterface()) continue;
                il.add(i);
            }
            enhancer.setInterfaces(il.toArray(new Class[il.size()]));
        }
        enhancer.setClassLoader(cl == null ? JclUtils.class.getClassLoader() : cl);
        return enhancer.create();
    }

    private class CglibProxyHandler
    implements MethodInterceptor {
        private final Object delegate;

        public CglibProxyHandler(Object delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object intercept(Object obj, Method method, Object[] args2, MethodProxy proxy) throws Throwable {
            Method delegateMethod = this.delegate.getClass().getMethod(method.getName(), method.getParameterTypes());
            return delegateMethod.invoke(this.delegate, args2);
        }
    }
}

