/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zvtm.lens;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.View;
import com.xerox.VTM.engine.ViewPanel;
import com.xerox.VTM.engine.VirtualSpaceManager;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;

public abstract class Lens {
    public static float MM_FLOOR = 0.001f;
    ViewPanel owningView;
    protected Integer ID;
    public int w;
    public int h;
    public int sw;
    public int sh;
    public int mbw;
    public int mbh;
    public int lx = 0;
    public int ly = 0;
    boolean initialized = false;
    public int lensWidth = 0;
    public int lensHeight = 0;
    public BufferedImage mbi;
    public Graphics2D magnifiedGraphics;
    int imageType = 3;
    int transferType = 3;
    int[] oPixelsI;
    int[] mPixelsI;
    int[] tPixelsI;
    short[] oPixelsS;
    short[] mPixelsS;
    short[] tPixelsS;
    byte[] oPixelsB;
    byte[] mPixelsB;
    byte[] tPixelsB;
    float[] gain = new float[2];
    int[] lurd = new int[4];
    public float MM = 2.0f;
    protected float mSwitchThreshold = 1.0f;

    public abstract void setLensBuffer(ViewPanel var1);

    public abstract void gf(float var1, float var2, float[] var3);

    public void setMaximumMagnification(float mm) {
        this.setMaximumMagnification(mm, true);
    }

    public void setMaximumMagnification(float mm, boolean forceRaster) {
        this.MM = mm;
        this.updateMagBufferWorkingDimensions();
        if (forceRaster) {
            this.setMagRasterDimensions(this.mbw, this.mbh);
        }
        this.owningView.parent.repaintNow();
    }

    public float getMaximumMagnification() {
        return this.MM;
    }

    public void setBufferThreshold(float t) {
        this.mSwitchThreshold = t;
        this.owningView.parent.repaintNow();
    }

    public float getBufferThreshold() {
        return this.mSwitchThreshold;
    }

    public void setID(Integer id) {
        this.ID = id;
    }

    public Integer getID() {
        return this.ID;
    }

    void initBuffers(int mainBufferSize, int magBufferSize) {
        switch (this.transferType) {
            case 3: {
                this.oPixelsI = new int[mainBufferSize];
                this.mPixelsI = new int[magBufferSize];
                this.tPixelsI = new int[mainBufferSize];
                this.initialized = true;
                break;
            }
            case 1: {
                this.oPixelsS = new short[mainBufferSize];
                this.mPixelsS = new short[magBufferSize];
                this.tPixelsS = new short[mainBufferSize];
                this.initialized = true;
                break;
            }
            case 0: {
                this.oPixelsB = new byte[mainBufferSize];
                this.mPixelsB = new byte[magBufferSize];
                this.tPixelsB = new byte[mainBufferSize];
                this.initialized = true;
                break;
            }
            case 2: {
                this.oPixelsS = new short[mainBufferSize];
                this.mPixelsS = new short[magBufferSize];
                this.tPixelsS = new short[mainBufferSize];
                this.initialized = true;
                break;
            }
            default: {
                this.oPixelsI = new int[mainBufferSize];
                this.mPixelsI = new int[magBufferSize];
                this.tPixelsI = new int[mainBufferSize];
                this.initialized = true;
            }
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void transform(BufferedImage sbi) {
        block8: {
            try {
                switch (this.transferType) {
                    case 3: {
                        this.transformI(sbi.getRaster(), this.mbi.getRaster());
                        break;
                    }
                    case 1: {
                        this.transformS(sbi.getRaster(), this.mbi.getRaster());
                        break;
                    }
                    case 0: {
                        this.transformB(sbi.getRaster(), this.mbi.getRaster());
                        break;
                    }
                    case 2: {
                        this.transformS(sbi.getRaster(), this.mbi.getRaster());
                        break;
                    }
                    default: {
                        this.transformI(sbi.getRaster(), this.mbi.getRaster());
                        break;
                    }
                }
            }
            catch (Exception ex) {
                if (!VirtualSpaceManager.debugModeON()) break block8;
                System.err.println("Lens error probably due to an unsupported screen color depth.");
                ex.printStackTrace();
            }
        }
    }

    abstract void transformI(WritableRaster var1, WritableRaster var2);

    abstract void transformS(WritableRaster var1, WritableRaster var2);

    abstract void transformB(WritableRaster var1, WritableRaster var2);

    public abstract void setAbsolutePosition(int var1, int var2);

    public abstract int getRadius();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateMagBufferWorkingDimensions() {
        Lens lens = this;
        synchronized (lens) {
            this.mbw = Math.round((float)(2 * this.getRadius()) * this.MM);
            this.mbh = Math.round((float)(2 * this.getRadius()) * this.MM);
        }
    }

    public void setMagRasterDimensions(int size) {
        this.setMagRasterDimensions(size, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMagRasterDimensions(int w, int h) {
        Lens lens = this;
        synchronized (lens) {
            switch (this.transferType) {
                case 3: {
                    this.mPixelsI = new int[w * h];
                    break;
                }
                case 1: {
                    this.mPixelsS = new short[w * h];
                    break;
                }
                case 0: {
                    this.mPixelsB = new byte[w * h];
                    break;
                }
                case 2: {
                    this.mPixelsS = new short[w * h];
                    break;
                }
                default: {
                    this.mPixelsI = new int[w * h];
                }
            }
            this.mbi = new BufferedImage(w, h, this.imageType);
            this.magnifiedGraphics = this.mbi.createGraphics();
        }
    }

    public void resetMagnificationBuffer() {
        if (this.mbi != null) {
            this.mbi.flush();
            this.mbi = null;
        }
        if (this.magnifiedGraphics != null) {
            this.magnifiedGraphics.dispose();
            this.magnifiedGraphics = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Graphics2D getMagnificationGraphics() {
        Lens lens = this;
        synchronized (lens) {
            if (this.mbi == null) {
                this.mbi = new BufferedImage(this.mbw, this.mbh, this.imageType);
            }
            if (this.magnifiedGraphics == null) {
                this.magnifiedGraphics = this.mbi.createGraphics();
            }
            return this.magnifiedGraphics;
        }
    }

    public void dispose() {
        this.resetMagnificationBuffer();
    }

    public View getOwningView() {
        return this.owningView.parent;
    }

    public long[] getVisibleRegion(Camera c, long[] res) {
        float uncoef = (c.focal + c.altitude) / c.focal;
        res[0] = (long)((float)c.posx + (float)(this.lx - this.lensWidth / 2) * uncoef);
        res[1] = (long)((float)c.posy + (float)(-this.ly + this.lensHeight / 2) * uncoef);
        res[2] = (long)((float)c.posx + (float)(this.lx + this.lensWidth / 2) * uncoef);
        res[3] = (long)((float)c.posy + (float)(-this.ly - this.lensHeight / 2) * uncoef);
        return res;
    }

    public void drawBoundary(Graphics2D g2d) {
    }
}

