/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jrcs.rcs;

import java.util.List;
import org.apache.commons.jrcs.diff.PatchFailedException;
import org.apache.commons.jrcs.rcs.BranchNode;
import org.apache.commons.jrcs.rcs.BranchNotFoundException;
import org.apache.commons.jrcs.rcs.InvalidFileFormatException;
import org.apache.commons.jrcs.rcs.InvalidTrunkVersionNumberException;
import org.apache.commons.jrcs.rcs.Line;
import org.apache.commons.jrcs.rcs.Node;
import org.apache.commons.jrcs.rcs.NodeNotFoundException;
import org.apache.commons.jrcs.rcs.Version;

class TrunkNode
extends Node {
    TrunkNode(TrunkNode trunkNode) {
        super(trunkNode);
    }

    TrunkNode(Version version, TrunkNode trunkNode) throws InvalidTrunkVersionNumberException {
        super(version, trunkNode);
        if (version.size() > 2) {
            throw new InvalidTrunkVersionNumberException(version);
        }
    }

    public void setRCSNext(Node node) {
        super.setRCSNext(node);
        if (this.getParent() != null) {
            this.getParent().child = null;
        }
        this.parent = node;
        if (this.getParent() != null) {
            this.getParent().child = this;
        }
    }

    public Node deltaRevision() {
        return this.getChild() != null ? this.getChild() : this;
    }

    public Node nextInPathTo(Version version, boolean bl) throws NodeNotFoundException {
        Version version2 = version.getBase(2);
        if (this.version.isLessThan(version2)) {
            if (bl) {
                return null;
            }
            throw new NodeNotFoundException(version);
        }
        Version version3 = this.version.getBase(version2.size());
        if (version3.isGreaterThan(version2)) {
            return this.getParent();
        }
        if (version.size() > this.version.size()) {
            BranchNode branchNode = this.getBranch(version.at(this.version.size()));
            if (branchNode != null || bl) {
                return branchNode;
            }
            throw new BranchNotFoundException(version.getBase(this.version.size() + 1));
        }
        return null;
    }

    protected void patch0(List list, boolean bl) throws InvalidFileFormatException, NodeNotFoundException, PatchFailedException {
        for (int i = 0; i < this.getText().length; ++i) {
            list.add(new Line(this, this.getText()[i]));
        }
    }

    void newpatch0(List list, Node node) {
        for (int i = 0; i < this.text.length; ++i) {
            list.add(new Line(node, this.text[i]));
        }
    }
}

