/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram;

import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.util.DiagramUtils;
import com.intellij.openapi.util.Key;
import com.intellij.pom.Navigatable;
import gnu.trove.THashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiagramNodeBase<T>
implements DiagramNode<T>,
Navigatable {
    private String qualifiedName;
    private int hashCode;
    private final DiagramProvider<T> myProvider;
    private final THashMap myUserData;

    public DiagramNodeBase(@NotNull DiagramProvider<T> provider) {
        if (provider == null) {
            DiagramNodeBase.$$$reportNull$$$0(0);
        }
        this.qualifiedName = null;
        this.hashCode = 0;
        this.myUserData = new THashMap();
        this.myProvider = provider;
    }

    @Override
    @NotNull
    public final DiagramProvider<T> getProvider() {
        DiagramProvider<T> diagramProvider = this.myProvider;
        if (diagramProvider == null) {
            DiagramNodeBase.$$$reportNull$$$0(1);
        }
        return diagramProvider;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiagramNodeBase that = (DiagramNodeBase)o;
        String thatFQN = that.getFQN();
        String fqn = this.getFQN();
        return fqn != null && fqn.length() > 0 && fqn.equals(thatFQN);
    }

    public int hashCode() {
        String fqn = this.getFQN();
        if (fqn == null) {
            return 0;
        }
        if (this.hashCode == 0) {
            this.hashCode = fqn.hashCode();
        }
        return this.hashCode;
    }

    protected String getFQN() {
        if (this.qualifiedName == null) {
            this.qualifiedName = this.getProvider().getVfsResolver().getQualifiedName(this.getIdentifyingElement());
        }
        return this.qualifiedName;
    }

    public void navigate(boolean requestFocus) {
        DiagramUtils.navigateTo(this);
    }

    public boolean canNavigate() {
        return true;
    }

    public boolean canNavigateToSource() {
        return false;
    }

    public <Type> Type getUserData(@NotNull Key<Type> key) {
        if (key == null) {
            DiagramNodeBase.$$$reportNull$$$0(2);
        }
        return (Type)this.myUserData.get(key);
    }

    public <Type> void putUserData(@NotNull Key<Type> key, @Nullable Type value) {
        if (key == null) {
            DiagramNodeBase.$$$reportNull$$$0(3);
        }
        this.myUserData.put(key, value);
    }

    public String toString() {
        return this.getTooltip();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/DiagramNodeBase";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/DiagramNodeBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

