/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.jdbc;

import java.sql.Driver;
import java.util.Properties;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.Sqlite;
import org.jetbrains.dekaf.exceptions.DBInitializationException;
import org.jetbrains.dekaf.exceptions.DBPreparingException;
import org.jetbrains.dekaf.jdbc.BaseExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateRdbmsProvider;
import org.jetbrains.dekaf.jdbc.SqliteExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.SqliteIntermediateFacade;

public class SqliteIntermediateProvider
extends JdbcIntermediateRdbmsProvider {
    public static final SqliteIntermediateProvider INSTANCE = new SqliteIntermediateProvider();
    static final Pattern SQLITE_CONNECTION_STRING_PATTERN = Pattern.compile("^jdbc:sqlite:.+$");
    static final String SQLITE_CONNECTION_STRING_EXAMPLE = "jdbc:sqlite:memory";
    private static final String SQLITE_DRIVER_CLASS_NAME = "org.sqlite.JDBC";

    @Override
    @NotNull
    protected String getConnectionStringExample() {
        return SQLITE_CONNECTION_STRING_EXAMPLE;
    }

    @Override
    protected Driver loadDriver(String connectionString) {
        Driver driver;
        Class<Driver> driverClass = this.getSimpleAccessibleDriverClass(SQLITE_DRIVER_CLASS_NAME);
        if (driverClass == null) {
            // empty if block
        }
        if (driverClass == null) {
            throw new DBInitializationException("Sqlite SQL Driver class not found");
        }
        try {
            driver = driverClass.newInstance();
        }
        catch (Exception e) {
            throw new DBPreparingException("Failed to instantiate driver: " + e.getMessage(), e);
        }
        return driver;
    }

    @Override
    @NotNull
    public Rdbms rdbms() {
        return Sqlite.RDBMS;
    }

    @Override
    @NotNull
    public Pattern connectionStringPattern() {
        return SQLITE_CONNECTION_STRING_PATTERN;
    }

    @Override
    public byte specificity() {
        return 10;
    }

    @Override
    @NotNull
    protected SqliteIntermediateFacade instantiateFacade(@NotNull String connectionString, @Nullable Properties connectionProperties, int connectionsLimit, @NotNull Driver driver) {
        return new SqliteIntermediateFacade(connectionString, connectionProperties, driver, connectionsLimit, SqliteExceptionRecognizer.INSTANCE);
    }

    @Override
    @NotNull
    public BaseExceptionRecognizer getExceptionRecognizer() {
        return SqliteExceptionRecognizer.INSTANCE;
    }
}

