/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.editor.CsvTableFileEditor;
import com.intellij.database.editor.SqlInsertsTableFileEditor;
import com.intellij.database.vfs.fragment.CsvTableDataFragmentFile;
import com.intellij.database.vfs.fragment.SqlTableDataFragmentFile;
import com.intellij.database.vfs.fragment.TableDataFragmentFile;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.WeighedFileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sql.dialects.SqlLanguageDialect;
import org.jetbrains.annotations.NotNull;

public class FragmentTableFileEditorProvider
extends WeighedFileEditorProvider {
    private static final String TYPE_ID = "table-data-fragment-editor";

    public static void openFragmentEditor(@NotNull Project project, @NotNull VirtualFile file, @NotNull TextRange range, @NotNull CsvFormat format) {
        if (project == null) {
            FragmentTableFileEditorProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            FragmentTableFileEditorProvider.$$$reportNull$$$0(1);
        }
        if (range == null) {
            FragmentTableFileEditorProvider.$$$reportNull$$$0(2);
        }
        if (format == null) {
            FragmentTableFileEditorProvider.$$$reportNull$$$0(3);
        }
        FragmentTableFileEditorProvider.openFragmentEditor(project, new CsvTableDataFragmentFile(file, range, format));
    }

    public static void openFragmentEditor(@NotNull Project project, @NotNull VirtualFile file, @NotNull TextRange range, @NotNull SqlLanguageDialect dialect) {
        if (project == null) {
            FragmentTableFileEditorProvider.$$$reportNull$$$0(4);
        }
        if (file == null) {
            FragmentTableFileEditorProvider.$$$reportNull$$$0(5);
        }
        if (range == null) {
            FragmentTableFileEditorProvider.$$$reportNull$$$0(6);
        }
        if (dialect == null) {
            FragmentTableFileEditorProvider.$$$reportNull$$$0(7);
        }
        FragmentTableFileEditorProvider.openFragmentEditor(project, new SqlTableDataFragmentFile(file, range, dialect));
    }

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            FragmentTableFileEditorProvider.$$$reportNull$$$0(8);
        }
        if (file == null) {
            FragmentTableFileEditorProvider.$$$reportNull$$$0(9);
        }
        return file instanceof TableDataFragmentFile;
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            FragmentTableFileEditorProvider.$$$reportNull$$$0(10);
        }
        if (file == null) {
            FragmentTableFileEditorProvider.$$$reportNull$$$0(11);
        }
        FileEditor fileEditor = FragmentTableFileEditorProvider.createEditor(project, (TableDataFragmentFile)file);
        if (fileEditor == null) {
            FragmentTableFileEditorProvider.$$$reportNull$$$0(12);
        }
        return fileEditor;
    }

    @NotNull
    public String getEditorTypeId() {
        if (TYPE_ID == null) {
            FragmentTableFileEditorProvider.$$$reportNull$$$0(13);
        }
        return TYPE_ID;
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        FileEditorPolicy fileEditorPolicy = FileEditorPolicy.HIDE_DEFAULT_EDITOR;
        if (fileEditorPolicy == null) {
            FragmentTableFileEditorProvider.$$$reportNull$$$0(14);
        }
        return fileEditorPolicy;
    }

    private static void openFragmentEditor(@NotNull Project project, @NotNull TableDataFragmentFile fragmentFile) {
        if (project == null) {
            FragmentTableFileEditorProvider.$$$reportNull$$$0(15);
        }
        if (fragmentFile == null) {
            FragmentTableFileEditorProvider.$$$reportNull$$$0(16);
        }
        EditorWindow window = FileEditorManagerEx.getInstanceEx((Project)project).getCurrentWindow();
        window.split(0, true, (VirtualFile)fragmentFile, true);
    }

    @NotNull
    private static FileEditor createEditor(@NotNull Project project, @NotNull TableDataFragmentFile fragmentFile) {
        if (project == null) {
            FragmentTableFileEditorProvider.$$$reportNull$$$0(17);
        }
        if (fragmentFile == null) {
            FragmentTableFileEditorProvider.$$$reportNull$$$0(18);
        }
        if (fragmentFile instanceof SqlTableDataFragmentFile) {
            SqlInsertsTableFileEditor sqlInsertsTableFileEditor = new SqlInsertsTableFileEditor(project, (SqlTableDataFragmentFile)fragmentFile);
            if (sqlInsertsTableFileEditor == null) {
                FragmentTableFileEditorProvider.$$$reportNull$$$0(19);
            }
            return sqlInsertsTableFileEditor;
        }
        if (fragmentFile instanceof CsvTableDataFragmentFile) {
            CsvTableFileEditor csvTableFileEditor = new CsvTableFileEditor(project, (CsvTableDataFragmentFile)fragmentFile);
            if (csvTableFileEditor == null) {
                FragmentTableFileEditorProvider.$$$reportNull$$$0(20);
            }
            return csvTableFileEditor;
        }
        throw new AssertionError((Object)fragmentFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/editor/FragmentTableFileEditorProvider";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragmentFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/editor/FragmentTableFileEditorProvider";
                break;
            }
            case 12: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorTypeId";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPolicy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "openFragmentEditor";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 10: 
            case 11: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

