/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.utils;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.JBUI;
import java.awt.DisplayMode;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;

public class StatisticCollector {
    private final Project project;

    public StatisticCollector(Project project) {
        this.project = project;
    }

    private static String logCustomPlugins() {
        PluginManagerCore.getDisabledPlugins();
        IdeaPluginDescriptor[] ourPlugins = PluginManagerCore.getPlugins();
        ArrayList<String> loadedCustom = new ArrayList<String>();
        ArrayList<String> disabled = new ArrayList<String>();
        String SPECIAL_IDEA_PLUGIN = "IDEA CORE";
        for (IdeaPluginDescriptor descriptor : ourPlugins) {
            String version = descriptor.getVersion();
            String s = descriptor.getName() + (version != null ? " (" + version + ")" : "");
            if (descriptor.isEnabled()) {
                if (descriptor.isBundled() || SPECIAL_IDEA_PLUGIN.equals(descriptor.getName())) continue;
                loadedCustom.add(s);
                continue;
            }
            disabled.add(s);
        }
        return "Custom plugins: " + loadedCustom + '\n' + "Disabled plugins:" + disabled + '\n';
    }

    private static String getSystemInfo() {
        ApplicationInfoImpl appInfo = (ApplicationInfoImpl)ApplicationInfoEx.getInstanceEx();
        Calendar cal = appInfo.getBuildDate();
        String output = "Build version: ";
        output = output + appInfo.getFullApplicationName();
        String buildInfo = IdeBundle.message((String)"about.box.build.number", (Object[])new Object[]{appInfo.getBuild().asString()});
        String buildDate = "";
        if (appInfo.getBuild().isSnapshot()) {
            buildDate = new SimpleDateFormat("HH:mm, ").format(cal.getTime());
        }
        buildDate = buildDate + DateFormatUtil.formatAboutDialogDate((Date)cal.getTime());
        output = output + ' ' + buildInfo + ' ' + buildDate;
        output = output + '\n';
        output = output + "Java version: ";
        Properties properties = System.getProperties();
        output = output + properties.getProperty("java.runtime.version", properties.getProperty("java.version", "unknown"));
        output = output + properties.getProperty("os.arch", "");
        output = output + '\n';
        output = output + "Operating System: ";
        output = output + SystemInfoRt.OS_NAME + " (" + SystemInfoRt.OS_VERSION + ", " + SystemInfo.OS_ARCH + ")";
        output = output + '\n';
        output = output + "JVM version: ";
        output = output + properties.getProperty("java.vm.name", "unknown");
        output = output + ' ' + properties.getProperty("java.vendor", "unknown");
        return output;
    }

    private static Holder analyzeFiles(VirtualFile file) {
        Holder holder = new Holder();
        VfsUtilCore.iterateChildrenRecursively((VirtualFile)file, null, virtualFile -> {
            if (virtualFile.is(VFileProperty.SYMLINK) && !virtualFile.is(VFileProperty.HIDDEN)) {
                holder.setSymlink();
            }
            if (!virtualFile.isDirectory()) {
                holder.increaseByOne();
            }
            return true;
        });
        return holder;
    }

    public String collectDisplayInfo() {
        StringBuilder output = new StringBuilder();
        output.append("Displays: \n");
        GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        for (int i = 0; i < devices.length; ++i) {
            DisplayMode displayMode = devices[i].getDisplayMode();
            float scale = JBUI.sysScale((GraphicsConfiguration)devices[i].getDefaultConfiguration());
            output.append(String.format("Display %d: %2.0fx%3.0f; scale: %4$.2f\n", i, Float.valueOf((float)displayMode.getWidth() * scale), Float.valueOf((float)displayMode.getHeight() * scale), Float.valueOf(scale)));
        }
        return output.toString();
    }

    public String collectMetrics() {
        String output = "";
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.project);
        VirtualFile baseDir = this.project.getBaseDir();
        if (baseDir != null) {
            Holder holder = StatisticCollector.analyzeFiles(baseDir);
            output = output + "Filesystem Info:\n";
            output = output + "File system is case sensitive: " + baseDir.getFileSystem().isCaseSensitive() + '\n';
            output = output + "Are there symlinks: " + holder.isSymlink() + '\n';
            output = output + "Number of files: " + holder.getNumOfFiles() + '\n';
            output = output + '\n';
        }
        long mb = 0x100000L;
        Runtime runtime = Runtime.getRuntime();
        output = output + "System Info:\n";
        output = output + "Number of CPU: " + runtime.availableProcessors() + '\n';
        output = output + "Used memory: " + (runtime.totalMemory() - runtime.freeMemory()) / mb + "Mb \n";
        output = output + "Free memory: " + runtime.freeMemory() / mb + "Mb \n";
        output = output + "Total memory: " + runtime.totalMemory() / mb + "Mb \n";
        output = output + "Maximum available memory: " + runtime.maxMemory() / mb + "Mb \n";
        output = output + this.collectDisplayInfo();
        output = output + '\n';
        output = output + "Project Info:\n";
        output = output + "Number of opened files: " + fileEditorManager.getOpenFiles().length + '\n';
        Editor selectedTextEditor = fileEditorManager.getSelectedTextEditor();
        if (selectedTextEditor != null) {
            Document document = selectedTextEditor.getDocument();
            output = output + "File size (in lines): " + document.getLineCount() + '\n';
            output = output + "File size in characters: " + document.getTextLength() + '\n';
            output = output + "Last action: " + this.getLastAction(document) + '\n';
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.project).getPsiFile(document);
            if (psiFile != null) {
                output = output + "Number of injections: " + InjectedLanguageManager.getInstance((Project)this.project).getCachedInjectedDocumentsInRange(psiFile, psiFile.getTextRange()).size() + '\n';
            }
        }
        output = output + '\n';
        output = output + "IDE Info:\n";
        output = output + StatisticCollector.logCustomPlugins();
        output = output + StatisticCollector.getSystemInfo();
        return output;
    }

    private String getLastAction(Document document) {
        UndoManagerImpl undoManager = (UndoManagerImpl)UndoManager.getInstance((Project)this.project);
        VirtualFile file = FileDocumentManager.getInstance().getFile(document);
        FileEditor selectedEditor = null;
        if (file != null) {
            selectedEditor = FileEditorManager.getInstance((Project)this.project).getSelectedEditor(file);
        }
        return (String)undoManager.getUndoActionNameAndDescription(selectedEditor).first;
    }

    private static class Holder {
        private boolean isSymlink;
        private int numOfFiles;

        private Holder() {
        }

        public boolean isSymlink() {
            return this.isSymlink;
        }

        public void setSymlink() {
            this.isSymlink = true;
        }

        public int getNumOfFiles() {
            return this.numOfFiles;
        }

        public void increaseByOne() {
            ++this.numOfFiles;
        }
    }
}

