/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.compiler;

import com.intellij.openapi.project.Project;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.compiler.CompileContext;
import com.intellij.structuralsearch.impl.matcher.compiler.GlobalCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.compiler.OptimizingSearchHelper;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.predicates.RegExpPredicate;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public interface WordOptimizer {
    default public boolean handleWord(@Nullable String word, CompileContext compileContext) {
        OptimizingSearchHelper optimizingSearchHelper = compileContext.getSearchHelper();
        if (!optimizingSearchHelper.doOptimizing()) {
            return false;
        }
        if (word == null) {
            return true;
        }
        CompiledPattern compiledPattern = compileContext.getPattern();
        if (compiledPattern.isTypedVar(word)) {
            SubstitutionHandler substitutionHandler = (SubstitutionHandler)compiledPattern.getHandler(word);
            if (substitutionHandler == null || substitutionHandler.getMinOccurs() == 0) {
                return false;
            }
            RegExpPredicate regExpPredicate = substitutionHandler.findRegExpPredicate();
            if (regExpPredicate != null && regExpPredicate.couldBeOptimized()) {
                if (substitutionHandler.isStrictSubtype() || substitutionHandler.isSubtype()) {
                    List<String> list2 = this.getDescendantsOf(regExpPredicate.getRegExp(), substitutionHandler.isSubtype(), compileContext.getProject());
                    for (String string : list2) {
                        optimizingSearchHelper.addWordToSearchInCode(string);
                    }
                    optimizingSearchHelper.endTransaction();
                } else {
                    GlobalCompilingVisitor.addFilesToSearchForGivenWord(regExpPredicate.getRegExp(), true, GlobalCompilingVisitor.OccurenceKind.CODE, compileContext);
                }
            }
        } else {
            GlobalCompilingVisitor.addFilesToSearchForGivenWord(word, true, GlobalCompilingVisitor.OccurenceKind.CODE, compileContext);
        }
        return true;
    }

    default public List<String> getDescendantsOf(String className, boolean includeSelf, Project project) {
        return Collections.emptyList();
    }
}

