/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.strings;

import b.h.la;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xmlb.annotations.Attribute;
import java.lang.invoke.MethodHandles;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspection;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyFix;
import org.jetbrains.plugins.ruby.ruby.inspections.strings.a;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactory;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.basicTypes.stringLiterals.baseString.RDStringLiteralImpl;

public class RubyQuotedStringsInspection
extends RubyInspection {
    private static final Pattern a;
    @Attribute(value="m_ignoreSingleQuote")
    public boolean myIgnoreSingleQuote = false;
    private static final long b;

    @Nullable
    public JComponent createOptionsPanel() {
        long l2 = b ^ 0x448051D6221BL;
        return new SingleCheckboxOptionsPanel(RBundle.message((String)"inspection.quoted.string.label"), (InspectionProfileEntry)this, "myIgnoreSingleQuote");
    }

    @NotNull
    public String getDisplayName() {
        long l2 = b ^ 0x6E74FFF3E784L;
        String string = RBundle.message((String)"inspection.quoted.string");
        if (string == null) {
            RubyQuotedStringsInspection.b(0);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RubyQuotedStringsInspection.b(1);
        }
        DoubleQuotedStringVisitor doubleQuotedStringVisitor = new DoubleQuotedStringVisitor(holder);
        if (doubleQuotedStringVisitor == null) {
            RubyQuotedStringsInspection.b(2);
        }
        return doubleQuotedStringVisitor;
    }

    private static void a(@Nullable PsiElement psiElement) {
        if (!(psiElement instanceof RDStringLiteralImpl)) {
            return;
        }
        RDStringLiteralImpl rDStringLiteralImpl = (RDStringLiteralImpl)psiElement;
        PsiElement psiElement2 = rDStringLiteralImpl.getStringBeginning();
        PsiElement psiElement3 = rDStringLiteralImpl.getStringEnding();
        if (psiElement2 == null || psiElement3 == null) {
            return;
        }
        String string = "'" + RubyQuotedStringsInspection.b(rDStringLiteralImpl.getContent()) + "'";
        rDStringLiteralImpl.replace((PsiElement)RubyElementFactory.createElementFromText((PsiElement)rDStringLiteralImpl, string));
    }

    @NotNull
    private static String b(@NotNull String string) {
        if (string == null) {
            RubyQuotedStringsInspection.b(3);
        }
        String string2 = RubyQuotedStringsInspection.a(string);
        String string3 = StringUtil.escapeChars((String)string2, (char[])new char[]{'\\', '\''});
        if (string3 == null) {
            RubyQuotedStringsInspection.b(4);
        }
        return string3;
    }

    @NotNull
    private static String a(@NotNull String string) {
        if (string == null) {
            RubyQuotedStringsInspection.b(5);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i10 = 0; i10 < string.length(); ++i10) {
            char c10 = string.charAt(i10);
            if (c10 == '\\') {
                if (i10 + 1 >= string.length() || string.charAt(i10 + 1) != '\\') continue;
                ++i10;
            }
            stringBuilder.append(c10);
        }
        String string2 = stringBuilder.toString();
        if (string2 == null) {
            RubyQuotedStringsInspection.b(6);
        }
        return string2;
    }

    static {
        b = la.a(1242129173642985394L, -6743835066615786117L, MethodHandles.lookup().lookupClass()).a(71117109200280L);
        long l2 = b ^ 0xBB496F17F4FL;
        a = Pattern.compile("(\\\\)(a|b|c|e|f|n|r|s|t|v|[0-7])");
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = b ^ 0x3D238F5C20EFL;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/strings/RubyQuotedStringsInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doubleQuotedStringContent";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/strings/RubyQuotedStringsInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "doConvertToSingleQuoted";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "doUnescape";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doConvertToSingleQuoted";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doUnescape";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DoubleQuotedStringFix
    extends RubyFix {
        private static final long a = la.a(-8734331615307020782L, 5339321969007353075L, MethodHandles.lookup().lookupClass()).a(219810281325506L);

        private DoubleQuotedStringFix() {
        }

        @Override
        protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
            if (project == null) {
                DoubleQuotedStringFix.b(0);
            }
            if (descriptor == null) {
                DoubleQuotedStringFix.b(1);
            }
            PsiElement psiElement = descriptor.getPsiElement();
            RubyQuotedStringsInspection.a(psiElement);
        }

        @NotNull
        public String getFamilyName() {
            long l2 = a ^ 0x74DD132D7BAFL;
            String string = RBundle.message((String)"inspection.quoted.string.fix");
            if (string == null) {
                DoubleQuotedStringFix.b(2);
            }
            return string;
        }

        /* synthetic */ DoubleQuotedStringFix(a x0) {
            this();
        }

        private static /* synthetic */ void b(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = a ^ 0x5F508F8BA82CL;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 2: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/strings/RubyQuotedStringsInspection$DoubleQuotedStringFix";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/strings/RubyQuotedStringsInspection$DoubleQuotedStringFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class DoubleQuotedStringVisitor
    extends RubyInspectionVisitor {
        private static final long b = la.a(8813491179551844289L, 2934886156395173539L, MethodHandles.lookup().lookupClass()).a(252791101544298L);

        DoubleQuotedStringVisitor(ProblemsHolder holder) {
            super(holder);
        }

        @Override
        public void visitRDStringLiteral(@NotNull RStringLiteral rDStringLiteral) {
            long l2 = b ^ 0x54D0DF5B1A90L;
            if (rDStringLiteral == null) {
                DoubleQuotedStringVisitor.d(0);
            }
            String string = rDStringLiteral.getContent();
            if (RubyQuotedStringsInspection.this.myIgnoreSingleQuote && StringUtil.containsChar((String)string, (char)'\'')) {
                return;
            }
            if (!rDStringLiteral.hasExpressionSubstitutions() && string != null && !a.matcher(string).find()) {
                this.registerProblem((PsiElement)rDStringLiteral, RBundle.message((String)"inspection.quoted.string.msg"), new DoubleQuotedStringFix(null));
            }
        }

        private static /* synthetic */ void d(int n2) {
            long l2 = b ^ 0x61AE80A08B52L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rDStringLiteral", "org/jetbrains/plugins/ruby/ruby/inspections/strings/RubyQuotedStringsInspection$DoubleQuotedStringVisitor", "visitRDStringLiteral"));
        }
    }
}

