/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.psi.impl;

import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ImportOptimizer;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageImportStatements;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6NamedImports;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.psi.impl.JSImportPathBuilder;
import com.intellij.lang.ecmascript6.refactoring.ES6ReferenceExpressionsInfo;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.imports.ES6ImportOptimizer;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.modules.ES6ImportAction;
import com.intellij.lang.javascript.modules.JSImportPlaceInfo;
import com.intellij.lang.javascript.modules.JSModuleNameInfo;
import com.intellij.lang.javascript.modules.NodeJSModulesSearcher;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCompileTimeType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElement;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.intentions.TypeScriptImportAction;
import com.intellij.lang.typescript.library.download.TypeScriptDefinitionFilesDirectory;
import com.intellij.lang.typescript.psi.TypeScriptAddImportExecutor;
import com.intellij.lang.typescript.psi.TypeScriptAutoImportUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptAugmentationUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6CreateImportUtil {
    private static final TokenSet EXPORT_ELEMENT_TYPES = TokenSet.create((IElementType[])new IElementType[]{ES6ElementTypes.EXPORT_DECLARATION});

    public static boolean checkSymbolInFile(@NotNull Project project, @NotNull VirtualFile fileToCheck, @NotNull PsiElement elementToImport, @NotNull PsiElement place) {
        PsiFile possiblePsiFile;
        if (project == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(0);
        }
        if (fileToCheck == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(1);
        }
        if (elementToImport == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(2);
        }
        if (place == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(3);
        }
        if (!((possiblePsiFile = PsiManager.getInstance((Project)project).findFile(fileToCheck)) instanceof JSFile)) {
            return false;
        }
        JSFile file2 = (JSFile)possiblePsiFile;
        if (!(elementToImport instanceof JSElement)) {
            return elementToImport instanceof PsiFile && possiblePsiFile.isEquivalentTo(elementToImport);
        }
        DialectOptionHolder holder = DialectDetector.dialectOfFile((PsiFile)file2);
        if (holder == null || !holder.hasFeature(JSLanguageFeature.IMPORT_DECLARATIONS)) {
            return false;
        }
        return ES6CreateImportUtil.resolveSymbolInModule((JSElement)elementToImport, place, (JSElement)file2) != null;
    }

    @Nullable
    public static ResolveResult resolveSymbolInModule(@NotNull JSElement elementToImport, @NotNull PsiElement place, @NotNull JSElement module) {
        String name;
        if (elementToImport == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(4);
        }
        if (place == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(5);
        }
        if (module == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(6);
        }
        if ((name = ES6CreateImportUtil.getExportedNameForResolveInModule(elementToImport)) == null) {
            return null;
        }
        Object[] results = ES6PsiUtil.resolveSymbolInModule(name, place, module);
        JSElement toCheck = elementToImport instanceof ES6ExportSpecifier ? ES6CreateImportUtil.expandExportSpecifierForResolveSymbolInModule((ES6ExportSpecifier)elementToImport) : elementToImport;
        return ((StreamEx)((StreamEx)StreamEx.of((Object[])results).filter(ResolveResult::isValidResult)).filter(el -> ES6CreateImportUtil.isDirectOrIndirectEquivalent(toCheck, el.getElement()))).findAny().orElse(null);
    }

    private static boolean isDirectOrIndirectEquivalent(@NotNull JSElement toImport, @Nullable PsiElement resolvedByName) {
        PsiElement explicit;
        if (toImport == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(7);
        }
        if (toImport.isEquivalentTo(resolvedByName)) {
            return true;
        }
        if (resolvedByName instanceof TypeScriptProxyImplicitElement && (explicit = ((TypeScriptProxyImplicitElement)resolvedByName).getExplicitElement()) != null && explicit.isEquivalentTo(resolvedByName)) {
            return true;
        }
        if (toImport instanceof JSElementBase && ((JSElementBase)toImport).isExportedWithDefault() && resolvedByName instanceof ES6ExportDefaultAssignment) {
            Collection<PsiElement> elements = JSStubBasedPsiTreeUtil.calculateMeaningfulElements(resolvedByName);
            return elements.contains(toImport);
        }
        return false;
    }

    @Nullable
    private static String getExportedNameForResolveInModule(@NotNull JSElement element) {
        JSElementBase elementBase;
        if (element == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(8);
        }
        if (element instanceof ES6ImportExportSpecifier) {
            return ((ES6ImportExportSpecifier)element).getDeclaredName();
        }
        if (element instanceof ES6ExportDefaultAssignment) {
            return "default";
        }
        if (element instanceof JSElementBase && (elementBase = (JSElementBase)element).isExportedWithDefault() && !elementBase.isExported()) {
            return "default";
        }
        return element.getName();
    }

    @NotNull
    private static JSElement expandExportSpecifierForResolveSymbolInModule(@NotNull ES6ExportSpecifier elementToImport) {
        ES6ExportSpecifierAlias alias;
        if (elementToImport == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(9);
        }
        if ((alias = elementToImport.getAlias()) != null) {
            ES6ExportSpecifierAlias eS6ExportSpecifierAlias = alias;
            if (eS6ExportSpecifierAlias == null) {
                ES6CreateImportUtil.$$$reportNull$$$0(10);
            }
            return eS6ExportSpecifierAlias;
        }
        List elements = JSResolveResult.toElements(elementToImport.multiResolve(false), true).stream().filter(el -> el instanceof JSElement).map(el -> (JSElement)el).collect(Collectors.toList());
        if (!elements.isEmpty()) {
            for (JSElement element : elements) {
                PsiElement externalModule = ES6PsiUtil.findExternalModule((PsiElement)element);
                if (externalModule == null || TypeScriptAugmentationUtil.isExternalModuleAugmentation(externalModule)) continue;
                JSElement jSElement = element;
                if (jSElement == null) {
                    ES6CreateImportUtil.$$$reportNull$$$0(11);
                }
                return jSElement;
            }
            JSElement jSElement = (JSElement)ContainerUtil.getFirstItem(elements, (Object)elementToImport);
            if (jSElement == null) {
                ES6CreateImportUtil.$$$reportNull$$$0(12);
            }
            return jSElement;
        }
        ES6ExportSpecifier eS6ExportSpecifier = elementToImport;
        if (eS6ExportSpecifier == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(13);
        }
        return eS6ExportSpecifier;
    }

    @Nullable
    public static Pair<VirtualFile, VirtualFile> findParentLibraryDirectory(@NotNull Project project, @NotNull VirtualFile dstFile, @NotNull String[] directories) {
        if (project == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(14);
        }
        if (dstFile == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(15);
        }
        if (directories == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(16);
        }
        VirtualFile prevDirectory = dstFile.isDirectory() ? dstFile : null;
        VirtualFile prevDirectoryWithPackageJson = null;
        Object[] stopCandidates = ProjectRootManager.getInstance((Project)project).getContentRoots();
        VirtualFile dir = project.getBaseDir();
        List stopDirs = ((StreamEx)StreamEx.of((Object[])stopCandidates).filter(el -> el.equals(dir) || !VfsUtilCore.isAncestor((VirtualFile)dir, (VirtualFile)el, (boolean)true))).toList();
        for (VirtualFile currentDirectory = dstFile.getParent(); currentDirectory != null; currentDirectory = currentDirectory.getParent()) {
            if (ArrayUtil.contains((String)currentDirectory.getName(), (String[])directories)) {
                VirtualFile module = prevDirectoryWithPackageJson == null ? prevDirectory : prevDirectoryWithPackageJson;
                return Pair.create((Object)module, (Object)currentDirectory);
            }
            if (ArrayUtil.contains((Object)currentDirectory, (Object[])new Object[]{stopDirs})) break;
            if (null != currentDirectory.findChild("package.json")) {
                prevDirectoryWithPackageJson = currentDirectory;
            }
            prevDirectory = currentDirectory;
        }
        return null;
    }

    @NotNull
    public static GlobalSearchScope createSymbolToImportSearchScope(@NotNull Project project, @NotNull PsiElement context) {
        VirtualFile contextFile;
        if (project == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(17);
        }
        if (context == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(18);
        }
        if ((contextFile = context.getContainingFile().getOriginalFile().getVirtualFile()) == null) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
            if (globalSearchScope == null) {
                ES6CreateImportUtil.$$$reportNull$$$0(19);
            }
            return globalSearchScope;
        }
        if (DialectDetector.isTypeScript(context)) {
            GlobalSearchScope globalSearchScope = TypeScriptAutoImportUtil.createSymbolToImportSearchScope(project, context, contextFile);
            if (globalSearchScope == null) {
                ES6CreateImportUtil.$$$reportNull$$$0(20);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = ES6CreateImportUtil.createES6SymbolToImportSearchScope(project, context, contextFile);
        if (globalSearchScope == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(21);
        }
        return globalSearchScope;
    }

    @NotNull
    private static GlobalSearchScope createES6SymbolToImportSearchScope(@NotNull Project project, @NotNull PsiElement context, @NotNull VirtualFile contextFile) {
        if (project == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(22);
        }
        if (context == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(23);
        }
        if (contextFile == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(24);
        }
        GlobalSearchScope baseScope = JSResolveUtil.getResolveScope(context);
        final VirtualFile directoryOfContext = contextFile.getParent();
        if (directoryOfContext == null) {
            GlobalSearchScope globalSearchScope = baseScope;
            if (globalSearchScope == null) {
                ES6CreateImportUtil.$$$reportNull$$$0(25);
            }
            return globalSearchScope;
        }
        final ProjectFileIndex index = ProjectFileIndex.getInstance((Project)project);
        final Set<VirtualFile> predefinedLibraryFiles = JSCorePredefinedLibrariesProvider.getAllJSPredefinedLibraryFiles();
        VirtualFile globalCandidate = TypeScriptDefinitionFilesDirectory.getGlobalTypesDirectory();
        final VirtualFile globalNodeModules = globalCandidate == null || !globalCandidate.isValid() ? null : globalCandidate.getParent();
        final boolean acceptNodeModulesES6LikeSymbols = DialectDetector.hasFeature(context, JSLanguageFeature.IMPORT_DECLARATIONS);
        final PsiManager manager = context.getManager();
        DelegatingGlobalSearchScope delegatingGlobalSearchScope = new DelegatingGlobalSearchScope(baseScope){

            public boolean contains(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!super.contains(file2)) {
                    return false;
                }
                VirtualFile nodeModules = NodeModuleSearchUtil.findAncestorNodeModulesDir(file2);
                if (nodeModules == null && !index.isInLibrary(file2) && !predefinedLibraryFiles.contains(file2)) {
                    return true;
                }
                if (nodeModules != null && (acceptNodeModulesES6LikeSymbols && TypeScriptUtil.isDefinitionFile(file2) || acceptNodeModulesES6LikeSymbols && this.isAcceptableES6File(file2, manager))) {
                    VirtualFile parent = nodeModules.getParent();
                    if (parent == null) {
                        return false;
                    }
                    return VfsUtilCore.isAncestor((VirtualFile)parent, (VirtualFile)directoryOfContext, (boolean)false) || globalNodeModules != null && nodeModules.equals(globalNodeModules);
                }
                return false;
            }

            private boolean isAcceptableES6File(@NotNull VirtualFile file2, @NotNull PsiManager manager2) {
                PsiFile psiFile;
                if (file2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (manager2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                return (psiFile = manager2.findFile(file2)) instanceof JSFile && ((JSFile)psiFile).getModuleStatus() == JSFile.ModuleStatus.ES6;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "manager";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contains";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isAcceptableES6File";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (delegatingGlobalSearchScope == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(26);
        }
        return delegatingGlobalSearchScope;
    }

    public static boolean isAvailableForImport(@NotNull PsiElement candidate, @NotNull PsiElement context) {
        if (candidate == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(27);
        }
        if (context == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(28);
        }
        return ES6CreateImportUtil.isAvailableForImport(candidate, new JSImportPlaceInfo(context.getOriginalElement()));
    }

    public static ES6ImportAction createImportAction(@Nullable Editor editor, @NotNull PsiElement context, @Nullable String name, @Nullable JSQualifiedNamedElement toImport, @NotNull ES6ImportAction.ImportElementFilter filter) {
        PsiElement module;
        if (context == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(29);
        }
        if (filter == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(30);
        }
        if (DialectDetector.isTypeScript(context)) {
            return new TypeScriptImportAction(editor, context, name, filter);
        }
        if (toImport != null && DialectDetector.isTypeScript((PsiElement)toImport) && (module = ES6PsiUtil.findExternalModule((PsiElement)toImport)) instanceof TypeScriptModule && ((TypeScriptModule)module).isExternal()) {
            return new TypeScriptImportAction(editor, context, name, filter);
        }
        return new ES6ImportAction(editor, context, name, filter);
    }

    public static void insertExport(@NotNull JSQualifiedNamedElement elementToImport, @NotNull ES6ImportPsiUtil.ImportExportType type, @NotNull String importedName, @Nullable String exportedName, @NotNull PsiElement place) {
        if (elementToImport == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(31);
        }
        if (type == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(32);
        }
        if (importedName == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(33);
        }
        if (place == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(34);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        JSModuleNameInfo moduleNameInfo = ES6CreateImportUtil.getModuleNameInfo(place.getProject(), elementToImport, place);
        if (moduleNameInfo == null) {
            return;
        }
        PsiElement scope = ES6CreateImportUtil.getScopeToAdd(place, true);
        if (scope == null) {
            return;
        }
        ES6ImportPsiUtil.CreateImportExportInfo createInfo = new ES6ImportPsiUtil.CreateImportExportInfo(exportedName, importedName, type, false, false);
        ES6ImportExportDeclaration exportDeclaration = ES6ImportPsiUtil.createImportExport(place, createInfo, moduleNameInfo.getPath());
        if (exportDeclaration == null) {
            return;
        }
        Pair<Boolean, PsiElement> placeForAnchor = ES6ImportPsiUtil.findAnchorToInsert(scope, EXPORT_ELEMENT_TYPES, false);
        ES6CreateImportUtil.insertPsiElementToScope((PsiElement)exportDeclaration, scope, placeForAnchor, null);
    }

    public static void insertExportName(@NotNull ES6ImportPsiUtil.ImportExportType type, @NotNull String importedName, @Nullable String exportedName, @NotNull PsiElement place) {
        PsiElement scope;
        if (type == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(35);
        }
        if (importedName == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(36);
        }
        if (place == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(37);
        }
        if ((scope = ES6CreateImportUtil.getScopeToAdd(place, true)) == null) {
            return;
        }
        ES6ImportPsiUtil.CreateImportExportInfo info = new ES6ImportPsiUtil.CreateImportExportInfo(exportedName, importedName, type, true, false);
        StringBuilder builder = new StringBuilder("export ");
        if (type == ES6ImportPsiUtil.ImportExportType.DEFAULT) {
            builder.append("default ");
        }
        builder.append(info.getRawText(JSCodeStyleSettings.getSettings((PsiElement)place).SPACES_WITHIN_IMPORTS));
        builder.append(JSCodeStyleSettings.getSemicolon((PsiElement)place.getContainingFile()));
        ASTNode importNode = JSChangeUtil.createStatementFromTextWithContext(builder.toString(), place);
        if (importNode == null) {
            return;
        }
        Pair<Boolean, PsiElement> placeForAnchor = ES6ImportPsiUtil.findAnchorToInsert(scope, EXPORT_ELEMENT_TYPES, false);
        ES6CreateImportUtil.insertPsiElementToScope(importNode.getPsi(), scope, placeForAnchor, null);
    }

    public static JSModuleNameInfo getModuleNameInfo(@NotNull Project project, @NotNull JSQualifiedNamedElement elementToImport, @NotNull PsiElement place) {
        if (project == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(38);
        }
        if (elementToImport == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(39);
        }
        if (place == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(40);
        }
        if (DialectDetector.isTypeScript(place)) {
            return ES6CreateImportUtil.getExternalFileModuleName((JSElement)elementToImport, place, true);
        }
        PsiFile targetPsiFile = elementToImport.getContainingFile();
        VirtualFile targetFile = targetPsiFile.getVirtualFile();
        VirtualFile root = NodeModuleUtil.getMainModuleRoot(place);
        if (root == null) {
            return ES6CreateImportUtil.getExternalFileModuleName((PsiElement)elementToImport, targetFile, place, true);
        }
        return NodeJSModulesSearcher.getModuleInfo(place, (PsiElement)elementToImport, elementToImport.getContainingFile());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isAvailableForImport(@NotNull PsiElement candidate, @NotNull JSImportPlaceInfo info) {
        if (candidate == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(41);
        }
        if (info == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(42);
        }
        if (!ES6PsiUtil.isElementCanBeExported(candidate) && !(candidate instanceof ES6ExportSpecifier)) {
            return false;
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement(info.getPlace());
        if (holder == null) {
            return false;
        }
        if (holder.isTypeScript && !TypeScriptAutoImportUtil.isContextAcceptable(candidate, info)) {
            return false;
        }
        JSElement scope = ES6PsiUtil.getExportScope(candidate);
        if (scope == null) {
            return false;
        }
        if (!holder.isECMA6) return TypeScriptAutoImportUtil.isExportedElement(candidate, info);
        if (!holder.isFlow && candidate instanceof TypeScriptCompileTimeType) {
            return false;
        }
        if (TypeScriptPsiUtil.isAugmentationModule((PsiElement)scope)) {
            return false;
        }
        if (scope instanceof TypeScriptModule) {
            if (!((TypeScriptModule)scope).isExportedWithDefault()) return false;
            if (((TypeScriptModule)scope).isInternal()) return TypeScriptAutoImportUtil.isExportedElement(candidate, info);
            return false;
        }
        if (scope instanceof JSFile && ((JSFile)scope).isCommonJSModule()) return TypeScriptAutoImportUtil.isExportedElement(candidate, info);
        return false;
    }

    public static void insertImport(@NotNull PsiElement place, @NotNull JSQualifiedNamedElement toImport, @Nullable String importedName) {
        if (place == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(43);
        }
        if (toImport == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(44);
        }
        ES6ImportAction action = ES6CreateImportUtil.createImportAction(null, place, importedName, toImport, new ES6ImportAction.ImportElementFilter(){

            @Override
            @NotNull
            public List<JSElement> filterByContext(@NotNull PsiElement context, @NotNull List<JSElement> result2) {
                if (context == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (result2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                List<JSElement> list = result2;
                if (list == null) {
                    2.$$$reportNull$$$0(2);
                }
                return list;
            }

            @Override
            public boolean isValidContext(@NotNull PsiElement context) {
                if (context == null) {
                    2.$$$reportNull$$$0(3);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "result";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil$2";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "filterByContext";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "filterByContext";
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "isValidContext";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        action.executeWithoutPrepare((JSElement)toImport);
    }

    public static PsiElement getExternalModuleScope(@NotNull PsiElement place) {
        if (place == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(45);
        }
        return ES6CreateImportUtil.getScopeToAdd(place, true);
    }

    @Nullable
    public static PsiElement getScopeToAdd(@NotNull PsiElement place, boolean fromExternalModule) {
        JSEmbeddedContent content;
        if (place == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(46);
        }
        if (!(place.getContainingFile() instanceof JSFile) && (content = (JSEmbeddedContent)PsiTreeUtil.getParentOfType((PsiElement)place, JSEmbeddedContent.class)) != null) {
            return content;
        }
        if (fromExternalModule) {
            PsiElement module = ES6PsiUtil.findExternalModule(place);
            return module != null ? module : place.getContainingFile();
        }
        return PsiTreeUtil.getParentOfType((PsiElement)place, (Class[])new Class[]{PsiFile.class, TypeScriptModule.class});
    }

    public static void insertPsiElementToScope(@NotNull PsiElement createdPsi, @NotNull PsiElement scope, @NotNull Pair<Boolean, PsiElement> placeFor, @Nullable Editor editor) {
        if (createdPsi == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(47);
        }
        if (scope == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(48);
        }
        if (placeFor == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(49);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiFile file2 = scope.getContainingFile();
        Project project = scope.getProject();
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{file2}).withName(JSBundle.message((String)"ts.add.import.statement.family.name", (Object[])new Object[0])).run(() -> {
            Boolean addAfter;
            Document document;
            if (placeFor == null) {
                ES6CreateImportUtil.$$$reportNull$$$0(76);
            }
            if (scope == null) {
                ES6CreateImportUtil.$$$reportNull$$$0(77);
            }
            if (createdPsi == null) {
                ES6CreateImportUtil.$$$reportNull$$$0(78);
            }
            PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)project);
            Document document2 = document = editor != null ? editor.getDocument() : manager.getDocument(file2);
            if (document != null) {
                manager.commitDocument(document);
            }
            if (Boolean.TRUE.equals(addAfter = (Boolean)placeFor.first)) {
                scope.addAfter(createdPsi, (PsiElement)placeFor.second);
            } else {
                PsiElement nodeInsertBefore = (PsiElement)placeFor.second;
                boolean isFirstElement = PsiTreeUtil.skipSiblingsBackward((PsiElement)nodeInsertBefore, (Class[])new Class[]{PsiWhiteSpace.class}) == null;
                PsiElement added = JSChangeUtil.doAddBefore(scope, createdPsi, nodeInsertBefore);
                if (isFirstElement) {
                    JSChangeUtil.addWs(scope.getNode(), nodeInsertBefore.getNode(), "\n");
                    if (added.getPrevSibling() == null && scope instanceof JSEmbeddedContent) {
                        JSChangeUtil.addWs(scope.getNode(), added.getNode(), "\n");
                    }
                }
            }
        });
    }

    public static void findPlaceAndInsertES6Import(@NotNull PsiElement scope, @NotNull PsiElement created, @NotNull String moduleName, @Nullable Editor editor) {
        if (scope == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(50);
        }
        if (created == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(51);
        }
        if (moduleName == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(52);
        }
        Pair<Boolean, PsiElement> anchor = ES6ImportPsiUtil.findPlaceByModuleName(scope, moduleName);
        ES6CreateImportUtil.insertPsiElementToScope(created, scope, anchor, editor);
    }

    public static void findPlaceAndInsertAnyImport(@NotNull PsiElement scope, @NotNull PsiElement created, @Nullable Editor editor) {
        if (scope == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(53);
        }
        if (created == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(54);
        }
        Pair<Boolean, PsiElement> anchor = ES6ImportPsiUtil.findPlaceForImport(scope);
        ES6CreateImportUtil.insertPsiElementToScope(created, scope, anchor, editor);
    }

    public static boolean insertFromClause(@NotNull ES6ImportDeclaration originalDeclaration, @NotNull String quotedRefText) {
        PsiElement errorCandidate;
        if (originalDeclaration == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(55);
        }
        if (quotedRefText == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(56);
        }
        if ((errorCandidate = originalDeclaration.getLastChild()) instanceof ES6NamedImports) {
            errorCandidate = errorCandidate.getLastChild();
        }
        if (!(errorCandidate instanceof PsiErrorElement)) {
            return false;
        }
        String currentText = originalDeclaration.getText();
        ASTNode originalNamedImports = originalDeclaration.getNode().findChildByType((IElementType)ES6ElementTypes.NAMED_IMPORTS);
        assert (originalNamedImports != null) : currentText;
        PsiElement anchor = originalNamedImports.getPsi();
        boolean hasCloseBrace = currentText.contains("}");
        String newText = currentText + (hasCloseBrace ? "" : "}") + " from " + quotedRefText + JSCodeStyleSettings.getSemicolon((PsiElement)originalDeclaration.getContainingFile());
        Project project = originalDeclaration.getProject();
        PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)project);
        JSLanguageDialect dialect = DialectDetector.languageDialectOfElement((PsiElement)originalDeclaration);
        if (dialect == null) {
            return false;
        }
        PsiFile dummy = psiFileFactory.createFileFromText("dummy", (Language)dialect, (CharSequence)newText);
        if (!(dummy.getFirstChild() instanceof ES6ImportDeclaration) || dummy.getChildren().length > 1) {
            Logger.getInstance(ES6CreateImportUtil.class).error("Incorrect new import text", new Attachment[]{new Attachment("newText.txt", newText)});
            return false;
        }
        ES6ImportDeclaration declaration = (ES6ImportDeclaration)dummy.getFirstChild();
        ES6FromClause fromClause = declaration.getFromClause();
        assert (fromClause != null) : newText;
        ASTNode node = declaration.getNode();
        ASTNode importsNode = node.findChildByType((IElementType)ES6ElementTypes.NAMED_IMPORTS);
        assert (importsNode != null) : newText;
        ASTNode closeBrace = hasCloseBrace ? null : importsNode.findChildByType(JSTokenTypes.RBRACE);
        PsiElement fromPartStartRange = importsNode.getTreeNext().getPsi();
        assert (fromPartStartRange != null) : newText;
        PsiElement fromPartEndRange = declaration.getLastChild();
        PsiElement errorElement = errorCandidate;
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{originalDeclaration.getContainingFile()}).withName("Complete import statement").run(() -> {
            if (originalDeclaration == null) {
                ES6CreateImportUtil.$$$reportNull$$$0(75);
            }
            if (!hasCloseBrace) {
                assert (closeBrace != null);
                originalNamedImports.addChild(closeBrace);
            }
            originalDeclaration.addRangeAfter(fromPartStartRange, fromPartEndRange, anchor);
            errorElement.delete();
        });
        return true;
    }

    @Nullable
    public static JSModuleNameInfo getExactExternalFileModuleName(@NotNull PsiElement place, @NotNull VirtualFile dstFile, @Nullable TypeScriptConfig configFile) {
        if (place == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(57);
        }
        if (dstFile == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(58);
        }
        JSImportPathBuilder builder = JSImportPathBuilder.createBuilder(place, null, dstFile, false, configFile);
        Ref ref = Ref.create();
        Processor<JSModuleNameInfo> processor = JSImportPathBuilder.createSearchProcessor((Ref<? super JSModuleNameInfo>)ref, ArrayUtil.EMPTY_STRING_ARRAY);
        builder.processDirectModuleNames(false, processor);
        return (JSModuleNameInfo)ref.get();
    }

    @Nullable
    public static JSModuleNameInfo getExternalFileModuleName(@NotNull JSElement elementToImport, @NotNull PsiElement place, boolean useExistingImports) {
        if (elementToImport == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(59);
        }
        if (place == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(60);
        }
        PsiFile originalFile = elementToImport.getContainingFile().getOriginalFile();
        return ES6CreateImportUtil.getExternalFileModuleName((PsiElement)elementToImport, originalFile.getVirtualFile(), place, useExistingImports);
    }

    @Nullable
    public static JSModuleNameInfo getExternalFileModuleName(@Nullable PsiElement elementToImport, @NotNull VirtualFile dstFile, @NotNull PsiElement place, boolean useExistingImports) {
        if (dstFile == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(61);
        }
        if (place == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(62);
        }
        JSImportPathBuilder builder = JSImportPathBuilder.createBuilder(place, elementToImport, dstFile, useExistingImports);
        return ES6CreateImportUtil.getExternalFileModuleName(builder);
    }

    public static JSModuleNameInfo getExternalFileModuleName(@NotNull JSImportPathBuilder builder) {
        if (builder == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(63);
        }
        Ref ref = Ref.create();
        String[] excludedNames = JSCodeStyleSettings.getSettings(builder.myPlace).getBlacklistImports();
        builder.processModuleNames(JSImportPathBuilder.createSearchProcessor((Ref<? super JSModuleNameInfo>)ref, excludedNames));
        return (JSModuleNameInfo)ref.get();
    }

    public static void addRequiredImports(@NotNull ES6ReferenceExpressionsInfo info, @NotNull PsiElement destinationModule) {
        if (info == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(64);
        }
        if (destinationModule == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(65);
        }
        ES6CreateImportUtil.addRequiredImports(ContainerUtil.list((Object[])new ES6ReferenceExpressionsInfo[]{info}), (Condition<? super PsiElement>)Conditions.alwaysFalse(), destinationModule);
    }

    public static void addRequiredImports(@NotNull Collection<? extends ES6ReferenceExpressionsInfo> infos, @NotNull Condition<? super PsiElement> excludedFilter, @NotNull PsiElement destinationModule) {
        if (infos == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(66);
        }
        if (excludedFilter == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(67);
        }
        if (destinationModule == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(68);
        }
        List imports = infos.stream().flatMap(i -> i.getReferencedImports().entrySet().stream()).filter(pair -> {
            PsiElement toImport;
            PsiElement targetModule;
            if (destinationModule == null) {
                ES6CreateImportUtil.$$$reportNull$$$0(74);
            }
            return !destinationModule.isEquivalentTo(targetModule = ES6PsiUtil.findExternalModule(toImport = (PsiElement)pair.getValue(), false));
        }).map(entry -> Pair.create(entry.getKey(), entry.getValue())).collect(Collectors.toList());
        ES6CreateImportUtil.addRequiredImports(destinationModule, imports);
        List elements = infos.stream().flatMap(info -> info.getExportedLocalReferencedElements().stream()).filter(e -> {
            if (excludedFilter == null) {
                ES6CreateImportUtil.$$$reportNull$$$0(73);
            }
            return !excludedFilter.value(e);
        }).collect(Collectors.toList());
        for (PsiElement element : elements) {
            if (!(element instanceof JSQualifiedNamedElement)) continue;
            ES6CreateImportUtil.insertImport(destinationModule, (JSQualifiedNamedElement)element, ((JSQualifiedNamedElement)element).getName());
        }
    }

    public static void addRequiredImports(@NotNull PsiElement destinationModule, @NotNull Collection<? extends Pair<ES6ImportPsiUtil.CreateImportExportInfo, PsiElement>> imports) {
        if (destinationModule == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(69);
        }
        if (imports == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(70);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        for (Pair<ES6ImportPsiUtil.CreateImportExportInfo, PsiElement> pair : imports) {
            ES6ImportPsiUtil.CreateImportExportInfo createInfo = (ES6ImportPsiUtil.CreateImportExportInfo)pair.getFirst();
            PsiElement element = (PsiElement)pair.getSecond();
            PsiElement module = ES6PsiUtil.findExternalModule(element, false);
            if (module instanceof TypeScriptModule) {
                String exportedName = createInfo.getExportedName();
                String importedName = createInfo.getImportedName();
                String actualExportedName = (String)ObjectUtils.coalesce((Object)exportedName, (Object)importedName);
                String actualImportedName = (String)ObjectUtils.coalesce((Object)importedName, (Object)exportedName);
                String externalModuleText = ((TypeScriptModule)module).getExternalModuleText();
                if (externalModuleText == null || actualExportedName == null) continue;
                new TypeScriptAddImportExecutor(actualImportedName, null, destinationModule).createImportOrUseExisting(exportedName, module, externalModuleText, createInfo.getImportType());
                continue;
            }
            ES6ImportPsiUtil.insertJSImport(destinationModule, createInfo, element, null);
        }
    }

    public static void optimizeImports(@NotNull PsiElement toOptimize) {
        if (toOptimize == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(71);
        }
        PsiFile file2 = toOptimize.getContainingFile();
        Set optimizers = LanguageImportStatements.INSTANCE.forFile(file2);
        for (ImportOptimizer optimizer : optimizers) {
            if (!optimizer.supports(file2)) continue;
            optimizer.processFile(file2).run();
            return;
        }
        new ES6ImportOptimizer().processFile(file2).run();
    }

    public static boolean isAcceptableExportSpecifier(@NotNull ES6ExportSpecifier specifier) {
        ES6ExportDeclaration declaration;
        if (specifier == null) {
            ES6CreateImportUtil.$$$reportNull$$$0(72);
        }
        if ((declaration = specifier.getDeclaration()) == null) {
            return false;
        }
        if (specifier.getAlias() != null) {
            return true;
        }
        PsiElement context = declaration.getContext();
        if (!(context instanceof PsiFile)) {
            return true;
        }
        VirtualFile vFile = ((PsiFile)context).getVirtualFile();
        if (declaration.isReExport()) {
            return !ES6CreateImportUtil.isIndexFile(context) && !JSLibraryUtil.isProbableLibraryFile(vFile);
        }
        return true;
    }

    private static boolean isIndexFile(@Nullable PsiElement element) {
        if (!(element instanceof PsiFile)) {
            return false;
        }
        return ((PsiFile)element).getName().startsWith("index.");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToCheck";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 31: 
            case 39: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToImport";
                break;
            }
            case 3: 
            case 5: 
            case 34: 
            case 37: 
            case 40: 
            case 43: 
            case 45: 
            case 46: 
            case 57: 
            case 60: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImport";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil";
                break;
            }
            case 15: 
            case 58: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dstFile";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directories";
                break;
            }
            case 18: 
            case 23: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 27: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importedName";
                break;
            }
            case 42: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 47: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createdPsi";
                break;
            }
            case 48: 
            case 50: 
            case 53: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 49: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeFor";
                break;
            }
            case 51: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "created";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 55: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalDeclaration";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quotedRefText";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 65: 
            case 68: 
            case 69: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destinationModule";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 67: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedFilter";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imports";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toOptimize";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "expandExportSpecifierForResolveSymbolInModule";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createSymbolToImportSearchScope";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createES6SymbolToImportSearchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkSymbolInFile";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveSymbolInModule";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isDirectOrIndirectEquivalent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getExportedNameForResolveInModule";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "expandExportSpecifierForResolveSymbolInModule";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 26: {
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findParentLibraryDirectory";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createSymbolToImportSearchScope";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createES6SymbolToImportSearchScope";
                break;
            }
            case 27: 
            case 28: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableForImport";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createImportAction";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "insertExport";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "insertExportName";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getModuleNameInfo";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "insertImport";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getExternalModuleScope";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getScopeToAdd";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "insertPsiElementToScope";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "findPlaceAndInsertES6Import";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "findPlaceAndInsertAnyImport";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "insertFromClause";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getExactExternalFileModuleName";
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getExternalFileModuleName";
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "addRequiredImports";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "optimizeImports";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableExportSpecifier";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addRequiredImports$10";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addRequiredImports$7";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "lambda$insertFromClause$5";
                break;
            }
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "lambda$insertPsiElementToScope$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

