/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter.blocks;

import com.intellij.formatting.Block;
import com.intellij.formatting.BlockEx;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.formatter.JSBlockContext;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.formatter.blocks.JSBlock;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.webcore.formatter.CompositeBlock;
import com.intellij.webcore.formatter.SpacingStrategy;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeJSBlock
extends CompositeBlock
implements BlockEx {
    private final IElementType myBlockElementType;
    private final Language myLanguage;
    private final CommonCodeStyleSettings myCommonSettings;
    private final JSCodeStyleSettings myCustomSettings;

    public CompositeJSBlock(@NotNull List<Block> childBlocks, @NotNull SpacingStrategy spacingStrategy, @Nullable Indent indent, @NotNull IElementType type, @NotNull JSBlockContext blockContext) {
        if (childBlocks == null) {
            CompositeJSBlock.$$$reportNull$$$0(0);
        }
        if (spacingStrategy == null) {
            CompositeJSBlock.$$$reportNull$$$0(1);
        }
        if (type == null) {
            CompositeJSBlock.$$$reportNull$$$0(2);
        }
        if (blockContext == null) {
            CompositeJSBlock.$$$reportNull$$$0(3);
        }
        super(childBlocks, spacingStrategy, indent);
        this.myBlockElementType = type;
        this.myLanguage = blockContext.getDialect();
        this.myCommonSettings = blockContext.getCommonSettings();
        this.myCustomSettings = blockContext.getDialectSettings();
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        if (this.myBlockElementType == JSStubElementTypes.PACKAGE_STATEMENT && this.myCustomSettings.INDENT_PACKAGE_CHILDREN == 0) {
            ChildAttributes childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
            if (childAttributes == null) {
                CompositeJSBlock.$$$reportNull$$$0(4);
            }
            return childAttributes;
        }
        if (this.myBlockElementType == JSElementTypes.SWITCH_STATEMENT) {
            JSBlock previousJSBlock = JSBlock.getPreviousJSBlock(this.getSubBlocks(), newChildIndex);
            ChildAttributes childAttributes = new ChildAttributes(JSBlock.calculateIndentInSwitch(previousJSBlock, this.myCommonSettings), null);
            if (childAttributes == null) {
                CompositeJSBlock.$$$reportNull$$$0(5);
            }
            return childAttributes;
        }
        ChildAttributes childAttributes = new ChildAttributes(Indent.getNormalIndent(), null);
        if (childAttributes == null) {
            CompositeJSBlock.$$$reportNull$$$0(6);
        }
        return childAttributes;
    }

    @Nullable
    public Language getLanguage() {
        return this.myLanguage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childBlocks";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spacingStrategy";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockContext";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/formatter/blocks/CompositeJSBlock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/formatter/blocks/CompositeJSBlock";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

