/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementFactory;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSInheritedLanguagesHelper;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptParenthesizedType;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.util.ParenthesesUtils;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSRemoveUnnecessaryParenthesesInspection
extends JSInspection
implements CleanupLocalInspectionTool {
    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"unnecessary.parentheses.display.name", (Object[])new Object[0]);
        if (string == null) {
            JSRemoveUnnecessaryParenthesesInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSParenthesizedExpression(JSParenthesizedExpression element) {
                if (!JSInheritedLanguagesHelper.isRemoveUnnecessaryParenthesesEnabled((PsiElement)element)) {
                    return;
                }
                if (ParenthesesUtils.canRemoveParentheses(element)) {
                    holder.registerProblem((PsiElement)element, JSBundle.message((String)"unnecessary.parentheses.problem.descriptor", (Object[])new Object[0]), new LocalQuickFix[]{new RemoveParenthesesFix((PsiElement)element)});
                }
            }

            public void visitTypeScriptParenthesizedType(TypeScriptParenthesizedType type) {
                if (!JSInheritedLanguagesHelper.isRemoveUnnecessaryParenthesesEnabled((PsiElement)type)) {
                    return;
                }
                if (!(type.getParent() instanceof TypeScriptParenthesizedType) && JSRemoveUnnecessaryParenthesesInspection.canRemoveParenthesesInType(type)) {
                    holder.registerProblem((PsiElement)type, JSBundle.message((String)"unnecessary.parentheses.problem.descriptor", (Object[])new Object[0]), new LocalQuickFix[]{new RemoveParenthesesFix((PsiElement)type)});
                }
                super.visitTypeScriptParenthesizedType(type);
            }

            public void visitJSParameterList(JSParameterList element) {
                if (!JSInheritedLanguagesHelper.isRemoveUnnecessaryParenthesesEnabled((PsiElement)element)) {
                    return;
                }
                JSFunctionExpression functionExpression = (JSFunctionExpression)ObjectUtils.tryCast((Object)element.getParent(), JSFunctionExpression.class);
                if (DialectDetector.hasFeature((PsiElement)element, JSLanguageFeature.ARROW_FUNCTIONS) && functionExpression != null && JSPsiImplUtils.isArrowFunction((JSFunction)functionExpression) && element.getNode().findChildByType(JSTokenTypes.LPAR) != null && !JSPsiImplUtils.parensAroundArrowFunctionParametersRequired(element, (JSFunction)functionExpression)) {
                    holder.registerProblem((PsiElement)element, JSBundle.message((String)"unnecessary.parentheses.problem.descriptor", (Object[])new Object[0]), new LocalQuickFix[]{new RemoveParenthesesFix((PsiElement)element)});
                }
            }
        };
        if (jSElementVisitor == null) {
            JSRemoveUnnecessaryParenthesesInspection.$$$reportNull$$$0(1);
        }
        return jSElementVisitor;
    }

    private static boolean canRemoveParenthesesInType(@NotNull TypeScriptParenthesizedType parenthesized) {
        if (parenthesized == null) {
            JSRemoveUnnecessaryParenthesesInspection.$$$reportNull$$$0(2);
        }
        if (DialectDetector.isFlow((PsiElement)parenthesized)) {
            return false;
        }
        PsiElement parent = parenthesized.getParent();
        if (!(parent instanceof JSTypeDeclaration)) {
            return true;
        }
        JSTypeDeclaration element = TypeScriptPsiUtil.unparenthesizeType((JSTypeDeclaration)parenthesized);
        if (element == null) {
            return false;
        }
        return TypeScriptUtil.getTypePrecedence((JSTypeDeclaration)parent) > TypeScriptUtil.getTypePrecedence(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSRemoveUnnecessaryParenthesesInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parenthesized";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSRemoveUnnecessaryParenthesesInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canRemoveParenthesesInType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RemoveParenthesesFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        protected RemoveParenthesesFix(@Nullable PsiElement element) {
            super(element);
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JSBundle.message((String)"remove.unnecessary.parentheses.fix.text", (Object[])new Object[0]);
            if (string == null) {
                RemoveParenthesesFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                RemoveParenthesesFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file2, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            PsiElement element;
            if (project == null) {
                RemoveParenthesesFix.$$$reportNull$$$0(2);
            }
            if (file2 == null) {
                RemoveParenthesesFix.$$$reportNull$$$0(3);
            }
            if (startElement == null) {
                RemoveParenthesesFix.$$$reportNull$$$0(4);
            }
            if (endElement == null) {
                RemoveParenthesesFix.$$$reportNull$$$0(5);
            }
            if ((element = startElement) instanceof TypeScriptParenthesizedType) {
                JSTypeDeclaration inner = TypeScriptPsiUtil.unparenthesizeType((JSTypeDeclaration)element);
                if (inner == null) {
                    return;
                }
                element.replace((PsiElement)JSChangeUtil.createTypeScriptType(inner.getText(), element));
                return;
            }
            if (element instanceof JSParameterList) {
                PsiElement first = element.getFirstChild();
                while (first instanceof PsiWhiteSpace || first.getNode().getElementType() == JSTokenTypes.LPAR) {
                    first.delete();
                    first = element.getFirstChild();
                }
                PsiElement last = element.getLastChild();
                while (last instanceof PsiWhiteSpace || last.getNode().getElementType() == JSTokenTypes.RPAR) {
                    last.delete();
                    last = element.getFirstChild();
                }
                return;
            }
            if (element instanceof JSExpression) {
                JSExpression exp = (JSExpression)element;
                while (exp.getParent() instanceof JSExpression && !(exp.getParent() instanceof JSFunctionExpression)) {
                    exp = (JSExpression)exp.getParent();
                }
                JSElementFactory.replaceExpression(exp, ParenthesesUtils.removeParentheses(exp));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSRemoveUnnecessaryParenthesesInspection$RemoveParenthesesFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSRemoveUnnecessaryParenthesesInspection$RemoveParenthesesFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

