/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListUtil;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.util.FilePathByPathComparator;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.integrate.BaseMergeTask;
import org.jetbrains.idea.svn.integrate.Intersection;
import org.jetbrains.idea.svn.integrate.LocalChangesAction;
import org.jetbrains.idea.svn.integrate.QuickMerge;

public class LocalChangesPromptTask
extends BaseMergeTask {
    private static final Logger LOG = Logger.getInstance(LocalChangesPromptTask.class);
    @Nullable
    private final List<SvnChangeList> myChangeListsToMerge;
    @NotNull
    private final Runnable myCallback;

    public LocalChangesPromptTask(@NotNull QuickMerge mergeProcess, @Nullable List<SvnChangeList> changeListsToMerge, @NotNull Runnable callback) {
        if (mergeProcess == null) {
            LocalChangesPromptTask.$$$reportNull$$$0(0);
        }
        if (callback == null) {
            LocalChangesPromptTask.$$$reportNull$$$0(1);
        }
        super(mergeProcess);
        this.myChangeListsToMerge = changeListsToMerge;
        this.myCallback = callback;
    }

    @Nullable
    private File getLocalPath(@NotNull String repositoryRelativePath) {
        if (repositoryRelativePath == null) {
            LocalChangesPromptTask.$$$reportNull$$$0(2);
        }
        try {
            Url url = SvnUtil.append(this.myMergeContext.getWcInfo().getRepoUrl(), repositoryRelativePath);
            return SvnUtil.isAncestor(this.myMergeContext.getSourceUrl(), url) ? new File(this.myMergeContext.getWcInfo().getPath(), SvnUtil.getRelativeUrl(this.myMergeContext.getSourceUrl(), url)) : null;
        }
        catch (SvnBindException e) {
            LOG.info((Throwable)((Object)e));
            return null;
        }
    }

    @Override
    public void run() {
        List localChangeLists = ChangeListManager.getInstance((Project)this.myMergeContext.getProject()).getChangeListsCopy();
        Intersection intersection = this.myChangeListsToMerge != null ? this.getChangesIntersection(localChangeLists, this.myChangeListsToMerge) : LocalChangesPromptTask.getAllChangesIntersection(localChangeLists);
        this.processIntersection(intersection);
    }

    private void processIntersection(@Nullable Intersection intersection) {
        boolean mergeAll = this.myChangeListsToMerge == null;
        LocalChangesAction nextAction = !Intersection.isEmpty(intersection) ? this.myInteraction.selectLocalChangesAction(mergeAll) : LocalChangesAction.continueMerge;
        switch (nextAction) {
            case continueMerge: {
                this.myCallback.run();
                break;
            }
            case shelve: {
                this.myMergeProcess.runInBackground("Shelving local changes before merge", (ThrowableConsumer<ProgressIndicator, VcsException>)((ThrowableConsumer)indicator -> {
                    this.shelveChanges(intersection);
                    this.myCallback.run();
                }));
                break;
            }
            case inspect: {
                List intersectedPaths = ContainerUtil.sorted((Collection)ChangesUtil.getPaths(intersection.getAllChanges()), (Comparator)FilePathByPathComparator.getInstance());
                this.myInteraction.showIntersectedLocalPaths(intersectedPaths);
                break;
            }
        }
    }

    private void shelveChanges(@NotNull Intersection intersection) throws VcsException {
        if (intersection == null) {
            LocalChangesPromptTask.$$$reportNull$$$0(3);
        }
        try {
            ApplicationManager.getApplication().invokeAndWait(() -> FileDocumentManager.getInstance().saveAllDocuments());
            ShelveChangesManager shelveManager = ShelveChangesManager.getInstance((Project)this.myMergeContext.getProject());
            for (Map.Entry<String, List<Change>> entry : intersection.getChangesByLists().entrySet()) {
                String shelfName = ChangeListUtil.createSystemShelvedChangeListName((String)VcsBundle.message((String)"stash.changes.message", (Object[])new Object[]{"merge"}), (String)intersection.getComment(entry.getKey()));
                shelveManager.shelveChanges((Collection)entry.getValue(), shelfName, true, true);
            }
        }
        catch (IOException e) {
            throw new VcsException((Throwable)e);
        }
    }

    @Nullable
    private Intersection getChangesIntersection(@NotNull List<LocalChangeList> localChangeLists, @NotNull List<SvnChangeList> changeListsToMerge) {
        if (localChangeLists == null) {
            LocalChangesPromptTask.$$$reportNull$$$0(4);
        }
        if (changeListsToMerge == null) {
            LocalChangesPromptTask.$$$reportNull$$$0(5);
        }
        Set<FilePath> pathsToMerge = this.collectPaths(changeListsToMerge);
        return !changeListsToMerge.isEmpty() ? LocalChangesPromptTask.getChangesIntersection(localChangeLists, (Condition<Change>)((Condition)change -> LocalChangesPromptTask.hasPathToMerge(change, pathsToMerge))) : null;
    }

    @NotNull
    private Set<FilePath> collectPaths(@NotNull List<SvnChangeList> lists) {
        if (lists == null) {
            LocalChangesPromptTask.$$$reportNull$$$0(6);
        }
        Set<FilePath> set = lists.stream().flatMap(list -> list.getAffectedPaths().stream()).map(this::getLocalPath).filter(Objects::nonNull).map(localPath -> VcsUtil.getFilePath((File)localPath, (boolean)false)).collect(Collectors.toSet());
        if (set == null) {
            LocalChangesPromptTask.$$$reportNull$$$0(7);
        }
        return set;
    }

    @NotNull
    private static Intersection getAllChangesIntersection(@NotNull List<LocalChangeList> localChangeLists) {
        if (localChangeLists == null) {
            LocalChangesPromptTask.$$$reportNull$$$0(8);
        }
        Intersection intersection = LocalChangesPromptTask.getChangesIntersection(localChangeLists, (Condition<Change>)Conditions.alwaysTrue());
        if (intersection == null) {
            LocalChangesPromptTask.$$$reportNull$$$0(9);
        }
        return intersection;
    }

    @NotNull
    private static Intersection getChangesIntersection(@NotNull List<LocalChangeList> changeLists, @NotNull Condition<Change> filter) {
        if (changeLists == null) {
            LocalChangesPromptTask.$$$reportNull$$$0(10);
        }
        if (filter == null) {
            LocalChangesPromptTask.$$$reportNull$$$0(11);
        }
        Intersection result = new Intersection();
        for (LocalChangeList changeList : changeLists) {
            for (Change change : changeList.getChanges()) {
                if (!filter.value((Object)change)) continue;
                result.add(changeList, change);
            }
        }
        Intersection intersection = result;
        if (intersection == null) {
            LocalChangesPromptTask.$$$reportNull$$$0(12);
        }
        return intersection;
    }

    private static boolean hasPathToMerge(@NotNull Change change, @NotNull Set<FilePath> pathsToMerge) {
        if (change == null) {
            LocalChangesPromptTask.$$$reportNull$$$0(13);
        }
        if (pathsToMerge == null) {
            LocalChangesPromptTask.$$$reportNull$$$0(14);
        }
        FilePath beforePath = ChangesUtil.getBeforePath((Change)change);
        FilePath afterPath = ChangesUtil.getAfterPath((Change)change);
        return beforePath != null && pathsToMerge.contains(beforePath) || afterPath != null && pathsToMerge.contains(afterPath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergeProcess";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryRelativePath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intersection";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localChangeLists";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeListsToMerge";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lists";
                break;
            }
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/integrate/LocalChangesPromptTask";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeLists";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathsToMerge";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/integrate/LocalChangesPromptTask";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPaths";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllChangesIntersection";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangesIntersection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLocalPath";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "shelveChanges";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getChangesIntersection";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectPaths";
                break;
            }
            case 7: 
            case 9: 
            case 12: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAllChangesIntersection";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "hasPathToMerge";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

