/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex.content;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.w3c.dom.Element;
import writer2latex.latex.Context;
import writer2latex.latex.ConverterHelper;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.util.Config;
import writer2latex.util.ExportNameCollection;

public class FieldConverter
extends ConverterHelper {
    private ExportNameCollection targets = new ExportNameCollection(true);
    private ExportNameCollection refnames = new ExportNameCollection(true);
    private ExportNameCollection bookmarknames = new ExportNameCollection(true);
    private ExportNameCollection seqrefnames = new ExportNameCollection(true);
    private boolean bUsesPageCount = false;

    public FieldConverter(Config config, ConverterPalette palette) {
        super(config, palette);
    }

    public void appendDeclarations(LaTeXDocumentPortion pack, LaTeXDocumentPortion decl) {
        if (this.bUsesPageCount) {
            pack.append("\\usepackage{lastpage}").nl();
        }
        if (this.config.useHyperref()) {
            pack.append("\\usepackage{hyperref}").nl();
            pack.append("\\hypersetup{");
            if (this.config.getBackend() == 2) {
                pack.append("pdftex, ");
            } else if (this.config.getBackend() == 1) {
                pack.append("dvips, ");
            }
            pack.append("colorlinks=true, linkcolor=blue, filecolor=blue, pagecolor=blue, urlcolor=blue");
            if (this.config.getBackend() == 2) {
                pack.append(this.createPdfMeta("pdftitle", this.palette.getMetaData().getTitle())).append(this.createPdfMeta("pdfauthor", this.palette.getMetaData().getCreator())).append(this.createPdfMeta("pdfsubject", this.palette.getMetaData().getSubject())).append(this.createPdfMeta("pdfkeywords", this.palette.getMetaData().getKeywords()));
            }
            pack.append("}").nl();
        }
    }

    public void addSequenceName(String sName) {
        this.seqrefnames.addName(this.urlDecode(sName));
    }

    public void handleSequence(Element node, LaTeXDocumentPortion ldp, Context oc) {
        this.palette.getInlineCv().traversePCDATA(node, ldp, oc);
        String sName = node.getAttribute("text:ref-name");
        if (sName != null && this.seqrefnames.containsName(sName)) {
            ldp.append("\\label{seq:" + this.seqrefnames.getExportName(sName) + "}");
        }
    }

    public void handleSequenceRef(Element node, LaTeXDocumentPortion ldp, Context oc) {
        String sFormat = node.getAttribute("text:reference-format");
        String sName = node.getAttribute("text:ref-name");
        if ("page".equals(sFormat) && sName != null) {
            ldp.append("\\pageref{seq:" + this.seqrefnames.getExportName(sName) + "}");
        } else {
            this.palette.getInlineCv().traversePCDATA(node, ldp, oc);
        }
    }

    public void addReferenceName(String sName) {
        this.refnames.addName(this.urlDecode(sName));
    }

    public void handleReferenceMark(Element node, LaTeXDocumentPortion ldp, Context oc) {
        String sName = node.getAttribute("text:name");
        if (sName != null) {
            ldp.append("\\label{ref:" + this.refnames.getExportName(sName) + "}");
        }
    }

    public void handleReferenceRef(Element node, LaTeXDocumentPortion ldp, Context oc) {
        String sFormat = node.getAttribute("text:reference-format");
        String sName = node.getAttribute("text:ref-name");
        if ("page".equals(sFormat) && sName != null) {
            ldp.append("\\pageref{ref:" + this.refnames.getExportName(sName) + "}");
        } else {
            this.palette.getInlineCv().traversePCDATA(node, ldp, oc);
        }
    }

    public void addBookmarkName(String sName) {
        this.bookmarknames.addName(this.urlDecode(sName));
    }

    public void handleBookmark(Element node, LaTeXDocumentPortion ldp, Context oc) {
        String sName = node.getAttribute("text:name");
        if (sName != null) {
            this.addTarget(node, "", ldp);
            if (this.bookmarknames.containsName(sName)) {
                ldp.append("\\label{bkm:" + this.bookmarknames.getExportName(sName) + "}");
            }
        }
    }

    public void handleBookmarkRef(Element node, LaTeXDocumentPortion ldp, Context oc) {
        String sFormat = node.getAttribute("text:reference-format");
        String sName = node.getAttribute("text:ref-name");
        if ("page".equals(sFormat) && sName != null) {
            ldp.append("\\pageref{bkm:" + this.bookmarknames.getExportName(sName) + "}");
        } else {
            this.palette.getInlineCv().traversePCDATA(node, ldp, oc);
        }
    }

    public void handleAnchor(Element node, LaTeXDocumentPortion ldp, Context oc) {
        String sHref = node.getAttribute("xlink:href");
        if (sHref != null) {
            if (sHref.startsWith("#")) {
                if (this.config.useHyperref()) {
                    ldp.append("\\hyperlink{").append(this.targets.getExportName(this.urlDecode(sHref.substring(1)))).append("}{");
                    this.palette.getInlineCv().traverseInlineText(node, ldp, oc, false);
                    ldp.append("}");
                } else {
                    this.palette.getInlineCv().traverseInlineText(node, ldp, oc, true);
                }
            } else if (this.config.useHyperref()) {
                ldp.append("\\href{").append(this.urlDecode(sHref)).append("}{");
                this.palette.getInlineCv().traverseInlineText(node, ldp, oc, false);
                ldp.append("}");
            } else {
                this.palette.getInlineCv().traverseInlineText(node, ldp, oc, true);
            }
        } else {
            this.palette.getInlineCv().traverseInlineText(node, ldp, oc, true);
        }
    }

    public void addTargetName(String sName) {
        this.targets.addName(this.urlDecode(sName));
    }

    public void addTarget(Element node, String sSuffix, LaTeXDocumentPortion ldp) {
        String sName = node.getAttribute("text:name");
        if (sName == null) {
            sName = node.getAttribute("table:name");
        }
        if (sName == null || !this.config.useHyperref()) {
            return;
        }
        if (!this.targets.containsName(sName + sSuffix)) {
            return;
        }
        ldp.append("\\hypertarget{").append(this.targets.getExportName(sName + sSuffix)).append("}{}");
    }

    public void handlePageNumber(Element node, LaTeXDocumentPortion ldp, Context oc) {
        ldp.append("\\thepage{}");
    }

    public void handlePageCount(Element node, LaTeXDocumentPortion ldp, Context oc) {
        if (this.config.useLastpage()) {
            this.bUsesPageCount = true;
            ldp.append("\\pageref{LastPage}");
        } else {
            ldp.append("?");
        }
    }

    private String createPdfMeta(String sName, String sValue) {
        if (sValue == null) {
            return "";
        }
        sValue = sValue.replace(',', ';');
        return ", " + sName + "=" + this.palette.getI18n().convert(sValue, false, this.palette.getMainContext().getLang());
    }

    private String urlDecode(String s) {
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }
}

