/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex.style;

import writer2latex.latex.Context;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.style.BeforeAfter;
import writer2latex.latex.style.ListStyleConverter;
import writer2latex.latex.style.StyleConverter;
import writer2latex.office.ParStyle;
import writer2latex.office.PropertySet;
import writer2latex.office.WriterStyleCollection;
import writer2latex.util.Config;
import writer2latex.util.Misc;

public class NoteConfigurationConverter
extends StyleConverter {
    public NoteConfigurationConverter(WriterStyleCollection wsc, Config config, ConverterPalette palette) {
        super(wsc, config, palette);
    }

    public void convertFootnotesConfiguration(LaTeXDocumentPortion ldp) {
        this.convertFootEndnotesConfiguration(this.wsc.getFootnotesConfiguration(), "foot", ldp);
    }

    public void convertEndnotesConfiguration(LaTeXDocumentPortion ldp) {
        this.convertFootEndnotesConfiguration(this.wsc.getEndnotesConfiguration(), "end", ldp);
    }

    private void convertFootEndnotesConfiguration(PropertySet notes, String sType, LaTeXDocumentPortion ldp) {
        int nStartValue;
        String sTypeShort;
        if (this.config.formatting() < 2) {
            return;
        }
        String string = sTypeShort = sType.equals("foot") ? "fn" : "en";
        if (notes == null) {
            return;
        }
        ldp.append("% ").append(sType).append("notes configuration").nl().append("\\makeatletter").nl();
        String sFormat = notes.getProperty("style:num-format");
        if (sFormat != null) {
            ldp.append("\\renewcommand\\the").append(sType).append("note{").append(ListStyleConverter.numFormat(sFormat)).append("{").append(sType).append("note}}").nl();
        }
        if ("chapter".equals(notes.getProperty("text:start-numbering-at"))) {
            ldp.append("\\@addtoreset{").append(sType).append("note}{section}").nl();
        }
        if ((nStartValue = Misc.getPosInteger(notes.getProperty("text:start-value"), 0)) != 0) {
            ldp.append("\\setcounter{").append(sType).append("note}{" + nStartValue + "}").nl();
        }
        if (this.config.formatting() >= 3) {
            String sCitBodyStyle = notes.getProperty("text:citation-body-style-name");
            if (sCitBodyStyle != null && this.wsc.getTextStyle(sCitBodyStyle) != null) {
                BeforeAfter baText = new BeforeAfter();
                this.palette.getCharSc().applyTextStyle(sCitBodyStyle, baText, new Context());
                ldp.append("\\renewcommand\\@make").append(sTypeShort).append("mark{\\mbox{").append(baText.getBefore()).append("\\@the").append(sTypeShort).append("mark").append(baText.getAfter()).append("}}").nl();
            }
            String sCitStyle = notes.getProperty("text:citation-style-name");
            String sStyleName = notes.getProperty("text:default-style-name");
            if (sStyleName != null) {
                BeforeAfter baText = new BeforeAfter();
                this.palette.getCharSc().applyTextStyle(sCitStyle, baText, new Context());
                ParStyle style = this.wsc.getParStyle(sStyleName);
                if (style != null) {
                    BeforeAfter baPar = new BeforeAfter();
                    this.palette.getCharSc().applyHardCharFormatting(style, baPar);
                    ldp.append("\\renewcommand\\@make").append(sTypeShort).append("text[1]{\\noindent").append(baText.getBefore()).append("\\@the").append(sTypeShort).append("mark\\ ").append(baText.getAfter()).append(baPar.getBefore()).append("#1").append(baPar.getAfter());
                    ldp.append("}").nl();
                }
            }
        }
        ldp.append("\\makeatother").nl();
    }
}

