/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import org.apache.xalan.xpath.xml.FormatterToXML;
import org.apache.xalan.xpath.xml.TreeWalker;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.InputSource;

public class ApplyXPath {
    protected String filename;
    protected String xpath;

    public void doMain(String[] stringArray) {
        this.filename = stringArray[0];
        this.xpath = stringArray[1];
        if (this.filename != null && this.filename.length() > 0 && this.xpath != null && this.xpath.length() > 0) {
            InputSource inputSource;
            try {
                inputSource = new InputSource(new FileInputStream(this.filename));
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("FileInputStream of " + this.filename + " threw: " + fileNotFoundException.toString());
                fileNotFoundException.printStackTrace();
                return;
            }
            DOMParser dOMParser = new DOMParser();
            try {
                dOMParser.parse(inputSource);
            }
            catch (Exception exception) {
                System.err.println("Parsing " + this.filename + " threw: " + exception.toString());
                exception.printStackTrace();
                return;
            }
            Element element = dOMParser.getDocument().getDocumentElement();
            NodeList nodeList = null;
            try {
                nodeList = XPathAPI.selectNodeList(element, this.xpath);
                FormatterToXML formatterToXML = new FormatterToXML((OutputStream)System.out);
                TreeWalker treeWalker = new TreeWalker((DocumentHandler)formatterToXML);
                int n = nodeList.getLength();
                int n2 = 0;
                while (n2 < n) {
                    treeWalker.traverse(nodeList.item(n2));
                    formatterToXML.flush();
                    formatterToXML.flushWriter();
                    ++n2;
                }
                return;
            }
            catch (Exception exception) {
                System.err.println("selectNodeList threw: " + exception.toString() + " perhaps your xpath didn't select any nodes");
                exception.printStackTrace();
                return;
            }
        }
        System.out.println("Bad input args: " + this.filename + ", " + this.xpath);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            System.out.println("java ApplyXPath filename.xml xpath\nReads filename.xml and applies the xpath; prints the nodelist found.");
            return;
        }
        ApplyXPath applyXPath = new ApplyXPath();
        System.out.println("<output>");
        applyXPath.doMain(stringArray);
        System.out.println("</output>");
    }
}

