/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp.scripting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.armedbear.lisp.scripting.AbclScriptEngine;

public class AbclScriptEngineFactory
implements ScriptEngineFactory {
    private static AbclScriptEngine THE_ONLY_ONE_ENGINE = null;

    @Override
    public String getEngineName() {
        return "ABCL Script";
    }

    @Override
    public String getEngineVersion() {
        return "0.1";
    }

    @Override
    public List<String> getExtensions() {
        ArrayList<String> extensions = new ArrayList<String>(1);
        extensions.add("lisp");
        return Collections.unmodifiableList(extensions);
    }

    @Override
    public String getLanguageName() {
        return "ANSI Common Lisp";
    }

    @Override
    public String getLanguageVersion() {
        return "ANSI X3.226:1994";
    }

    public static String escape(String raw) {
        StringBuilder sb = new StringBuilder();
        int len = raw.length();
        for (int i = 0; i < len; ++i) {
            char c = raw.charAt(i);
            if (c != '\"') {
                sb.append(c);
                continue;
            }
            sb.append("\\\"");
        }
        return sb.toString();
    }

    @Override
    public String getMethodCallSyntax(String obj, String method, String ... args) {
        StringBuilder sb = new StringBuilder();
        sb.append("(jcall \"");
        sb.append(method);
        sb.append("\" ");
        sb.append(obj);
        for (String arg : args) {
            sb.append(" ");
            sb.append(arg);
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public List<String> getMimeTypes() {
        return Collections.unmodifiableList(new ArrayList());
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>(1);
        names.add("ABCL");
        names.add("cl");
        names.add("Lisp");
        names.add("Common Lisp");
        return Collections.unmodifiableList(names);
    }

    @Override
    public String getOutputStatement(String str) {
        return "(cl:print \"" + str + "\")";
    }

    @Override
    public Object getParameter(String key) {
        return null;
    }

    @Override
    public String getProgram(String ... statements) {
        StringBuilder sb = new StringBuilder();
        sb.append("(cl:progn");
        for (String stmt : statements) {
            sb.append("\n\t");
            sb.append(stmt);
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public synchronized ScriptEngine getScriptEngine() {
        if (THE_ONLY_ONE_ENGINE == null) {
            THE_ONLY_ONE_ENGINE = new AbclScriptEngine();
        }
        return THE_ONLY_ONE_ENGINE;
    }
}

