/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language;

import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringEncoder;

public class Soundex
implements StringEncoder {
    public static final char[] US_ENGLISH_MAPPING = "01230120022455012623010202".toCharArray();
    public static final Soundex US_ENGLISH = new Soundex();
    private char[] soundexMapping;
    private int maxLength = 4;

    public Soundex() {
        this(US_ENGLISH_MAPPING);
    }

    public Soundex(char[] mapping) {
        this.soundexMapping = mapping;
    }

    /*
     * WARNING - void declaration
     */
    public String soundex(String str) {
        char mapped;
        if (null == str || str.length() == 0) {
            return str;
        }
        char[] out = new char[]{'0', '0', '0', '0'};
        int incount = 1;
        int count = 1;
        out[0] = Character.toUpperCase(str.charAt(0));
        char last = this.getMappingCode(str.charAt(0));
        while (incount < str.length() && (mapped = this.getMappingCode(str.charAt(incount++))) != '\u0000' && count < this.maxLength) {
            void var4_6;
            if (var4_6 != 48 && var4_6 != last) {
                out[count++] = var4_6;
            }
            last = var4_6;
        }
        return new String(out);
    }

    public Object encode(Object pObject) throws EncoderException {
        if (!(pObject instanceof String)) {
            throw new EncoderException("Parameter supplied to Soundex encode is not of type java.lang.String");
        }
        String result = this.soundex((String)pObject);
        return result;
    }

    public String encode(String pString) throws EncoderException {
        return this.soundex(pString);
    }

    private char getMappingCode(char c) {
        if (!Character.isLetter(c)) {
            return '\u0000';
        }
        return this.soundexMapping[Character.toUpperCase(c) - 65];
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }
}

